/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.writer;

import org.apache.amoro.data.ChangeAction;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.writer.ChangeTaskWriter;
import org.apache.amoro.io.writer.OutputFileFactory;
import org.apache.amoro.io.writer.RecordWithAction;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.utils.SchemaUtil;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.FileAppenderFactory;

public class GenericChangeTaskWriter
extends ChangeTaskWriter<Record> {
    private final Schema joinSchema;
    private final InternalRecordWrapper wrapper;
    private final ChangeAction writeAction;

    public GenericChangeTaskWriter(FileFormat format, FileAppenderFactory<Record> appenderFactory, OutputFileFactory outputFileFactory, AuthenticatedFileIO io, long targetFileSize, long mask, Schema schema, PartitionSpec spec, PrimaryKeySpec primaryKeySpec, ChangeAction writeAction, boolean orderedWriter) {
        super(format, appenderFactory, outputFileFactory, io, targetFileSize, mask, schema, spec, primaryKeySpec, orderedWriter);
        this.joinSchema = SchemaUtil.changeWriteSchema(schema);
        this.wrapper = new InternalRecordWrapper(schema.asStruct());
        this.writeAction = writeAction;
    }

    @Override
    protected StructLike asStructLike(Record data) {
        return this.wrapper.wrap((StructLike)data);
    }

    @Override
    protected Record appendMetaColumns(Record data, Long fileOffset) {
        int i;
        GenericRecord joinRecord = GenericRecord.create((Schema)this.joinSchema);
        for (i = 0; i < data.size(); ++i) {
            joinRecord.set(i, data.get(i));
        }
        joinRecord.set(i, (Object)fileOffset);
        return joinRecord;
    }

    @Override
    protected ChangeAction action(Record data) {
        if (data instanceof RecordWithAction) {
            return ((RecordWithAction)data).getAction();
        }
        return this.writeAction;
    }
}

