/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.reader;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.encryption.EncryptedFiles;
import org.apache.iceberg.encryption.EncryptedInputFile;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.types.Types;
import org.apache.orc.TypeDescription;
import org.apache.parquet.schema.MessageType;

public class BaseIcebergPosDeleteReader {
    private static final Schema POS_DELETE_SCHEMA = new Schema(new Types.NestedField[]{MetadataColumns.DELETE_FILE_PATH, MetadataColumns.DELETE_FILE_POS});
    private static final Accessor<StructLike> FILENAME_ACCESSOR = POS_DELETE_SCHEMA.accessorForField(MetadataColumns.DELETE_FILE_PATH.fieldId());
    private static final Accessor<StructLike> POSITION_ACCESSOR = POS_DELETE_SCHEMA.accessorForField(MetadataColumns.DELETE_FILE_POS.fieldId());
    protected final AuthenticatedFileIO fileIO;
    protected final EncryptionManager encryptionManager;
    protected final List<DeleteFile> posDeleteFiles;

    public BaseIcebergPosDeleteReader(AuthenticatedFileIO fileIO, EncryptionManager encryptionManager, List<DeleteFile> posDeleteFiles) {
        this.fileIO = fileIO;
        this.encryptionManager = encryptionManager;
        this.posDeleteFiles = posDeleteFiles;
    }

    public CloseableIterable<Record> readDeletes() {
        List deletes = Lists.transform(this.posDeleteFiles, this::readDelete);
        return CloseableIterable.concat((Iterable)deletes);
    }

    public String readPath(Record record) {
        return (String)FILENAME_ACCESSOR.get((Object)record);
    }

    public Long readPos(Record record) {
        return (Long)POSITION_ACCESSOR.get((Object)record);
    }

    private CloseableIterable<Record> readDelete(DeleteFile deleteFile) {
        EncryptedInputFile encryptedInput = EncryptedFiles.encryptedInput((InputFile)this.fileIO.newInputFile(deleteFile.path().toString()), (ByteBuffer)deleteFile.keyMetadata());
        InputFile input = this.encryptionManager.decrypt(encryptedInput);
        switch (deleteFile.format()) {
            case PARQUET: {
                Parquet.ReadBuilder builder = Parquet.read((InputFile)input).project(POS_DELETE_SCHEMA).reuseContainers().createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)POS_DELETE_SCHEMA, (MessageType)fileSchema));
                return this.fileIO.doAs(() -> ((Parquet.ReadBuilder)builder).build());
            }
            case ORC: {
                return ORC.read((InputFile)input).project(POS_DELETE_SCHEMA).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)POS_DELETE_SCHEMA, (TypeDescription)fileSchema)).build();
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot read deletes, %s is not a supported format: %s", deleteFile.format().name(), deleteFile.path()));
    }
}

