/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rel.agg;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite3.internal.sql.engine.rel.IgniteAggregate;
import org.apache.ignite3.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite3.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite3.internal.sql.engine.trait.TraitsAwareIgniteRel;
import org.apache.ignite3.internal.sql.engine.util.Commons;

public abstract class IgniteColocatedAggregateBase
extends IgniteAggregate
implements TraitsAwareIgniteRel {
    IgniteColocatedAggregateBase(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traitSet, input, groupSet, groupSets, aggCalls);
    }

    IgniteColocatedAggregateBase(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        if (TraitUtils.distribution(nodeTraits) == IgniteDistributions.single()) {
            return Pair.of((Object)nodeTraits, Commons.transform(inTraits, t -> t.replace((RelTrait)IgniteDistributions.single())));
        }
        return null;
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        IgniteDistribution inDistribution = TraitUtils.distribution(inputTraits.get(0));
        if (inDistribution.satisfies((RelTrait)IgniteDistributions.single())) {
            return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)inDistribution), inputTraits));
        }
        if (this.groupSet.isEmpty()) {
            return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)IgniteDistributions.single()), List.of(inputTraits.get(0).replace((RelTrait)IgniteDistributions.single()))));
        }
        if (inDistribution.getType() == RelDistribution.Type.HASH_DISTRIBUTED && this.groupSet.contains(ImmutableBitSet.of((ImmutableIntList)inDistribution.getKeys()))) {
            IgniteDistribution outDistribution = inDistribution.apply((Mappings.TargetMapping)Commons.trimmingMapping(this.rowType.getFieldCount(), this.groupSet));
            return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)outDistribution), inputTraits));
        }
        IgniteDistribution newInDistribution = IgniteDistributions.hash(this.groupSet.asList());
        IgniteDistribution newOutDistribution = newInDistribution.apply((Mappings.TargetMapping)Commons.trimmingMapping(this.rowType.getFieldCount(), this.groupSet));
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)IgniteDistributions.single()), List.of(inputTraits.get(0).replace((RelTrait)IgniteDistributions.single()))), Pair.of((Object)nodeTraits.replace((RelTrait)newOutDistribution), List.of(inputTraits.get(0).replace((RelTrait)newInDistribution))));
    }
}

