/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.cluster;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.cli.commands.cluster.init.ClusterInitOptions;
import org.apache.ignite.internal.cli.core.call.CallInput;
import org.jetbrains.annotations.Nullable;

public class ClusterInitCallInput
implements CallInput {
    private final String clusterUrl;
    private final List<String> metaStorageNodes;
    private final List<String> cmgNodes;
    private final String clusterName;
    private final String clusterConfiguration;

    private ClusterInitCallInput(String clusterUrl, List<String> metaStorageNodes, List<String> cmgNodes, String clusterName, @Nullable String clusterConfiguration) {
        this.clusterUrl = clusterUrl;
        this.metaStorageNodes = metaStorageNodes;
        this.cmgNodes = cmgNodes;
        this.clusterName = clusterName;
        this.clusterConfiguration = clusterConfiguration;
    }

    public static ClusterInitCallInputBuilder builder() {
        return new ClusterInitCallInputBuilder();
    }

    public String getClusterUrl() {
        return this.clusterUrl;
    }

    public List<String> getMetaStorageNodes() {
        return this.metaStorageNodes;
    }

    public List<String> getCmgNodes() {
        return this.cmgNodes;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    @Nullable
    public String clusterConfiguration() {
        return this.clusterConfiguration;
    }

    public static class ClusterInitCallInputBuilder {
        private String clusterUrl;
        private List<String> metaStorageNodes;
        private List<String> cmgNodes;
        private String clusterName;
        @Nullable
        private String clusterConfiguration;

        public ClusterInitCallInputBuilder clusterConfiguration(String clusterConfiguration) {
            this.clusterConfiguration = clusterConfiguration;
            return this;
        }

        public ClusterInitCallInputBuilder clusterUrl(String clusterUrl) {
            this.clusterUrl = clusterUrl;
            return this;
        }

        public ClusterInitCallInputBuilder metaStorageNodes(List<String> metaStorageNodes) {
            this.metaStorageNodes = metaStorageNodes;
            return this;
        }

        public ClusterInitCallInputBuilder cmgNodes(List<String> cmgNodes) {
            this.cmgNodes = cmgNodes;
            return this;
        }

        public ClusterInitCallInputBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public ClusterInitCallInputBuilder fromClusterInitOptions(ClusterInitOptions clusterInitOptions) {
            this.metaStorageNodes = ClusterInitCallInputBuilder.trim(clusterInitOptions.metaStorageNodes());
            this.cmgNodes = ClusterInitCallInputBuilder.trim(clusterInitOptions.cmgNodes());
            this.clusterName = clusterInitOptions.clusterName();
            this.clusterConfiguration = clusterInitOptions.clusterConfiguration();
            return this;
        }

        public ClusterInitCallInput build() {
            return new ClusterInitCallInput(this.clusterUrl, this.metaStorageNodes, this.cmgNodes, this.clusterName, this.clusterConfiguration);
        }

        private static List<String> trim(List<String> input) {
            if (input.isEmpty()) {
                return input;
            }
            ArrayList<String> trimmed = new ArrayList<String>(input.size());
            for (String s : input) {
                trimmed.add(s.trim());
            }
            return trimmed;
        }
    }
}

