/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.metrics;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.helix.HelixException;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMBeanProvider;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMetric;
import org.apache.helix.monitoring.metrics.model.Metric;

public abstract class MetricCollector
extends DynamicMBeanProvider {
    private static final String CLUSTER_NAME_KEY = "ClusterName";
    private static final String ENTITY_NAME_KEY = "EntityName";
    private final String _monitorDomainName;
    private final String _clusterName;
    private final String _entityName;
    private Map<String, Metric> _metricMap;

    public MetricCollector(String monitorDomainName, String clusterName, String entityName) {
        this._monitorDomainName = monitorDomainName;
        this._clusterName = clusterName;
        this._entityName = entityName;
        this._metricMap = new HashMap<String, Metric>();
    }

    @Override
    public DynamicMBeanProvider register() throws JMException {
        HashSet dynamicMetrics = new HashSet();
        this._metricMap.values().forEach(metric -> dynamicMetrics.add(metric.getDynamicMetric()));
        String mbeanName = String.format("%s=%s, %s=%s", CLUSTER_NAME_KEY, this._clusterName, ENTITY_NAME_KEY, this._entityName);
        this.doRegister(dynamicMetrics, new ObjectName(String.format("%s:%s", this._monitorDomainName, mbeanName)));
        return this;
    }

    @Override
    public String getSensorName() {
        return String.format("%s.%s.%s", this._monitorDomainName, this._clusterName, this._entityName);
    }

    void addMetric(Metric metric) {
        if (!(metric instanceof DynamicMetric)) {
            throw new HelixException("MetricCollector only supports Metrics that are DynamicMetric!");
        }
        this._metricMap.putIfAbsent(metric.getMetricName(), metric);
    }

    public <T extends DynamicMetric> T getMetric(String metricName, Class<T> metricClass) {
        return (T)((DynamicMetric)metricClass.cast(this._metricMap.get(metricName)));
    }

    public Map<String, Metric> getMetricMap() {
        return this._metricMap;
    }
}

