/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ImmutableHRegionInfo;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class HRegionLocation
implements Comparable<HRegionLocation> {
    private final RegionInfo regionInfo;
    private final ServerName serverName;
    private final long seqNum;

    public HRegionLocation(RegionInfo regionInfo, ServerName serverName) {
        this(regionInfo, serverName, -1L);
    }

    public HRegionLocation(RegionInfo regionInfo, ServerName serverName, long seqNum) {
        this.regionInfo = regionInfo;
        this.serverName = serverName;
        this.seqNum = seqNum;
    }

    public String toString() {
        return "region=" + (this.regionInfo == null ? "null" : this.regionInfo.getRegionNameAsString()) + ", hostname=" + this.serverName + ", seqNum=" + this.seqNum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof HRegionLocation)) {
            return false;
        }
        return this.compareTo((HRegionLocation)o) == 0;
    }

    public int hashCode() {
        return this.serverName.hashCode();
    }

    @Deprecated
    public HRegionInfo getRegionInfo() {
        return this.regionInfo == null ? null : new ImmutableHRegionInfo(this.regionInfo);
    }

    public RegionInfo getRegion() {
        return this.regionInfo;
    }

    public String getHostname() {
        return this.serverName.getHostname();
    }

    public int getPort() {
        return this.serverName.getPort();
    }

    public long getSeqNum() {
        return this.seqNum;
    }

    public String getHostnamePort() {
        return Addressing.createHostAndPortStr(this.getHostname(), this.getPort());
    }

    public ServerName getServerName() {
        return this.serverName;
    }

    @Override
    public int compareTo(HRegionLocation o) {
        return this.serverName.compareTo(o.getServerName());
    }
}

