/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.config;

import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourceType;

public abstract class AbstractResourcePool<P extends ResourcePool, T extends ResourceType<P>>
implements ResourcePool {
    private final T type;
    private final boolean persistent;

    protected AbstractResourcePool(T type, boolean persistent) {
        if (type == null) {
            throw new NullPointerException("ResourceType may not be null");
        }
        this.type = type;
        this.persistent = persistent;
    }

    public T getType() {
        return this.type;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public void validateUpdate(ResourcePool newPool) {
        if (!this.getType().equals(newPool.getType())) {
            throw new IllegalArgumentException("ResourceType " + newPool.getType() + " can not replace " + this.getType());
        }
        if (this.isPersistent() != newPool.isPersistent()) {
            throw new IllegalArgumentException("ResourcePool for " + newPool.getType() + " with isPersistent=" + newPool.isPersistent() + " can not replace isPersistent=" + this.isPersistent());
        }
    }
}

