/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.ClusterLoadState;
import org.apache.hadoop.hbase.master.balancer.MetricsBalancer;
import org.apache.hadoop.hbase.master.balancer.RegionLocationFinder;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.hbase.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="All the unsynchronized access is before initialization")
public abstract class BaseLoadBalancer
implements LoadBalancer {
    private static final Logger LOG = LoggerFactory.getLogger(BaseLoadBalancer.class);
    public static final String BALANCER_DECISION_BUFFER_ENABLED = "hbase.master.balancer.decision.buffer.enabled";
    public static final boolean DEFAULT_BALANCER_DECISION_BUFFER_ENABLED = false;
    public static final String BALANCER_REJECTION_BUFFER_ENABLED = "hbase.master.balancer.rejection.buffer.enabled";
    public static final boolean DEFAULT_BALANCER_REJECTION_BUFFER_ENABLED = false;
    public static final boolean DEFAULT_HBASE_MASTER_LOADBALANCE_BYTABLE = false;
    protected static final int MIN_SERVER_BALANCE = 2;
    private volatile boolean stopped = false;
    private static final Predicate<ServerMetrics> IDLE_SERVER_PREDICATOR = load -> load.getRegionMetrics().isEmpty();
    protected volatile RegionLocationFinder regionFinder;
    protected boolean useRegionFinder;
    protected boolean isByTable = false;
    protected float slop;
    protected volatile RackManager rackManager;
    protected MetricsBalancer metricsBalancer = null;
    protected ClusterMetrics clusterStatus = null;
    protected ServerName masterServerName;
    protected MasterServices services;
    @Deprecated
    protected boolean onlySystemTablesOnMaster;

    protected BaseLoadBalancer() {
        this(null);
    }

    protected BaseLoadBalancer(MetricsBalancer metricsBalancer) {
        this.metricsBalancer = metricsBalancer != null ? metricsBalancer : new MetricsBalancer();
    }

    protected final Configuration getConf() {
        return this.services.getConfiguration();
    }

    @Deprecated
    public boolean shouldBeOnMaster(RegionInfo region) {
        return this.onlySystemTablesOnMaster && region.getTable().isSystemTable();
    }

    @Deprecated
    protected List<RegionPlan> balanceMasterRegions(Map<ServerName, List<RegionInfo>> clusterMap) {
        RegionPlan plan;
        if (this.masterServerName == null || clusterMap == null || clusterMap.size() <= 1) {
            return null;
        }
        ArrayList<RegionPlan> plans = null;
        List<RegionInfo> regions = clusterMap.get(this.masterServerName);
        if (regions != null) {
            Iterator<ServerName> keyIt = null;
            for (RegionInfo region : regions) {
                ServerName dest;
                if (this.shouldBeOnMaster(region)) continue;
                if (keyIt == null || !keyIt.hasNext()) {
                    keyIt = clusterMap.keySet().iterator();
                }
                if (this.masterServerName.equals((Object)(dest = keyIt.next()))) {
                    if (!keyIt.hasNext()) {
                        keyIt = clusterMap.keySet().iterator();
                    }
                    dest = keyIt.next();
                }
                plan = new RegionPlan(region, this.masterServerName, dest);
                if (plans == null) {
                    plans = new ArrayList<RegionPlan>();
                }
                plans.add(plan);
            }
        }
        for (Map.Entry<ServerName, List<RegionInfo>> server : clusterMap.entrySet()) {
            if (this.masterServerName.equals((Object)server.getKey())) continue;
            for (RegionInfo region : server.getValue()) {
                if (!this.shouldBeOnMaster(region)) continue;
                plan = new RegionPlan(region, server.getKey(), this.masterServerName);
                if (plans == null) {
                    plans = new ArrayList();
                }
                plans.add(plan);
            }
        }
        return plans;
    }

    @Deprecated
    @NonNull
    protected Map<ServerName, List<RegionInfo>> assignMasterSystemRegions(Collection<RegionInfo> regions, List<ServerName> servers) {
        TreeMap<ServerName, List<RegionInfo>> assignments = new TreeMap<ServerName, List<RegionInfo>>();
        if (this.onlySystemTablesOnMaster && this.masterServerName != null && servers.contains(this.masterServerName)) {
            assignments.put(this.masterServerName, new ArrayList());
            for (RegionInfo region : regions) {
                if (!this.shouldBeOnMaster(region)) continue;
                ((List)assignments.get(this.masterServerName)).add(region);
            }
        }
        return assignments;
    }

    @Override
    public synchronized void updateClusterMetrics(ClusterMetrics st) {
        this.clusterStatus = st;
        if (this.useRegionFinder) {
            this.regionFinder.setClusterMetrics(st);
        }
    }

    @Override
    public void setMasterServices(MasterServices masterServices) {
        this.masterServerName = masterServices.getServerName();
        this.services = masterServices;
    }

    @Override
    public synchronized void postMasterStartupInitialize() {
        if (this.services != null && this.regionFinder != null) {
            try {
                Set<RegionInfo> regions = this.services.getAssignmentManager().getRegionStates().getRegionAssignments().keySet();
                this.regionFinder.refreshAndWait(regions);
            }
            catch (Exception e) {
                LOG.warn("Refreshing region HDFS Block dist failed with exception, ignoring", (Throwable)e);
            }
        }
    }

    protected final boolean idleRegionServerExist(BalancerClusterState c) {
        boolean isServerExistsWithMoreRegions = false;
        boolean isServerExistsWithZeroRegions = false;
        for (int[] serverList : c.regionsPerServer) {
            if (serverList.length > 1) {
                isServerExistsWithMoreRegions = true;
            }
            if (serverList.length != 0) continue;
            isServerExistsWithZeroRegions = true;
        }
        return isServerExistsWithMoreRegions && isServerExistsWithZeroRegions;
    }

    protected final boolean sloppyRegionServerExist(ClusterLoadState cs) {
        if (this.slop < 0.0f) {
            LOG.debug("Slop is less than zero, not checking for sloppiness.");
            return false;
        }
        float average = cs.getLoadAverage();
        int floor = (int)Math.floor(average * (1.0f - this.slop));
        int ceiling = (int)Math.ceil(average * (1.0f + this.slop));
        if (cs.getMaxLoad() <= ceiling && cs.getMinLoad() >= floor) {
            NavigableMap<ServerAndLoad, List<RegionInfo>> serversByLoad = cs.getServersByLoad();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Skipping load balancing because balanced cluster; servers=" + cs.getNumServers() + " regions=" + cs.getNumRegions() + " average=" + average + " mostloaded=" + ((ServerAndLoad)serversByLoad.lastKey()).getLoad() + " leastloaded=" + ((ServerAndLoad)serversByLoad.firstKey()).getLoad());
            }
            return false;
        }
        return true;
    }

    @Override
    @NonNull
    public Map<ServerName, List<RegionInfo>> roundRobinAssignment(List<RegionInfo> regions, List<ServerName> servers) throws HBaseIOException {
        int numServers;
        this.metricsBalancer.incrMiscInvocations();
        Map<ServerName, List<RegionInfo>> assignments = this.assignMasterSystemRegions(regions, servers);
        if (!assignments.isEmpty()) {
            servers = new ArrayList<ServerName>(servers);
            servers.remove(this.masterServerName);
            List<RegionInfo> masterRegions = assignments.get(this.masterServerName);
            if (!masterRegions.isEmpty()) {
                regions = new ArrayList<RegionInfo>(regions);
                regions.removeAll(masterRegions);
            }
        }
        if (regions.isEmpty()) {
            return assignments;
        }
        int n = numServers = servers == null ? 0 : servers.size();
        if (numServers == 0) {
            LOG.warn("Wanted to do round robin assignment but no servers to assign to");
            return Collections.singletonMap(BOGUS_SERVER_NAME, new ArrayList<RegionInfo>(regions));
        }
        if (numServers == 1) {
            ServerName server = servers.get(0);
            assignments.put(server, new ArrayList<RegionInfo>(regions));
            return assignments;
        }
        BalancerClusterState cluster = this.createCluster(servers, regions);
        this.roundRobinAssignment(cluster, regions, servers, assignments);
        return assignments;
    }

    private BalancerClusterState createCluster(List<ServerName> servers, Collection<RegionInfo> regions) throws HBaseIOException {
        boolean hasRegionReplica;
        block4: {
            hasRegionReplica = false;
            try {
                if (this.services == null || this.services.getTableDescriptors() == null) break block4;
                Map<String, TableDescriptor> tds = this.services.getTableDescriptors().getAll();
                for (RegionInfo regionInfo : regions) {
                    TableDescriptor td = tds.get(regionInfo.getTable().getNameWithNamespaceInclAsString());
                    if (td == null || td.getRegionReplication() <= 1) continue;
                    hasRegionReplica = true;
                    break;
                }
            }
            catch (IOException ioe) {
                throw new HBaseIOException((Throwable)ioe);
            }
        }
        Map<ServerName, List<RegionInfo>> clusterState = null;
        clusterState = !hasRegionReplica ? this.getRegionAssignmentsByServer(regions) : this.getRegionAssignmentsByServer(null);
        for (ServerName server : servers) {
            if (clusterState.containsKey(server)) continue;
            clusterState.put(server, Collections.emptyList());
        }
        return new BalancerClusterState(regions, clusterState, null, this.regionFinder, this.rackManager, null);
    }

    private List<ServerName> findIdleServers(List<ServerName> servers) {
        return this.services.getServerManager().getOnlineServersListWithPredicator(servers, IDLE_SERVER_PREDICATOR);
    }

    @Override
    public ServerName randomAssignment(RegionInfo regionInfo, List<ServerName> servers) throws HBaseIOException {
        int numServers;
        this.metricsBalancer.incrMiscInvocations();
        if (servers != null && servers.contains(this.masterServerName)) {
            if (this.shouldBeOnMaster(regionInfo)) {
                return this.masterServerName;
            }
            if (!LoadBalancer.isTablesOnMaster(this.getConf())) {
                servers = new ArrayList<ServerName>(servers);
                servers.remove(this.masterServerName);
            }
        }
        int n = numServers = servers == null ? 0 : servers.size();
        if (numServers == 0) {
            LOG.warn("Wanted to retain assignment but no servers to assign to");
            return null;
        }
        if (numServers == 1) {
            return servers.get(0);
        }
        List<ServerName> idleServers = this.findIdleServers(servers);
        if (idleServers.size() == 1) {
            return idleServers.get(0);
        }
        List<ServerName> finalServers = idleServers.isEmpty() ? servers : idleServers;
        ArrayList regions = Lists.newArrayList((Object[])new RegionInfo[]{regionInfo});
        BalancerClusterState cluster = this.createCluster(finalServers, regions);
        return this.randomAssignment(cluster, regionInfo, finalServers);
    }

    @Override
    @NonNull
    public Map<ServerName, List<RegionInfo>> retainAssignment(Map<RegionInfo, ServerName> regions, List<ServerName> servers) throws HBaseIOException {
        int numServers;
        this.metricsBalancer.incrMiscInvocations();
        Map<ServerName, List<RegionInfo>> assignments = this.assignMasterSystemRegions(regions.keySet(), servers);
        if (!assignments.isEmpty()) {
            servers = new ArrayList<ServerName>(servers);
            servers.remove(this.masterServerName);
            List<RegionInfo> masterRegions = assignments.get(this.masterServerName);
            regions = regions.entrySet().stream().filter(e -> !masterRegions.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (regions.isEmpty()) {
            return assignments;
        }
        int n = numServers = servers == null ? 0 : servers.size();
        if (numServers == 0) {
            LOG.warn("Wanted to do retain assignment but no servers to assign to");
            return Collections.singletonMap(BOGUS_SERVER_NAME, new ArrayList<RegionInfo>(regions.keySet()));
        }
        if (numServers == 1) {
            ServerName server = servers.get(0);
            assignments.put(server, new ArrayList<RegionInfo>(regions.keySet()));
            return assignments;
        }
        ArrayListMultimap serversByHostname = ArrayListMultimap.create();
        for (ServerName server : servers) {
            assignments.put(server, new ArrayList());
            serversByHostname.put((Object)server.getHostnameLowerCase(), (Object)server);
        }
        TreeSet oldHostsNoLongerPresent = Sets.newTreeSet();
        ArrayList randomAssignRegions = Lists.newArrayList();
        int numRandomAssignments = 0;
        int numRetainedAssigments = 0;
        for (Map.Entry<RegionInfo, ServerName> entry : regions.entrySet()) {
            ServerName target;
            RegionInfo region = entry.getKey();
            ServerName oldServerName = entry.getValue();
            List localServers = new ArrayList();
            if (oldServerName != null) {
                localServers = serversByHostname.get((Object)oldServerName.getHostnameLowerCase());
            }
            if (localServers.isEmpty()) {
                randomAssignRegions.add(region);
                if (oldServerName == null) continue;
                oldHostsNoLongerPresent.add(oldServerName.getHostnameLowerCase());
                continue;
            }
            if (localServers.size() == 1) {
                target = (ServerName)localServers.get(0);
                assignments.get(target).add(region);
                ++numRetainedAssigments;
                continue;
            }
            if (localServers.contains(oldServerName)) {
                assignments.get(oldServerName).add(region);
                ++numRetainedAssigments;
                continue;
            }
            target = null;
            for (ServerName tmp : localServers) {
                if (tmp.getPort() != oldServerName.getPort()) continue;
                target = tmp;
                assignments.get(tmp).add(region);
                ++numRetainedAssigments;
                break;
            }
            if (target != null) continue;
            randomAssignRegions.add(region);
        }
        if (randomAssignRegions.size() > 0) {
            BalancerClusterState cluster = this.createCluster(servers, regions.keySet());
            for (Map.Entry<ServerName, List<RegionInfo>> entry : assignments.entrySet()) {
                ServerName sn = entry.getKey();
                for (RegionInfo region : entry.getValue()) {
                    cluster.doAssignRegion(region, sn);
                }
            }
            for (RegionInfo region : randomAssignRegions) {
                ServerName target = this.randomAssignment(cluster, region, servers);
                assignments.get(target).add(region);
                ++numRandomAssignments;
            }
        }
        String randomAssignMsg = "";
        if (numRandomAssignments > 0) {
            randomAssignMsg = numRandomAssignments + " regions were assigned to random hosts, since the old hosts for these regions are no longer present in the cluster. These hosts were:\n  " + Joiner.on((String)"\n  ").join((Iterable)oldHostsNoLongerPresent);
        }
        LOG.info("Reassigned " + regions.size() + " regions. " + numRetainedAssigments + " retained the pre-restart assignment. " + randomAssignMsg);
        return assignments;
    }

    protected float getDefaultSlop() {
        return 0.2f;
    }

    private RegionLocationFinder createRegionLocationFinder(Configuration conf) {
        RegionLocationFinder finder = new RegionLocationFinder();
        finder.setConf(conf);
        finder.setServices(this.services);
        return finder;
    }

    protected void loadConf(Configuration conf) {
        this.slop = conf.getFloat("hbase.regions.slop", this.getDefaultSlop());
        this.rackManager = new RackManager(this.getConf());
        this.onlySystemTablesOnMaster = LoadBalancer.isSystemTablesOnlyOnMaster(conf);
        this.useRegionFinder = conf.getBoolean("hbase.master.balancer.uselocality", true);
        this.regionFinder = this.useRegionFinder ? this.createRegionLocationFinder(conf) : null;
        this.isByTable = conf.getBoolean("hbase.master.loadbalance.bytable", false);
        LOG.info("slop={}", (Object)Float.valueOf(this.slop));
    }

    @Override
    public void initialize() {
        this.loadConf(this.getConf());
    }

    @Override
    public void regionOnline(RegionInfo regionInfo, ServerName sn) {
    }

    @Override
    public void regionOffline(RegionInfo regionInfo) {
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void stop(String why) {
        LOG.info("Load Balancer stop requested: {}", (Object)why);
        this.stopped = true;
    }

    @Override
    public void updateBalancerStatus(boolean status) {
        this.metricsBalancer.balancerStatus(status);
    }

    private ServerName randomAssignment(BalancerClusterState cluster, RegionInfo regionInfo, List<ServerName> servers) {
        int numServers = servers.size();
        ServerName sn = null;
        int maxIterations = numServers * 4;
        int iterations = 0;
        ArrayList<ServerName> usedSNs = new ArrayList<ServerName>(servers.size());
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        do {
            int i;
            if (usedSNs.contains(sn = servers.get(i = ((Random)rand).nextInt(numServers)))) continue;
            usedSNs.add(sn);
        } while (cluster.wouldLowerAvailability(regionInfo, sn) && iterations++ < maxIterations);
        if (iterations >= maxIterations) {
            for (ServerName unusedServer : servers) {
                if (usedSNs.contains(unusedServer) || cluster.wouldLowerAvailability(regionInfo, unusedServer)) continue;
                sn = unusedServer;
                break;
            }
        }
        cluster.doAssignRegion(regionInfo, sn);
        return sn;
    }

    private void roundRobinAssignment(BalancerClusterState cluster, List<RegionInfo> regions, List<ServerName> servers, Map<ServerName, List<RegionInfo>> assignments) {
        int i;
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        ArrayList<RegionInfo> unassignedRegions = new ArrayList<RegionInfo>();
        int numServers = servers.size();
        int numRegions = regions.size();
        int max = (int)Math.ceil((float)numRegions / (float)numServers);
        int serverIdx = 0;
        if (numServers > 1) {
            serverIdx = ((Random)rand).nextInt(numServers);
        }
        int regionIdx = 0;
        for (int j = 0; j < numServers; ++j) {
            ServerName server = servers.get((j + serverIdx) % numServers);
            ArrayList<RegionInfo> serverRegions = new ArrayList<RegionInfo>(max);
            for (i = regionIdx; i < numRegions; i += numServers) {
                RegionInfo region = regions.get(i % numRegions);
                if (cluster.wouldLowerAvailability(region, server)) {
                    unassignedRegions.add(region);
                    continue;
                }
                serverRegions.add(region);
                cluster.doAssignRegion(region, server);
            }
            assignments.put(server, serverRegions);
            ++regionIdx;
        }
        ArrayList<RegionInfo> lastFewRegions = new ArrayList<RegionInfo>();
        serverIdx = ((Random)rand).nextInt(numServers);
        for (RegionInfo region : unassignedRegions) {
            boolean assigned = false;
            for (int j = 0; j < numServers; ++j) {
                ServerName server = servers.get((j + serverIdx) % numServers);
                if (cluster.wouldLowerAvailability(region, server)) continue;
                assignments.computeIfAbsent(server, k -> new ArrayList()).add(region);
                cluster.doAssignRegion(region, server);
                serverIdx = (j + serverIdx + 1) % numServers;
                assigned = true;
                break;
            }
            if (assigned) continue;
            lastFewRegions.add(region);
        }
        for (RegionInfo region : lastFewRegions) {
            i = ((Random)rand).nextInt(numServers);
            ServerName server = servers.get(i);
            assignments.computeIfAbsent(server, k -> new ArrayList()).add(region);
            cluster.doAssignRegion(region, server);
        }
    }

    private Map<ServerName, List<RegionInfo>> getRegionAssignmentsByServer(Collection<RegionInfo> regions) {
        if (this.services != null && this.services.getAssignmentManager() != null) {
            return this.services.getAssignmentManager().getSnapShotOfAssignment(regions);
        }
        return new HashMap<ServerName, List<RegionInfo>>();
    }

    protected final Map<ServerName, List<RegionInfo>> toEnsumbleTableLoad(Map<TableName, Map<ServerName, List<RegionInfo>>> LoadOfAllTable) {
        TreeMap<ServerName, List<RegionInfo>> returnMap = new TreeMap<ServerName, List<RegionInfo>>();
        for (Map<ServerName, List<RegionInfo>> serverNameListMap : LoadOfAllTable.values()) {
            serverNameListMap.forEach((serverName, regionInfoList) -> {
                List regionInfos = returnMap.computeIfAbsent((ServerName)serverName, k -> new ArrayList());
                regionInfos.addAll(regionInfoList);
            });
        }
        return returnMap;
    }

    protected abstract List<RegionPlan> balanceTable(TableName var1, Map<ServerName, List<RegionInfo>> var2);

    protected void preBalanceCluster(Map<TableName, Map<ServerName, List<RegionInfo>>> loadOfAllTable) {
    }

    @Override
    public final synchronized List<RegionPlan> balanceCluster(Map<TableName, Map<ServerName, List<RegionInfo>>> loadOfAllTable) {
        this.preBalanceCluster(loadOfAllTable);
        if (this.isByTable) {
            ArrayList<RegionPlan> result = new ArrayList<RegionPlan>();
            loadOfAllTable.forEach((tableName, loadOfOneTable) -> {
                LOG.info("Start Generate Balance plan for table: " + tableName);
                List<RegionPlan> partialPlans = this.balanceTable((TableName)tableName, (Map<ServerName, List<RegionInfo>>)loadOfOneTable);
                if (partialPlans != null) {
                    result.addAll(partialPlans);
                }
            });
            return result;
        }
        LOG.debug("Start Generate Balance plan for cluster.");
        return this.balanceTable(HConstants.ENSEMBLE_TABLE_NAME, this.toEnsumbleTableLoad(loadOfAllTable));
    }

    @Override
    public synchronized void onConfigurationChange(Configuration conf) {
        this.loadConf(conf);
    }
}

