/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.regionserver.AbstractTestDateTieredCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionConfiguration;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestDateTieredCompactionPolicyOverflow
extends AbstractTestDateTieredCompactionPolicy {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDateTieredCompactionPolicyOverflow.class);

    @Override
    protected void config() {
        super.config();
        this.conf.set(StoreEngine.STORE_ENGINE_CLASS_KEY, "org.apache.hadoop.hbase.regionserver.DateTieredStoreEngine");
        this.conf.setLong(CompactionConfiguration.DATE_TIERED_MAX_AGE_MILLIS_KEY, 100L);
        this.conf.setLong(CompactionConfiguration.DATE_TIERED_INCOMING_WINDOW_MIN_KEY, 3L);
        this.conf.setLong("hbase.hstore.compaction.date.tiered.base.window.millis", 0x3FFFFFFFFFFFFFFFL);
        this.conf.setInt("hbase.hstore.compaction.date.tiered.windows.per.tier", 2);
        this.conf.setBoolean(CompactionConfiguration.DATE_TIERED_SINGLE_OUTPUT_FOR_MINOR_COMPACTION_KEY, false);
        this.conf.setInt(CompactionConfiguration.HBASE_HSTORE_COMPACTION_MIN_KEY, 2);
        this.conf.setInt(CompactionConfiguration.HBASE_HSTORE_COMPACTION_MAX_KEY, 12);
        this.conf.setFloat(CompactionConfiguration.HBASE_HSTORE_COMPACTION_RATIO_KEY, 1.2f);
        this.conf.setInt(HStore.BLOCKING_STOREFILES_KEY, 20);
        this.conf.setLong(HConstants.MAJOR_COMPACTION_PERIOD, 10L);
    }

    @Test
    public void maxValuesForMajor() throws IOException {
        long[] minTimestamps = new long[]{Long.MIN_VALUE, -100L};
        long[] maxTimestamps = new long[]{-8L, Long.MAX_VALUE};
        long[] sizes = new long[]{0L, 1L};
        this.compactEquals(Long.MAX_VALUE, this.sfCreate(minTimestamps, maxTimestamps, sizes), new long[]{0L, 1L}, new long[]{Long.MIN_VALUE, -4611686018427387903L, 0L, 0x3FFFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFEL}, true, true);
    }
}

