/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.namequeues.NamedQueuePayload;
import org.apache.hadoop.hbase.namequeues.NamedQueueService;
import org.apache.hadoop.hbase.namequeues.RingBufferEnvelope;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.EventHandler;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class LogEventHandler
implements EventHandler<RingBufferEnvelope> {
    private static final Logger LOG = LoggerFactory.getLogger(LogEventHandler.class);
    private final Map<NamedQueuePayload.NamedQueueEvent, NamedQueueService> namedQueueServices = new HashMap<NamedQueuePayload.NamedQueueEvent, NamedQueueService>();
    private static final String NAMED_QUEUE_PROVIDER_CLASSES = "hbase.namedqueue.provider.classes";

    LogEventHandler(Configuration conf) {
        for (String implName : conf.getStringCollection(NAMED_QUEUE_PROVIDER_CLASSES)) {
            Class<?> clz;
            try {
                clz = Class.forName(implName);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Failed to find NamedQueueService implementor class {}", (Object)implName, (Object)e);
                continue;
            }
            if (!NamedQueueService.class.isAssignableFrom(clz)) {
                LOG.warn("Class {} is not implementor of NamedQueueService.", clz);
                continue;
            }
            try {
                NamedQueueService namedQueueService = (NamedQueueService)clz.getConstructor(Configuration.class).newInstance(conf);
                this.namedQueueServices.put(namedQueueService.getEvent(), namedQueueService);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOG.warn("Unable to instantiate/add NamedQueueService implementor {} to service map.", clz, (Object)e);
            }
        }
    }

    @Override
    public void onEvent(RingBufferEnvelope event, long sequence, boolean endOfBatch) {
        NamedQueuePayload namedQueuePayload = event.getPayload();
        this.namedQueueServices.get((Object)namedQueuePayload.getNamedQueueEvent()).consumeEventFromDisruptor(namedQueuePayload);
    }

    boolean clearNamedQueue(NamedQueuePayload.NamedQueueEvent namedQueueEvent) {
        return this.namedQueueServices.get((Object)namedQueueEvent).clearNamedQueue();
    }

    void persistAll(NamedQueuePayload.NamedQueueEvent namedQueueEvent, Connection connection) {
        this.namedQueueServices.get((Object)namedQueueEvent).persistAll(connection);
    }

    NamedQueueGetResponse getNamedQueueRecords(NamedQueueGetRequest request) {
        return this.namedQueueServices.get((Object)request.getNamedQueueEvent()).getNamedQueueRecords(request);
    }
}

