/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.net.InetAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterUseIp {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterUseIp.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterUseIp.class);
    private HBaseTestingUtility TEST_UTIL;
    private MiniHBaseCluster CLUSTER;
    private static final int NUM_MASTERS = 1;
    private static final int NUM_RS = 1;

    @Before
    public void setup() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.server.useip.enabled", true);
        this.TEST_UTIL = new HBaseTestingUtility(conf);
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(1).numRegionServers(1).numDataNodes(1).build();
        this.CLUSTER = this.TEST_UTIL.startMiniCluster(option);
    }

    @After
    public void teardown() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMasterUseIp() throws Exception {
        String hostname = this.CLUSTER.getMaster(0).getServerName().getHostname();
        String ip = InetAddress.getByName(hostname).getHostAddress();
        LOG.info("hostname= " + hostname + " ,ip=" + ip);
        Assert.assertEquals((Object)ip, (Object)hostname);
    }
}

