/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.KeyValue;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Value;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.ValueType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

final class KeyValueList
implements Value<List<KeyValue>> {
    private final List<KeyValue> value;

    private KeyValueList(List<KeyValue> value) {
        this.value = value;
    }

    static Value<List<KeyValue>> create(KeyValue ... value) {
        Objects.requireNonNull(value, "value must not be null");
        ArrayList<KeyValue> list = new ArrayList<KeyValue>(value.length);
        list.addAll(Arrays.asList(value));
        return new KeyValueList(Collections.unmodifiableList(list));
    }

    static Value<List<KeyValue>> createFromMap(Map<String, Value<?>> value) {
        Objects.requireNonNull(value, "value must not be null");
        KeyValue[] array = (KeyValue[])value.entrySet().stream().map(entry -> KeyValue.of((String)entry.getKey(), (Value)entry.getValue())).toArray(KeyValue[]::new);
        return KeyValueList.create(array);
    }

    @Override
    public ValueType getType() {
        return ValueType.KEY_VALUE_LIST;
    }

    @Override
    public List<KeyValue> getValue() {
        return this.value;
    }

    @Override
    public String asString() {
        return this.value.stream().map(item -> item.getKey() + "=" + item.getValue().asString()).collect(Collectors.joining(", ", "[", "]"));
    }

    public String toString() {
        return "KeyValueList{" + this.asString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof Value && Objects.equals(this.value, ((Value)o).getValue());
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

