/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.mapred.TableInputFormatBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class TableInputFormat
extends TableInputFormatBase
implements JobConfigurable {
    private static final Logger LOG = LoggerFactory.getLogger(TableInputFormat.class);
    public static final String COLUMN_LIST = "hbase.mapred.tablecolumns";

    public void configure(JobConf job) {
        try {
            this.initialize(job);
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
        }
    }

    @Override
    protected void initialize(JobConf job) throws IOException {
        Path[] tableNames = FileInputFormat.getInputPaths((JobConf)job);
        String colArg = job.get(COLUMN_LIST);
        String[] colNames = colArg.split(" ");
        byte[][] m_cols = new byte[colNames.length][];
        for (int i = 0; i < m_cols.length; ++i) {
            m_cols[i] = Bytes.toBytes((String)colNames[i]);
        }
        this.setInputColumns(m_cols);
        Connection connection = ConnectionFactory.createConnection((Configuration)job);
        this.initializeTable(connection, TableName.valueOf((String)tableNames[0].getName()));
    }

    public void validateInput(JobConf job) throws IOException {
        Path[] tableNames = FileInputFormat.getInputPaths((JobConf)job);
        if (tableNames == null || tableNames.length > 1) {
            throw new IOException("expecting one table name");
        }
        if (this.getTable() == null) {
            throw new IOException("could not connect to table '" + tableNames[0].getName() + "'");
        }
        String colArg = job.get(COLUMN_LIST);
        if (colArg == null || colArg.length() == 0) {
            throw new IOException("expecting at least one column");
        }
    }
}

