/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.config;

import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;

@API(status=API.Status.STABLE, since="1.10")
public class PrefixedConfigurationParameters
implements ConfigurationParameters {
    private final ConfigurationParameters delegate;
    private final String prefix;

    public PrefixedConfigurationParameters(ConfigurationParameters delegate, String prefix) {
        this.delegate = (ConfigurationParameters)Preconditions.notNull((Object)delegate, (String)"delegate must not be null");
        this.prefix = Preconditions.notBlank((String)prefix, (String)"prefix must not be null or blank");
    }

    @Override
    public Optional<String> get(String key) {
        return this.delegate.get(this.prefixed(key));
    }

    @Override
    public Optional<Boolean> getBoolean(String key) {
        return this.delegate.getBoolean(this.prefixed(key));
    }

    @Override
    public <T> Optional<T> get(String key, Function<String, T> transformer) {
        return this.delegate.get(this.prefixed(key), transformer);
    }

    private String prefixed(String key) {
        return this.prefix + key;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Set<String> keySet() {
        return this.delegate.keySet();
    }
}

