package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.IsCatchUpRunningDTO;
import org.apache.fineract.client.models.OldestCOBProcessedLoanDTO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface LoanCobCatchUpApi {
    /**
    * Executes Loan COB Catch Up
    * Executes the Loan COB job on every day from the oldest Loan to the current COB business date
    * @return Call&lt;Void&gt;
    */
    @POST("v1/loans/catch-up")
    Call<Void> executeLoanCOBCatchUp();

    /**
    * Retrieves the oldest COB processed loan
    * Retrieves the COB business date and the oldest COB processed loan
    * @return Call&lt;OldestCOBProcessedLoanDTO&gt;
    */
    @GET("v1/loans/oldest-cob-closed")
    Call<OldestCOBProcessedLoanDTO> getOldestCOBProcessedLoan();

    /**
    * Retrieves whether Loan COB catch up is running
    * Retrieves whether Loan COB catch up is running, and the current execution date if it is running.
    * @return Call&lt;IsCatchUpRunningDTO&gt;
    */
    @GET("v1/loans/is-catch-up-running")
    Call<IsCatchUpRunningDTO> isCatchUpRunning();



        /**
        * Executes Loan COB Catch Up
        * Executes the Loan COB job on every day from the oldest Loan to the current COB business date
        * @return Call&lt;Void&gt;
        */
    @POST("v1/loans/catch-up")
    Call<Void> executeLoanCOBCatchUp(@HeaderMap Map<String, String> headers);

        /**
        * Retrieves the oldest COB processed loan
        * Retrieves the COB business date and the oldest COB processed loan
        * @return Call&lt;OldestCOBProcessedLoanDTO&gt;
        */
    @GET("v1/loans/oldest-cob-closed")
    Call<OldestCOBProcessedLoanDTO> getOldestCOBProcessedLoan(@HeaderMap Map<String, String> headers);

        /**
        * Retrieves whether Loan COB catch up is running
        * Retrieves whether Loan COB catch up is running, and the current execution date if it is running.
        * @return Call&lt;IsCatchUpRunningDTO&gt;
        */
    @GET("v1/loans/is-catch-up-running")
    Call<IsCatchUpRunningDTO> isCatchUpRunning(@HeaderMap Map<String, String> headers);


}
