package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.CalendarData;
import org.apache.fineract.client.models.CalendarRequest;
import org.apache.fineract.client.models.CommandProcessingResult;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface CalendarApi {
    /**
    * 
    * 
        * @param entityType  (required)
        * @param entityId  (required)
        * @param calendarRequest  (optional)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/{entityType}/{entityId}/calendars")
    Call<CommandProcessingResult> createCalendar(@retrofit2.http.Path("entityType") String entityType, @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Body CalendarRequest calendarRequest);

    /**
    * 
    * 
        * @param entityType  (required)
        * @param entityId  (required)
        * @param calendarId  (required)
    * @return Call&lt;CommandProcessingResult&gt;
    */
    @DELETE("v1/{entityType}/{entityId}/calendars/{calendarId}")
    Call<CommandProcessingResult> deleteCalendar(@retrofit2.http.Path("entityType") String entityType, @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Path("calendarId") Long calendarId);

    /**
    * 
    * 
        * @param calendarId  (required)
        * @param entityType  (required)
        * @param entityId  (required)
    * @return Call&lt;CalendarData&gt;
    */
    @GET("v1/{entityType}/{entityId}/calendars/{calendarId}")
    Call<CalendarData> retrieveCalendar(@retrofit2.http.Path("calendarId") Long calendarId, @retrofit2.http.Path("entityType") String entityType, @retrofit2.http.Path("entityId") Long entityId);

    /**
    * 
    * 
        * @param entityType  (required)
        * @param entityId  (required)
        * @param calendarType  (optional, default to all)
    * @return Call&lt;List&lt;CalendarData&gt;&gt;
    */
    @GET("v1/{entityType}/{entityId}/calendars")
    Call<List<CalendarData>> retrieveCalendarsByEntity(@retrofit2.http.Path("entityType") String entityType, @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Query("calendarType") String calendarType);

    /**
    * 
    * 
        * @param entityType  (required)
        * @param entityId  (required)
    * @return Call&lt;CalendarData&gt;
    */
    @GET("v1/{entityType}/{entityId}/calendars/template")
    Call<CalendarData> retrieveNewCalendarDetails(@retrofit2.http.Path("entityType") String entityType, @retrofit2.http.Path("entityId") Long entityId);

    /**
    * 
    * 
        * @param entityType  (required)
        * @param entityId  (required)
        * @param calendarId  (required)
        * @param body  (optional)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/{entityType}/{entityId}/calendars/{calendarId}")
    Call<CommandProcessingResult> updateCalendar(@retrofit2.http.Path("entityType") String entityType, @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Path("calendarId") Long calendarId, @retrofit2.http.Body String body);


        /**
        * 
        * 
            * @param entityType  (required)
            * @param entityId  (required)
            * @param calendarRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/{entityType}/{entityId}/calendars")
    Call<CommandProcessingResult> createCalendar(@retrofit2.http.Path("entityType") String entityType, @retrofit2.http.Path("entityId") Long entityId);
        /**
        * 
        * 
            * @param entityType  (required)
            * @param entityId  (required)
            * @param calendarId  (required)
            * @param body  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/{entityType}/{entityId}/calendars/{calendarId}")
    Call<CommandProcessingResult> updateCalendar(@retrofit2.http.Path("entityType") String entityType, @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Path("calendarId") Long calendarId);

        /**
        * 
        * 
            * @param entityType  (required)
            * @param entityId  (required)
            * @param calendarRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/{entityType}/{entityId}/calendars")
    Call<CommandProcessingResult> createCalendar(@retrofit2.http.Path("entityType") String entityType, @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Body CalendarRequest calendarRequest, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param entityType  (required)
            * @param entityId  (required)
            * @param calendarId  (required)
        * @return Call&lt;CommandProcessingResult&gt;
        */
    @DELETE("v1/{entityType}/{entityId}/calendars/{calendarId}")
    Call<CommandProcessingResult> deleteCalendar(@retrofit2.http.Path("entityType") String entityType, @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Path("calendarId") Long calendarId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param calendarId  (required)
            * @param entityType  (required)
            * @param entityId  (required)
        * @return Call&lt;CalendarData&gt;
        */
    @GET("v1/{entityType}/{entityId}/calendars/{calendarId}")
    Call<CalendarData> retrieveCalendar(@retrofit2.http.Path("calendarId") Long calendarId, @retrofit2.http.Path("entityType") String entityType, @retrofit2.http.Path("entityId") Long entityId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param entityType  (required)
            * @param entityId  (required)
            * @param calendarType  (optional, default to all)
        * @return Call&lt;List&lt;CalendarData&gt;&gt;
        */
    @GET("v1/{entityType}/{entityId}/calendars")
    Call<List<CalendarData>> retrieveCalendarsByEntity(@retrofit2.http.Path("entityType") String entityType, @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Query("calendarType") String calendarType, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param entityType  (required)
            * @param entityId  (required)
        * @return Call&lt;CalendarData&gt;
        */
    @GET("v1/{entityType}/{entityId}/calendars/template")
    Call<CalendarData> retrieveNewCalendarDetails(@retrofit2.http.Path("entityType") String entityType, @retrofit2.http.Path("entityId") Long entityId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param entityType  (required)
            * @param entityId  (required)
            * @param calendarId  (required)
            * @param body  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/{entityType}/{entityId}/calendars/{calendarId}")
    Call<CommandProcessingResult> updateCalendar(@retrofit2.http.Path("entityType") String entityType, @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Path("calendarId") Long calendarId, @retrofit2.http.Body String body, @HeaderMap Map<String, String> headers);


        /**
        * 
        * 
            * @param entityType  (required)
            * @param entityId  (required)
            * @param calendarRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/{entityType}/{entityId}/calendars")
    Call<CommandProcessingResult> createCalendar(@retrofit2.http.Path("entityType") String entityType, @retrofit2.http.Path("entityId") Long entityId, @HeaderMap Map<String, String> headers);
        /**
        * 
        * 
            * @param entityType  (required)
            * @param entityId  (required)
            * @param calendarId  (required)
            * @param body  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/{entityType}/{entityId}/calendars/{calendarId}")
    Call<CommandProcessingResult> updateCalendar(@retrofit2.http.Path("entityType") String entityType, @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Path("calendarId") Long calendarId, @HeaderMap Map<String, String> headers);
}
