/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.domain;

import lombok.Generated;
import org.apache.fineract.organisation.monetary.domain.OrganisationCurrencyRepositoryWrapper;
import org.apache.fineract.portfolio.client.domain.ClientTransaction;
import org.apache.fineract.portfolio.client.domain.ClientTransactionRepository;
import org.apache.fineract.portfolio.client.exception.ClientTransactionNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class ClientTransactionRepositoryWrapper {
    private final ClientTransactionRepository repository;
    private final OrganisationCurrencyRepositoryWrapper organisationCurrencyRepository;

    public ClientTransaction findOneWithNotFoundDetection(Long clientId, Long transactionId) {
        ClientTransaction clientTransaction = (ClientTransaction)this.repository.findById((Object)transactionId).orElseThrow(() -> new ClientTransactionNotFoundException(clientId, transactionId));
        if (!clientTransaction.getClientId().equals(clientId)) {
            throw new ClientTransactionNotFoundException(clientId, transactionId);
        }
        clientTransaction.setCurrency(this.organisationCurrencyRepository.findOneWithNotFoundDetection(clientTransaction.getCurrencyCode()));
        return clientTransaction;
    }

    public void save(ClientTransaction clientTransaction) {
        this.repository.save((Object)clientTransaction);
    }

    public void saveAndFlush(ClientTransaction clientTransaction) {
        this.repository.saveAndFlush((Object)clientTransaction);
    }

    public void delete(ClientTransaction clientTransaction) {
        this.repository.delete((Object)clientTransaction);
    }

    @Generated
    public ClientTransactionRepositoryWrapper(ClientTransactionRepository repository, OrganisationCurrencyRepositoryWrapper organisationCurrencyRepository) {
        this.repository = repository;
        this.organisationCurrencyRepository = organisationCurrencyRepository;
    }
}

