/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.entityaccess.service;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import org.apache.fineract.infrastructure.entityaccess.data.FineractEntityRelationData;
import org.apache.fineract.infrastructure.entityaccess.data.FineractEntityToEntityMappingData;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityAccessType;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityRelation;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityRelationRepositoryWrapper;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityType;
import org.apache.fineract.infrastructure.entityaccess.exception.FineractEntityMappingConfigurationException;
import org.apache.fineract.infrastructure.entityaccess.service.FineractEntityAccessReadService;
import org.apache.fineract.infrastructure.entityaccess.service.FineractEntityAccessReadServiceImpl;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class FineractEntityAccessReadServiceImpl
implements FineractEntityAccessReadService {
    private final PlatformSecurityContext context;
    private final JdbcTemplate jdbcTemplate;
    private static final Logger LOG = LoggerFactory.getLogger(FineractEntityAccessReadServiceImpl.class);
    private final FineractEntityRelationRepositoryWrapper fineractEntityRelationRepository;

    @Autowired
    public FineractEntityAccessReadServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate, FineractEntityRelationRepositoryWrapper fineractEntityRelationRepository) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.fineractEntityRelationRepository = fineractEntityRelationRepository;
    }

    public String getSQLQueryInClause_WithListOfIDsForEntityAccess(FineractEntityType firstEntityType, Long relId, Long fromEntityId, boolean includeAllOffices) {
        Collection accesslist = this.retrieveEntityAccessFor(firstEntityType, relId, fromEntityId, includeAllOffices);
        String returnIdListStr = null;
        StringBuilder accessListCSVStrBuf = null;
        if (accesslist != null && accesslist.size() > 0) {
            for (FineractEntityToEntityMappingData accessData : accesslist) {
                if (accessData == null) {
                    throw new FineractEntityMappingConfigurationException();
                }
                if (accessListCSVStrBuf == null) {
                    accessListCSVStrBuf = new StringBuilder();
                } else {
                    accessListCSVStrBuf.append(",");
                }
                accessListCSVStrBuf.append(accessData.getToId());
                if (accessData.getToId() != 0L) continue;
                accessListCSVStrBuf = null;
                break;
            }
        } else {
            accessListCSVStrBuf = new StringBuilder();
            accessListCSVStrBuf.append("false");
        }
        if (accessListCSVStrBuf != null) {
            returnIdListStr = accessListCSVStrBuf.toString();
        }
        LOG.debug("List of IDs applicable: {}", (Object)returnIdListStr);
        return returnIdListStr;
    }

    public Collection<FineractEntityToEntityMappingData> retrieveEntityAccessFor(FineractEntityType firstEntityType, Long relId, Long fromEntityId, boolean includeAllSubOffices) {
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        Object hierarchySearchString = null;
        hierarchySearchString = includeAllSubOffices ? ".%" : hierarchy + "%";
        Object sql = this.getSQLForRetriveEntityAccessFor();
        List entityAccessData = null;
        GetOneEntityMapper mapper = new GetOneEntityMapper();
        if (includeAllSubOffices && firstEntityType.getTableName().equals("m_office")) {
            sql = (String)sql + " where firstentity.hierarchy like ? order by firstEntity.hierarchy";
            entityAccessData = this.jdbcTemplate.query((String)sql, (RowMapper)mapper, new Object[]{fromEntityId, fromEntityId, hierarchySearchString});
        } else {
            entityAccessData = this.jdbcTemplate.query((String)sql, (RowMapper)mapper, new Object[]{relId, fromEntityId});
        }
        return entityAccessData;
    }

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    private String getSQLForRetriveEntityAccessFor() {
        StringBuilder str = new StringBuilder("select  eem.rel_id as relId,eem.from_id as fromId, ");
        str.append("eem.to_id as toId, eem.start_date as startDate, eem.end_date as endDate ");
        str.append("from  m_entity_to_entity_mapping eem ");
        str.append("where eem.rel_id = ? ");
        str.append("and eem.from_id = ? ");
        LOG.debug("{}", (Object)str);
        return str.toString();
    }

    public String getSQLQueryInClauseIDList_ForLoanProductsForOffice(Long officeId, boolean includeAllOffices) {
        FineractEntityType firstEntityType = FineractEntityType.OFFICE;
        FineractEntityRelation fineractEntityRelation = this.fineractEntityRelationRepository.findOneByCodeName(FineractEntityAccessType.OFFICE_ACCESS_TO_LOAN_PRODUCTS.getStr());
        Long relId = (Long)fineractEntityRelation.getId();
        return this.getSQLQueryInClause_WithListOfIDsForEntityAccess(firstEntityType, relId, officeId, includeAllOffices);
    }

    public String getSQLQueryInClauseIDList_ForSavingsProductsForOffice(Long officeId, boolean includeAllOffices) {
        FineractEntityType firstEntityType = FineractEntityType.OFFICE;
        FineractEntityRelation fineractEntityRelation = this.fineractEntityRelationRepository.findOneByCodeName(FineractEntityAccessType.OFFICE_ACCESS_TO_SAVINGS_PRODUCTS.getStr());
        Long relId = (Long)fineractEntityRelation.getId();
        return this.getSQLQueryInClause_WithListOfIDsForEntityAccess(firstEntityType, relId, officeId, includeAllOffices);
    }

    public String getSQLQueryInClauseIDList_ForChargesForOffice(Long officeId, boolean includeAllOffices) {
        FineractEntityType firstEntityType = FineractEntityType.OFFICE;
        FineractEntityRelation fineractEntityRelation = this.fineractEntityRelationRepository.findOneByCodeName(FineractEntityAccessType.OFFICE_ACCESS_TO_CHARGES.getStr());
        Long relId = (Long)fineractEntityRelation.getId();
        return this.getSQLQueryInClause_WithListOfIDsForEntityAccess(firstEntityType, relId, officeId, includeAllOffices);
    }

    public Collection<FineractEntityRelationData> retrieveAllSupportedMappingTypes() {
        EntityRelationMapper entityMapper = new EntityRelationMapper();
        String sql = entityMapper.schema();
        List mapTypes = this.jdbcTemplate.query(sql, (RowMapper)entityMapper, new Object[0]);
        return mapTypes;
    }

    public Collection<FineractEntityToEntityMappingData> retrieveEntityToEntityMappings(Long mapId, Long fromId, Long toId) {
        EntityToEntityMapper entityToEntityMapper = new EntityToEntityMapper();
        String sql = entityToEntityMapper.schema();
        List mapTypes = this.jdbcTemplate.query(sql, (RowMapper)entityToEntityMapper, new Object[]{mapId, fromId, fromId, toId, toId});
        return mapTypes;
    }

    public Collection<FineractEntityToEntityMappingData> retrieveOneMapping(Long mapId) {
        GetOneEntityMapper entityMapper = new GetOneEntityMapper();
        String sql = entityMapper.schema();
        List mapTypes = this.jdbcTemplate.query(sql, (RowMapper)entityMapper, new Object[]{mapId});
        return mapTypes;
    }
}

