package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.CommandProcessingResult;
import org.apache.fineract.client.models.RateData;
import org.apache.fineract.client.models.RateRequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface RateApi {
    /**
    * 
    * 
        * @param rateRequest  (optional)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/rates")
    Call<CommandProcessingResult> createRate(@retrofit2.http.Body RateRequest rateRequest);

    /**
    * 
    * 
    * @return Call&lt;List&lt;RateData&gt;&gt;
    */
    @GET("v1/rates")
    Call<List<RateData>> getAllRates();

    /**
    * 
    * 
        * @param rateId  (required)
    * @return Call&lt;RateData&gt;
    */
    @GET("v1/rates/{rateId}")
    Call<RateData> retrieveRate(@retrofit2.http.Path("rateId") Long rateId);

    /**
    * 
    * 
        * @param rateId  (required)
        * @param rateRequest  (optional)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/rates/{rateId}")
    Call<CommandProcessingResult> updateRate(@retrofit2.http.Path("rateId") Long rateId, @retrofit2.http.Body RateRequest rateRequest);


        /**
        * 
        * 
            * @param rateRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/rates")
    Call<CommandProcessingResult> createRate();
        /**
        * 
        * 
            * @param rateId  (required)
            * @param rateRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/rates/{rateId}")
    Call<CommandProcessingResult> updateRate(@retrofit2.http.Path("rateId") Long rateId);

        /**
        * 
        * 
            * @param rateRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/rates")
    Call<CommandProcessingResult> createRate(@retrofit2.http.Body RateRequest rateRequest, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
        * @return Call&lt;List&lt;RateData&gt;&gt;
        */
    @GET("v1/rates")
    Call<List<RateData>> getAllRates(@HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param rateId  (required)
        * @return Call&lt;RateData&gt;
        */
    @GET("v1/rates/{rateId}")
    Call<RateData> retrieveRate(@retrofit2.http.Path("rateId") Long rateId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param rateId  (required)
            * @param rateRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/rates/{rateId}")
    Call<CommandProcessingResult> updateRate(@retrofit2.http.Path("rateId") Long rateId, @retrofit2.http.Body RateRequest rateRequest, @HeaderMap Map<String, String> headers);


        /**
        * 
        * 
            * @param rateRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/rates")
    Call<CommandProcessingResult> createRate(@HeaderMap Map<String, String> headers);
        /**
        * 
        * 
            * @param rateId  (required)
            * @param rateRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/rates/{rateId}")
    Call<CommandProcessingResult> updateRate(@retrofit2.http.Path("rateId") Long rateId, @HeaderMap Map<String, String> headers);
}
