/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0-SNAPSHOT
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * ResultsetColumnHeaderData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class ResultsetColumnHeaderData {
  public static final String SERIALIZED_NAME_BOOLEAN_DISPLAY_TYPE = "booleanDisplayType";
  @SerializedName(SERIALIZED_NAME_BOOLEAN_DISPLAY_TYPE)
  private Boolean booleanDisplayType;

  public static final String SERIALIZED_NAME_CODE_LOOKUP_DISPLAY_TYPE = "codeLookupDisplayType";
  @SerializedName(SERIALIZED_NAME_CODE_LOOKUP_DISPLAY_TYPE)
  private Boolean codeLookupDisplayType;

  public static final String SERIALIZED_NAME_CODE_VALUE_DISPLAY_TYPE = "codeValueDisplayType";
  @SerializedName(SERIALIZED_NAME_CODE_VALUE_DISPLAY_TYPE)
  private Boolean codeValueDisplayType;

  public static final String SERIALIZED_NAME_COLUMN_CODE = "columnCode";
  @SerializedName(SERIALIZED_NAME_COLUMN_CODE)
  private String columnCode;

  /**
   * Gets or Sets columnDisplayType
   */
  @JsonAdapter(ColumnDisplayTypeEnum.Adapter.class)
  public enum ColumnDisplayTypeEnum {
    TEXT("TEXT"),
    
    STRING("STRING"),
    
    INTEGER("INTEGER"),
    
    FLOAT("FLOAT"),
    
    DECIMAL("DECIMAL"),
    
    DATE("DATE"),
    
    TIME("TIME"),
    
    DATETIME("DATETIME"),
    
    BOOLEAN("BOOLEAN"),
    
    BINARY("BINARY"),
    
    CODELOOKUP("CODELOOKUP"),
    
    CODEVALUE("CODEVALUE");

    private String value;

    ColumnDisplayTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ColumnDisplayTypeEnum fromValue(String value) {
      for (ColumnDisplayTypeEnum b : ColumnDisplayTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ColumnDisplayTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ColumnDisplayTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ColumnDisplayTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ColumnDisplayTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_COLUMN_DISPLAY_TYPE = "columnDisplayType";
  @SerializedName(SERIALIZED_NAME_COLUMN_DISPLAY_TYPE)
  private ColumnDisplayTypeEnum columnDisplayType;

  public static final String SERIALIZED_NAME_COLUMN_LENGTH = "columnLength";
  @SerializedName(SERIALIZED_NAME_COLUMN_LENGTH)
  private Long columnLength;

  public static final String SERIALIZED_NAME_COLUMN_NAME = "columnName";
  @SerializedName(SERIALIZED_NAME_COLUMN_NAME)
  private String columnName;

  /**
   * Gets or Sets columnType
   */
  @JsonAdapter(ColumnTypeEnum.Adapter.class)
  public enum ColumnTypeEnum {
    BIT("BIT"),
    
    BOOLEAN("BOOLEAN"),
    
    SMALLINT("SMALLINT"),
    
    TINYINT("TINYINT"),
    
    INTEGER("INTEGER"),
    
    MEDIUMINT("MEDIUMINT"),
    
    BIGINT("BIGINT"),
    
    REAL("REAL"),
    
    FLOAT("FLOAT"),
    
    DOUBLE("DOUBLE"),
    
    NUMERIC("NUMERIC"),
    
    DECIMAL("DECIMAL"),
    
    SERIAL("SERIAL"),
    
    SMALLSERIAL("SMALLSERIAL"),
    
    BIGSERIAL("BIGSERIAL"),
    
    MONEY("MONEY"),
    
    CHAR("CHAR"),
    
    VARCHAR("VARCHAR"),
    
    LONGVARCHAR("LONGVARCHAR"),
    
    TEXT("TEXT"),
    
    TINYTEXT("TINYTEXT"),
    
    MEDIUMTEXT("MEDIUMTEXT"),
    
    LONGTEXT("LONGTEXT"),
    
    JSON("JSON"),
    
    DATE("DATE"),
    
    TIME("TIME"),
    
    TIME_WITH_TIMEZONE("TIME_WITH_TIMEZONE"),
    
    TIMESTAMP("TIMESTAMP"),
    
    DATETIME("DATETIME"),
    
    TIMESTAMP_WITH_TIMEZONE("TIMESTAMP_WITH_TIMEZONE"),
    
    INTERVAL("INTERVAL"),
    
    BINARY("BINARY"),
    
    VARBINARY("VARBINARY"),
    
    LONGVARBINARY("LONGVARBINARY"),
    
    BYTEA("BYTEA"),
    
    BLOB("BLOB"),
    
    TINYBLOB("TINYBLOB"),
    
    MEDIUMBLOB("MEDIUMBLOB"),
    
    LONGBLOB("LONGBLOB");

    private String value;

    ColumnTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ColumnTypeEnum fromValue(String value) {
      for (ColumnTypeEnum b : ColumnTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ColumnTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ColumnTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ColumnTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ColumnTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_COLUMN_TYPE = "columnType";
  @SerializedName(SERIALIZED_NAME_COLUMN_TYPE)
  private ColumnTypeEnum columnType;

  public static final String SERIALIZED_NAME_COLUMN_VALUES = "columnValues";
  @SerializedName(SERIALIZED_NAME_COLUMN_VALUES)
  private List<Object> columnValues;

  public static final String SERIALIZED_NAME_DATE_DISPLAY_TYPE = "dateDisplayType";
  @SerializedName(SERIALIZED_NAME_DATE_DISPLAY_TYPE)
  private Boolean dateDisplayType;

  public static final String SERIALIZED_NAME_DATE_TIME_DISPLAY_TYPE = "dateTimeDisplayType";
  @SerializedName(SERIALIZED_NAME_DATE_TIME_DISPLAY_TYPE)
  private Boolean dateTimeDisplayType;

  public static final String SERIALIZED_NAME_DECIMAL_DISPLAY_TYPE = "decimalDisplayType";
  @SerializedName(SERIALIZED_NAME_DECIMAL_DISPLAY_TYPE)
  private Boolean decimalDisplayType;

  public static final String SERIALIZED_NAME_INTEGER_DISPLAY_TYPE = "integerDisplayType";
  @SerializedName(SERIALIZED_NAME_INTEGER_DISPLAY_TYPE)
  private Boolean integerDisplayType;

  public static final String SERIALIZED_NAME_IS_COLUMN_INDEXED = "isColumnIndexed";
  @SerializedName(SERIALIZED_NAME_IS_COLUMN_INDEXED)
  private Boolean isColumnIndexed;

  public static final String SERIALIZED_NAME_IS_COLUMN_NULLABLE = "isColumnNullable";
  @SerializedName(SERIALIZED_NAME_IS_COLUMN_NULLABLE)
  private Boolean isColumnNullable;

  public static final String SERIALIZED_NAME_IS_COLUMN_PRIMARY_KEY = "isColumnPrimaryKey";
  @SerializedName(SERIALIZED_NAME_IS_COLUMN_PRIMARY_KEY)
  private Boolean isColumnPrimaryKey;

  public static final String SERIALIZED_NAME_IS_COLUMN_UNIQUE = "isColumnUnique";
  @SerializedName(SERIALIZED_NAME_IS_COLUMN_UNIQUE)
  private Boolean isColumnUnique;

  public static final String SERIALIZED_NAME_MANDATORY = "mandatory";
  @SerializedName(SERIALIZED_NAME_MANDATORY)
  private Boolean mandatory;

  public static final String SERIALIZED_NAME_STRING_DISPLAY_TYPE = "stringDisplayType";
  @SerializedName(SERIALIZED_NAME_STRING_DISPLAY_TYPE)
  private Boolean stringDisplayType;

  public static final String SERIALIZED_NAME_TEXT_DISPLAY_TYPE = "textDisplayType";
  @SerializedName(SERIALIZED_NAME_TEXT_DISPLAY_TYPE)
  private Boolean textDisplayType;

  public static final String SERIALIZED_NAME_TIME_DISPLAY_TYPE = "timeDisplayType";
  @SerializedName(SERIALIZED_NAME_TIME_DISPLAY_TYPE)
  private Boolean timeDisplayType;

  public ResultsetColumnHeaderData() {
  }

  public ResultsetColumnHeaderData booleanDisplayType(Boolean booleanDisplayType) {
    
    this.booleanDisplayType = booleanDisplayType;
    return this;
  }

  /**
   * Get booleanDisplayType
   * @return booleanDisplayType
   */
  @javax.annotation.Nullable

  public Boolean getBooleanDisplayType() {
    return booleanDisplayType;
  }


  public void setBooleanDisplayType(Boolean booleanDisplayType) {
    this.booleanDisplayType = booleanDisplayType;
  }

  public ResultsetColumnHeaderData codeLookupDisplayType(Boolean codeLookupDisplayType) {
    
    this.codeLookupDisplayType = codeLookupDisplayType;
    return this;
  }

  /**
   * Get codeLookupDisplayType
   * @return codeLookupDisplayType
   */
  @javax.annotation.Nullable

  public Boolean getCodeLookupDisplayType() {
    return codeLookupDisplayType;
  }


  public void setCodeLookupDisplayType(Boolean codeLookupDisplayType) {
    this.codeLookupDisplayType = codeLookupDisplayType;
  }

  public ResultsetColumnHeaderData codeValueDisplayType(Boolean codeValueDisplayType) {
    
    this.codeValueDisplayType = codeValueDisplayType;
    return this;
  }

  /**
   * Get codeValueDisplayType
   * @return codeValueDisplayType
   */
  @javax.annotation.Nullable

  public Boolean getCodeValueDisplayType() {
    return codeValueDisplayType;
  }


  public void setCodeValueDisplayType(Boolean codeValueDisplayType) {
    this.codeValueDisplayType = codeValueDisplayType;
  }

  public ResultsetColumnHeaderData columnCode(String columnCode) {
    
    this.columnCode = columnCode;
    return this;
  }

  /**
   * Get columnCode
   * @return columnCode
   */
  @javax.annotation.Nullable

  public String getColumnCode() {
    return columnCode;
  }


  public void setColumnCode(String columnCode) {
    this.columnCode = columnCode;
  }

  public ResultsetColumnHeaderData columnDisplayType(ColumnDisplayTypeEnum columnDisplayType) {
    
    this.columnDisplayType = columnDisplayType;
    return this;
  }

  /**
   * Get columnDisplayType
   * @return columnDisplayType
   */
  @javax.annotation.Nullable

  public ColumnDisplayTypeEnum getColumnDisplayType() {
    return columnDisplayType;
  }


  public void setColumnDisplayType(ColumnDisplayTypeEnum columnDisplayType) {
    this.columnDisplayType = columnDisplayType;
  }

  public ResultsetColumnHeaderData columnLength(Long columnLength) {
    
    this.columnLength = columnLength;
    return this;
  }

  /**
   * Get columnLength
   * @return columnLength
   */
  @javax.annotation.Nullable

  public Long getColumnLength() {
    return columnLength;
  }


  public void setColumnLength(Long columnLength) {
    this.columnLength = columnLength;
  }

  public ResultsetColumnHeaderData columnName(String columnName) {
    
    this.columnName = columnName;
    return this;
  }

  /**
   * Get columnName
   * @return columnName
   */
  @javax.annotation.Nullable

  public String getColumnName() {
    return columnName;
  }


  public void setColumnName(String columnName) {
    this.columnName = columnName;
  }

  public ResultsetColumnHeaderData columnType(ColumnTypeEnum columnType) {
    
    this.columnType = columnType;
    return this;
  }

  /**
   * Get columnType
   * @return columnType
   */
  @javax.annotation.Nullable

  public ColumnTypeEnum getColumnType() {
    return columnType;
  }


  public void setColumnType(ColumnTypeEnum columnType) {
    this.columnType = columnType;
  }

  public ResultsetColumnHeaderData columnValues(List<Object> columnValues) {
    
    this.columnValues = columnValues;
    return this;
  }

  public ResultsetColumnHeaderData addColumnValuesItem(Object columnValuesItem) {
    if (this.columnValues == null) {
      this.columnValues = new ArrayList<>();
    }
    this.columnValues.add(columnValuesItem);
    return this;
  }

  /**
   * Get columnValues
   * @return columnValues
   */
  @javax.annotation.Nullable

  public List<Object> getColumnValues() {
    return columnValues;
  }


  public void setColumnValues(List<Object> columnValues) {
    this.columnValues = columnValues;
  }

  public ResultsetColumnHeaderData dateDisplayType(Boolean dateDisplayType) {
    
    this.dateDisplayType = dateDisplayType;
    return this;
  }

  /**
   * Get dateDisplayType
   * @return dateDisplayType
   */
  @javax.annotation.Nullable

  public Boolean getDateDisplayType() {
    return dateDisplayType;
  }


  public void setDateDisplayType(Boolean dateDisplayType) {
    this.dateDisplayType = dateDisplayType;
  }

  public ResultsetColumnHeaderData dateTimeDisplayType(Boolean dateTimeDisplayType) {
    
    this.dateTimeDisplayType = dateTimeDisplayType;
    return this;
  }

  /**
   * Get dateTimeDisplayType
   * @return dateTimeDisplayType
   */
  @javax.annotation.Nullable

  public Boolean getDateTimeDisplayType() {
    return dateTimeDisplayType;
  }


  public void setDateTimeDisplayType(Boolean dateTimeDisplayType) {
    this.dateTimeDisplayType = dateTimeDisplayType;
  }

  public ResultsetColumnHeaderData decimalDisplayType(Boolean decimalDisplayType) {
    
    this.decimalDisplayType = decimalDisplayType;
    return this;
  }

  /**
   * Get decimalDisplayType
   * @return decimalDisplayType
   */
  @javax.annotation.Nullable

  public Boolean getDecimalDisplayType() {
    return decimalDisplayType;
  }


  public void setDecimalDisplayType(Boolean decimalDisplayType) {
    this.decimalDisplayType = decimalDisplayType;
  }

  public ResultsetColumnHeaderData integerDisplayType(Boolean integerDisplayType) {
    
    this.integerDisplayType = integerDisplayType;
    return this;
  }

  /**
   * Get integerDisplayType
   * @return integerDisplayType
   */
  @javax.annotation.Nullable

  public Boolean getIntegerDisplayType() {
    return integerDisplayType;
  }


  public void setIntegerDisplayType(Boolean integerDisplayType) {
    this.integerDisplayType = integerDisplayType;
  }

  public ResultsetColumnHeaderData isColumnIndexed(Boolean isColumnIndexed) {
    
    this.isColumnIndexed = isColumnIndexed;
    return this;
  }

  /**
   * Get isColumnIndexed
   * @return isColumnIndexed
   */
  @javax.annotation.Nullable

  public Boolean getIsColumnIndexed() {
    return isColumnIndexed;
  }


  public void setIsColumnIndexed(Boolean isColumnIndexed) {
    this.isColumnIndexed = isColumnIndexed;
  }

  public ResultsetColumnHeaderData isColumnNullable(Boolean isColumnNullable) {
    
    this.isColumnNullable = isColumnNullable;
    return this;
  }

  /**
   * Get isColumnNullable
   * @return isColumnNullable
   */
  @javax.annotation.Nullable

  public Boolean getIsColumnNullable() {
    return isColumnNullable;
  }


  public void setIsColumnNullable(Boolean isColumnNullable) {
    this.isColumnNullable = isColumnNullable;
  }

  public ResultsetColumnHeaderData isColumnPrimaryKey(Boolean isColumnPrimaryKey) {
    
    this.isColumnPrimaryKey = isColumnPrimaryKey;
    return this;
  }

  /**
   * Get isColumnPrimaryKey
   * @return isColumnPrimaryKey
   */
  @javax.annotation.Nullable

  public Boolean getIsColumnPrimaryKey() {
    return isColumnPrimaryKey;
  }


  public void setIsColumnPrimaryKey(Boolean isColumnPrimaryKey) {
    this.isColumnPrimaryKey = isColumnPrimaryKey;
  }

  public ResultsetColumnHeaderData isColumnUnique(Boolean isColumnUnique) {
    
    this.isColumnUnique = isColumnUnique;
    return this;
  }

  /**
   * Get isColumnUnique
   * @return isColumnUnique
   */
  @javax.annotation.Nullable

  public Boolean getIsColumnUnique() {
    return isColumnUnique;
  }


  public void setIsColumnUnique(Boolean isColumnUnique) {
    this.isColumnUnique = isColumnUnique;
  }

  public ResultsetColumnHeaderData mandatory(Boolean mandatory) {
    
    this.mandatory = mandatory;
    return this;
  }

  /**
   * Get mandatory
   * @return mandatory
   */
  @javax.annotation.Nullable

  public Boolean getMandatory() {
    return mandatory;
  }


  public void setMandatory(Boolean mandatory) {
    this.mandatory = mandatory;
  }

  public ResultsetColumnHeaderData stringDisplayType(Boolean stringDisplayType) {
    
    this.stringDisplayType = stringDisplayType;
    return this;
  }

  /**
   * Get stringDisplayType
   * @return stringDisplayType
   */
  @javax.annotation.Nullable

  public Boolean getStringDisplayType() {
    return stringDisplayType;
  }


  public void setStringDisplayType(Boolean stringDisplayType) {
    this.stringDisplayType = stringDisplayType;
  }

  public ResultsetColumnHeaderData textDisplayType(Boolean textDisplayType) {
    
    this.textDisplayType = textDisplayType;
    return this;
  }

  /**
   * Get textDisplayType
   * @return textDisplayType
   */
  @javax.annotation.Nullable

  public Boolean getTextDisplayType() {
    return textDisplayType;
  }


  public void setTextDisplayType(Boolean textDisplayType) {
    this.textDisplayType = textDisplayType;
  }

  public ResultsetColumnHeaderData timeDisplayType(Boolean timeDisplayType) {
    
    this.timeDisplayType = timeDisplayType;
    return this;
  }

  /**
   * Get timeDisplayType
   * @return timeDisplayType
   */
  @javax.annotation.Nullable

  public Boolean getTimeDisplayType() {
    return timeDisplayType;
  }


  public void setTimeDisplayType(Boolean timeDisplayType) {
    this.timeDisplayType = timeDisplayType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ResultsetColumnHeaderData resultsetColumnHeaderData = (ResultsetColumnHeaderData) o;
    return Objects.equals(this.booleanDisplayType, resultsetColumnHeaderData.booleanDisplayType) &&
        Objects.equals(this.codeLookupDisplayType, resultsetColumnHeaderData.codeLookupDisplayType) &&
        Objects.equals(this.codeValueDisplayType, resultsetColumnHeaderData.codeValueDisplayType) &&
        Objects.equals(this.columnCode, resultsetColumnHeaderData.columnCode) &&
        Objects.equals(this.columnDisplayType, resultsetColumnHeaderData.columnDisplayType) &&
        Objects.equals(this.columnLength, resultsetColumnHeaderData.columnLength) &&
        Objects.equals(this.columnName, resultsetColumnHeaderData.columnName) &&
        Objects.equals(this.columnType, resultsetColumnHeaderData.columnType) &&
        Objects.equals(this.columnValues, resultsetColumnHeaderData.columnValues) &&
        Objects.equals(this.dateDisplayType, resultsetColumnHeaderData.dateDisplayType) &&
        Objects.equals(this.dateTimeDisplayType, resultsetColumnHeaderData.dateTimeDisplayType) &&
        Objects.equals(this.decimalDisplayType, resultsetColumnHeaderData.decimalDisplayType) &&
        Objects.equals(this.integerDisplayType, resultsetColumnHeaderData.integerDisplayType) &&
        Objects.equals(this.isColumnIndexed, resultsetColumnHeaderData.isColumnIndexed) &&
        Objects.equals(this.isColumnNullable, resultsetColumnHeaderData.isColumnNullable) &&
        Objects.equals(this.isColumnPrimaryKey, resultsetColumnHeaderData.isColumnPrimaryKey) &&
        Objects.equals(this.isColumnUnique, resultsetColumnHeaderData.isColumnUnique) &&
        Objects.equals(this.mandatory, resultsetColumnHeaderData.mandatory) &&
        Objects.equals(this.stringDisplayType, resultsetColumnHeaderData.stringDisplayType) &&
        Objects.equals(this.textDisplayType, resultsetColumnHeaderData.textDisplayType) &&
        Objects.equals(this.timeDisplayType, resultsetColumnHeaderData.timeDisplayType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(booleanDisplayType, codeLookupDisplayType, codeValueDisplayType, columnCode, columnDisplayType, columnLength, columnName, columnType, columnValues, dateDisplayType, dateTimeDisplayType, decimalDisplayType, integerDisplayType, isColumnIndexed, isColumnNullable, isColumnPrimaryKey, isColumnUnique, mandatory, stringDisplayType, textDisplayType, timeDisplayType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ResultsetColumnHeaderData {\n");
    sb.append("    booleanDisplayType: ").append(toIndentedString(booleanDisplayType)).append("\n");
    sb.append("    codeLookupDisplayType: ").append(toIndentedString(codeLookupDisplayType)).append("\n");
    sb.append("    codeValueDisplayType: ").append(toIndentedString(codeValueDisplayType)).append("\n");
    sb.append("    columnCode: ").append(toIndentedString(columnCode)).append("\n");
    sb.append("    columnDisplayType: ").append(toIndentedString(columnDisplayType)).append("\n");
    sb.append("    columnLength: ").append(toIndentedString(columnLength)).append("\n");
    sb.append("    columnName: ").append(toIndentedString(columnName)).append("\n");
    sb.append("    columnType: ").append(toIndentedString(columnType)).append("\n");
    sb.append("    columnValues: ").append(toIndentedString(columnValues)).append("\n");
    sb.append("    dateDisplayType: ").append(toIndentedString(dateDisplayType)).append("\n");
    sb.append("    dateTimeDisplayType: ").append(toIndentedString(dateTimeDisplayType)).append("\n");
    sb.append("    decimalDisplayType: ").append(toIndentedString(decimalDisplayType)).append("\n");
    sb.append("    integerDisplayType: ").append(toIndentedString(integerDisplayType)).append("\n");
    sb.append("    isColumnIndexed: ").append(toIndentedString(isColumnIndexed)).append("\n");
    sb.append("    isColumnNullable: ").append(toIndentedString(isColumnNullable)).append("\n");
    sb.append("    isColumnPrimaryKey: ").append(toIndentedString(isColumnPrimaryKey)).append("\n");
    sb.append("    isColumnUnique: ").append(toIndentedString(isColumnUnique)).append("\n");
    sb.append("    mandatory: ").append(toIndentedString(mandatory)).append("\n");
    sb.append("    stringDisplayType: ").append(toIndentedString(stringDisplayType)).append("\n");
    sb.append("    textDisplayType: ").append(toIndentedString(textDisplayType)).append("\n");
    sb.append("    timeDisplayType: ").append(toIndentedString(timeDisplayType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

