/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0-SNAPSHOT
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * InterestPeriodMc
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class InterestPeriodMc {
  public static final String SERIALIZED_NAME_PRECISION = "precision";
  @SerializedName(SERIALIZED_NAME_PRECISION)
  private Integer precision;

  /**
   * Gets or Sets roundingMode
   */
  @JsonAdapter(RoundingModeEnum.Adapter.class)
  public enum RoundingModeEnum {
    UP("UP"),
    
    DOWN("DOWN"),
    
    CEILING("CEILING"),
    
    FLOOR("FLOOR"),
    
    HALF_UP("HALF_UP"),
    
    HALF_DOWN("HALF_DOWN"),
    
    HALF_EVEN("HALF_EVEN"),
    
    UNNECESSARY("UNNECESSARY");

    private String value;

    RoundingModeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static RoundingModeEnum fromValue(String value) {
      for (RoundingModeEnum b : RoundingModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<RoundingModeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RoundingModeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public RoundingModeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return RoundingModeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ROUNDING_MODE = "roundingMode";
  @SerializedName(SERIALIZED_NAME_ROUNDING_MODE)
  private RoundingModeEnum roundingMode;

  public InterestPeriodMc() {
  }

  public InterestPeriodMc precision(Integer precision) {
    
    this.precision = precision;
    return this;
  }

  /**
   * Get precision
   * @return precision
   */
  @javax.annotation.Nullable

  public Integer getPrecision() {
    return precision;
  }


  public void setPrecision(Integer precision) {
    this.precision = precision;
  }

  public InterestPeriodMc roundingMode(RoundingModeEnum roundingMode) {
    
    this.roundingMode = roundingMode;
    return this;
  }

  /**
   * Get roundingMode
   * @return roundingMode
   */
  @javax.annotation.Nullable

  public RoundingModeEnum getRoundingMode() {
    return roundingMode;
  }


  public void setRoundingMode(RoundingModeEnum roundingMode) {
    this.roundingMode = roundingMode;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InterestPeriodMc interestPeriodMc = (InterestPeriodMc) o;
    return Objects.equals(this.precision, interestPeriodMc.precision) &&
        Objects.equals(this.roundingMode, interestPeriodMc.roundingMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(precision, roundingMode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InterestPeriodMc {\n");
    sb.append("    precision: ").append(toIndentedString(precision)).append("\n");
    sb.append("    roundingMode: ").append(toIndentedString(roundingMode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

