/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0-SNAPSHOT
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.fineract.client.models.DelinquencyRangeData;
import org.apache.fineract.client.models.EnumOptionData;
import org.apache.fineract.client.models.GetLoansLoanIdAmortizationType;
import org.apache.fineract.client.models.GetLoansLoanIdCurrency;
import org.apache.fineract.client.models.GetLoansLoanIdDelinquencySummary;
import org.apache.fineract.client.models.GetLoansLoanIdDisbursementDetails;
import org.apache.fineract.client.models.GetLoansLoanIdInterestCalculationPeriodType;
import org.apache.fineract.client.models.GetLoansLoanIdInterestRateFrequencyType;
import org.apache.fineract.client.models.GetLoansLoanIdInterestType;
import org.apache.fineract.client.models.GetLoansLoanIdLoanChargeData;
import org.apache.fineract.client.models.GetLoansLoanIdLoanTermVariations;
import org.apache.fineract.client.models.GetLoansLoanIdLoanType;
import org.apache.fineract.client.models.GetLoansLoanIdRepaymentFrequencyType;
import org.apache.fineract.client.models.GetLoansLoanIdRepaymentSchedule;
import org.apache.fineract.client.models.GetLoansLoanIdStatus;
import org.apache.fineract.client.models.GetLoansLoanIdSummary;
import org.apache.fineract.client.models.GetLoansLoanIdTermPeriodFrequencyType;
import org.apache.fineract.client.models.GetLoansLoanIdTimeline;
import org.apache.fineract.client.models.GetLoansLoanIdTransactions;
import org.apache.fineract.client.models.StringEnumOptionData;

/**
 * GetLoansLoanIdResponse
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class GetLoansLoanIdResponse {
  public static final String SERIALIZED_NAME_ACCOUNT_NO = "accountNo";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NO)
  private String accountNo;

  public static final String SERIALIZED_NAME_AMORTIZATION_TYPE = "amortizationType";
  @SerializedName(SERIALIZED_NAME_AMORTIZATION_TYPE)
  private GetLoansLoanIdAmortizationType amortizationType;

  public static final String SERIALIZED_NAME_ANNUAL_INTEREST_RATE = "annualInterestRate";
  @SerializedName(SERIALIZED_NAME_ANNUAL_INTEREST_RATE)
  private BigDecimal annualInterestRate;

  public static final String SERIALIZED_NAME_APPROVED_PRINCIPAL = "approvedPrincipal";
  @SerializedName(SERIALIZED_NAME_APPROVED_PRINCIPAL)
  private BigDecimal approvedPrincipal;

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_CALCULATION_TYPE = "buyDownFeeCalculationType";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_CALCULATION_TYPE)
  private StringEnumOptionData buyDownFeeCalculationType;

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_INCOME_TYPE = "buyDownFeeIncomeType";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_INCOME_TYPE)
  private StringEnumOptionData buyDownFeeIncomeType;

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_STRATEGY = "buyDownFeeStrategy";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_STRATEGY)
  private StringEnumOptionData buyDownFeeStrategy;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_CALCULATION_TYPE = "capitalizedIncomeCalculationType";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_CALCULATION_TYPE)
  private StringEnumOptionData capitalizedIncomeCalculationType;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_STRATEGY = "capitalizedIncomeStrategy";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_STRATEGY)
  private StringEnumOptionData capitalizedIncomeStrategy;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_TYPE = "capitalizedIncomeType";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_TYPE)
  private StringEnumOptionData capitalizedIncomeType;

  public static final String SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR = "chargeOffBehaviour";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR)
  private StringEnumOptionData chargeOffBehaviour;

  public static final String SERIALIZED_NAME_CHARGED_OFF = "chargedOff";
  @SerializedName(SERIALIZED_NAME_CHARGED_OFF)
  private Boolean chargedOff;

  public static final String SERIALIZED_NAME_CHARGES = "charges";
  @SerializedName(SERIALIZED_NAME_CHARGES)
  private List<GetLoansLoanIdLoanChargeData> charges;

  public static final String SERIALIZED_NAME_CLIENT_EXTERNAL_ID = "clientExternalId";
  @SerializedName(SERIALIZED_NAME_CLIENT_EXTERNAL_ID)
  private String clientExternalId;

  public static final String SERIALIZED_NAME_CLIENT_ID = "clientId";
  @SerializedName(SERIALIZED_NAME_CLIENT_ID)
  private Long clientId;

  public static final String SERIALIZED_NAME_CLIENT_NAME = "clientName";
  @SerializedName(SERIALIZED_NAME_CLIENT_NAME)
  private String clientName;

  public static final String SERIALIZED_NAME_CLIENT_OFFICE_ID = "clientOfficeId";
  @SerializedName(SERIALIZED_NAME_CLIENT_OFFICE_ID)
  private Long clientOfficeId;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private GetLoansLoanIdCurrency currency;

  public static final String SERIALIZED_NAME_DELINQUENCY_RANGE = "delinquencyRange";
  @SerializedName(SERIALIZED_NAME_DELINQUENCY_RANGE)
  private DelinquencyRangeData delinquencyRange;

  public static final String SERIALIZED_NAME_DELINQUENT = "delinquent";
  @SerializedName(SERIALIZED_NAME_DELINQUENT)
  private GetLoansLoanIdDelinquencySummary delinquent;

  public static final String SERIALIZED_NAME_DISALLOW_EXPECTED_DISBURSEMENTS = "disallowExpectedDisbursements";
  @SerializedName(SERIALIZED_NAME_DISALLOW_EXPECTED_DISBURSEMENTS)
  private Boolean disallowExpectedDisbursements;

  public static final String SERIALIZED_NAME_DISBURSED_AMOUNT_PERCENTAGE_FOR_DOWN_PAYMENT = "disbursedAmountPercentageForDownPayment";
  @SerializedName(SERIALIZED_NAME_DISBURSED_AMOUNT_PERCENTAGE_FOR_DOWN_PAYMENT)
  private BigDecimal disbursedAmountPercentageForDownPayment;

  public static final String SERIALIZED_NAME_DISBURSEMENT_DETAILS = "disbursementDetails";
  @SerializedName(SERIALIZED_NAME_DISBURSEMENT_DETAILS)
  private Set<GetLoansLoanIdDisbursementDetails> disbursementDetails;

  public static final String SERIALIZED_NAME_EMI_AMOUNT_VARIATIONS = "emiAmountVariations";
  @SerializedName(SERIALIZED_NAME_EMI_AMOUNT_VARIATIONS)
  private List<GetLoansLoanIdLoanTermVariations> emiAmountVariations;

  public static final String SERIALIZED_NAME_ENABLE_AUTO_REPAYMENT_FOR_DOWN_PAYMENT = "enableAutoRepaymentForDownPayment";
  @SerializedName(SERIALIZED_NAME_ENABLE_AUTO_REPAYMENT_FOR_DOWN_PAYMENT)
  private Boolean enableAutoRepaymentForDownPayment;

  public static final String SERIALIZED_NAME_ENABLE_BUY_DOWN_FEE = "enableBuyDownFee";
  @SerializedName(SERIALIZED_NAME_ENABLE_BUY_DOWN_FEE)
  private Boolean enableBuyDownFee;

  public static final String SERIALIZED_NAME_ENABLE_DOWN_PAYMENT = "enableDownPayment";
  @SerializedName(SERIALIZED_NAME_ENABLE_DOWN_PAYMENT)
  private Boolean enableDownPayment;

  public static final String SERIALIZED_NAME_ENABLE_INCOME_CAPITALIZATION = "enableIncomeCapitalization";
  @SerializedName(SERIALIZED_NAME_ENABLE_INCOME_CAPITALIZATION)
  private Boolean enableIncomeCapitalization;

  public static final String SERIALIZED_NAME_ENABLE_INSTALLMENT_LEVEL_DELINQUENCY = "enableInstallmentLevelDelinquency";
  @SerializedName(SERIALIZED_NAME_ENABLE_INSTALLMENT_LEVEL_DELINQUENCY)
  private Boolean enableInstallmentLevelDelinquency;

  public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
  @SerializedName(SERIALIZED_NAME_EXTERNAL_ID)
  private String externalId;

  public static final String SERIALIZED_NAME_FIXED_LENGTH = "fixedLength";
  @SerializedName(SERIALIZED_NAME_FIXED_LENGTH)
  private Integer fixedLength;

  public static final String SERIALIZED_NAME_FIXED_PRINCIPAL_PERCENTAGE_PER_INSTALLMENT = "fixedPrincipalPercentagePerInstallment";
  @SerializedName(SERIALIZED_NAME_FIXED_PRINCIPAL_PERCENTAGE_PER_INSTALLMENT)
  private BigDecimal fixedPrincipalPercentagePerInstallment;

  public static final String SERIALIZED_NAME_FRAUD = "fraud";
  @SerializedName(SERIALIZED_NAME_FRAUD)
  private Boolean fraud;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_IN_ARREARS_TOLERANCE = "inArrearsTolerance";
  @SerializedName(SERIALIZED_NAME_IN_ARREARS_TOLERANCE)
  private Integer inArrearsTolerance;

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE = "interestCalculationPeriodType";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE)
  private GetLoansLoanIdInterestCalculationPeriodType interestCalculationPeriodType;

  public static final String SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE = "interestRateFrequencyType";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE)
  private GetLoansLoanIdInterestRateFrequencyType interestRateFrequencyType;

  public static final String SERIALIZED_NAME_INTEREST_RATE_PER_PERIOD = "interestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_PER_PERIOD)
  private BigDecimal interestRatePerPeriod;

  public static final String SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE = "interestRecognitionOnDisbursementDate";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE)
  private Boolean interestRecognitionOnDisbursementDate;

  public static final String SERIALIZED_NAME_INTEREST_TYPE = "interestType";
  @SerializedName(SERIALIZED_NAME_INTEREST_TYPE)
  private GetLoansLoanIdInterestType interestType;

  public static final String SERIALIZED_NAME_IS_FLOATING_INTEREST_RATE = "isFloatingInterestRate";
  @SerializedName(SERIALIZED_NAME_IS_FLOATING_INTEREST_RATE)
  private Boolean isFloatingInterestRate;

  public static final String SERIALIZED_NAME_LAST_CLOSED_BUSINESS_DATE = "lastClosedBusinessDate";
  @SerializedName(SERIALIZED_NAME_LAST_CLOSED_BUSINESS_DATE)
  private LocalDate lastClosedBusinessDate;

  public static final String SERIALIZED_NAME_LOAN_OFFICER_ID = "loanOfficerId";
  @SerializedName(SERIALIZED_NAME_LOAN_OFFICER_ID)
  private Long loanOfficerId;

  public static final String SERIALIZED_NAME_LOAN_OFFICER_NAME = "loanOfficerName";
  @SerializedName(SERIALIZED_NAME_LOAN_OFFICER_NAME)
  private String loanOfficerName;

  public static final String SERIALIZED_NAME_LOAN_PRODUCT_DESCRIPTION = "loanProductDescription";
  @SerializedName(SERIALIZED_NAME_LOAN_PRODUCT_DESCRIPTION)
  private String loanProductDescription;

  public static final String SERIALIZED_NAME_LOAN_PRODUCT_ID = "loanProductId";
  @SerializedName(SERIALIZED_NAME_LOAN_PRODUCT_ID)
  private Long loanProductId;

  public static final String SERIALIZED_NAME_LOAN_PRODUCT_NAME = "loanProductName";
  @SerializedName(SERIALIZED_NAME_LOAN_PRODUCT_NAME)
  private String loanProductName;

  public static final String SERIALIZED_NAME_LOAN_PURPOSE_ID = "loanPurposeId";
  @SerializedName(SERIALIZED_NAME_LOAN_PURPOSE_ID)
  private Long loanPurposeId;

  public static final String SERIALIZED_NAME_LOAN_PURPOSE_NAME = "loanPurposeName";
  @SerializedName(SERIALIZED_NAME_LOAN_PURPOSE_NAME)
  private String loanPurposeName;

  public static final String SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE = "loanScheduleProcessingType";
  @SerializedName(SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE)
  private EnumOptionData loanScheduleProcessingType;

  public static final String SERIALIZED_NAME_LOAN_SCHEDULE_TYPE = "loanScheduleType";
  @SerializedName(SERIALIZED_NAME_LOAN_SCHEDULE_TYPE)
  private EnumOptionData loanScheduleType;

  public static final String SERIALIZED_NAME_LOAN_TERM_VARIATIONS = "loanTermVariations";
  @SerializedName(SERIALIZED_NAME_LOAN_TERM_VARIATIONS)
  private List<GetLoansLoanIdLoanTermVariations> loanTermVariations;

  public static final String SERIALIZED_NAME_LOAN_TYPE = "loanType";
  @SerializedName(SERIALIZED_NAME_LOAN_TYPE)
  private GetLoansLoanIdLoanType loanType;

  public static final String SERIALIZED_NAME_NET_DISBURSAL_AMOUNT = "netDisbursalAmount";
  @SerializedName(SERIALIZED_NAME_NET_DISBURSAL_AMOUNT)
  private BigDecimal netDisbursalAmount;

  public static final String SERIALIZED_NAME_NUMBER_OF_REPAYMENTS = "numberOfRepayments";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_REPAYMENTS)
  private Integer numberOfRepayments;

  public static final String SERIALIZED_NAME_OVERPAID_ON_DATE = "overpaidOnDate";
  @SerializedName(SERIALIZED_NAME_OVERPAID_ON_DATE)
  private LocalDate overpaidOnDate;

  public static final String SERIALIZED_NAME_PRINCIPAL = "principal";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL)
  private BigDecimal principal;

  public static final String SERIALIZED_NAME_PROPOSED_PRINCIPAL = "proposedPrincipal";
  @SerializedName(SERIALIZED_NAME_PROPOSED_PRINCIPAL)
  private BigDecimal proposedPrincipal;

  public static final String SERIALIZED_NAME_REPAYMENT_EVERY = "repaymentEvery";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_EVERY)
  private Integer repaymentEvery;

  public static final String SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE = "repaymentFrequencyType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE)
  private GetLoansLoanIdRepaymentFrequencyType repaymentFrequencyType;

  public static final String SERIALIZED_NAME_REPAYMENT_SCHEDULE = "repaymentSchedule";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_SCHEDULE)
  private GetLoansLoanIdRepaymentSchedule repaymentSchedule;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private GetLoansLoanIdStatus status;

  public static final String SERIALIZED_NAME_SUMMARY = "summary";
  @SerializedName(SERIALIZED_NAME_SUMMARY)
  private GetLoansLoanIdSummary summary;

  public static final String SERIALIZED_NAME_TERM_FREQUENCY = "termFrequency";
  @SerializedName(SERIALIZED_NAME_TERM_FREQUENCY)
  private Integer termFrequency;

  public static final String SERIALIZED_NAME_TERM_PERIOD_FREQUENCY_TYPE = "termPeriodFrequencyType";
  @SerializedName(SERIALIZED_NAME_TERM_PERIOD_FREQUENCY_TYPE)
  private GetLoansLoanIdTermPeriodFrequencyType termPeriodFrequencyType;

  public static final String SERIALIZED_NAME_TIMELINE = "timeline";
  @SerializedName(SERIALIZED_NAME_TIMELINE)
  private GetLoansLoanIdTimeline timeline;

  public static final String SERIALIZED_NAME_TOTAL_OVERPAID = "totalOverpaid";
  @SerializedName(SERIALIZED_NAME_TOTAL_OVERPAID)
  private BigDecimal totalOverpaid;

  public static final String SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_CODE = "transactionProcessingStrategyCode";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_CODE)
  private String transactionProcessingStrategyCode;

  public static final String SERIALIZED_NAME_TRANSACTIONS = "transactions";
  @SerializedName(SERIALIZED_NAME_TRANSACTIONS)
  private List<GetLoansLoanIdTransactions> transactions;

  public GetLoansLoanIdResponse() {
  }

  public GetLoansLoanIdResponse accountNo(String accountNo) {
    
    this.accountNo = accountNo;
    return this;
  }

  /**
   * Get accountNo
   * @return accountNo
   */
  @javax.annotation.Nullable

  public String getAccountNo() {
    return accountNo;
  }


  public void setAccountNo(String accountNo) {
    this.accountNo = accountNo;
  }

  public GetLoansLoanIdResponse amortizationType(GetLoansLoanIdAmortizationType amortizationType) {
    
    this.amortizationType = amortizationType;
    return this;
  }

  /**
   * Get amortizationType
   * @return amortizationType
   */
  @javax.annotation.Nullable

  public GetLoansLoanIdAmortizationType getAmortizationType() {
    return amortizationType;
  }


  public void setAmortizationType(GetLoansLoanIdAmortizationType amortizationType) {
    this.amortizationType = amortizationType;
  }

  public GetLoansLoanIdResponse annualInterestRate(BigDecimal annualInterestRate) {
    
    this.annualInterestRate = annualInterestRate;
    return this;
  }

  /**
   * Get annualInterestRate
   * @return annualInterestRate
   */
  @javax.annotation.Nullable

  public BigDecimal getAnnualInterestRate() {
    return annualInterestRate;
  }


  public void setAnnualInterestRate(BigDecimal annualInterestRate) {
    this.annualInterestRate = annualInterestRate;
  }

  public GetLoansLoanIdResponse approvedPrincipal(BigDecimal approvedPrincipal) {
    
    this.approvedPrincipal = approvedPrincipal;
    return this;
  }

  /**
   * Get approvedPrincipal
   * @return approvedPrincipal
   */
  @javax.annotation.Nullable

  public BigDecimal getApprovedPrincipal() {
    return approvedPrincipal;
  }


  public void setApprovedPrincipal(BigDecimal approvedPrincipal) {
    this.approvedPrincipal = approvedPrincipal;
  }

  public GetLoansLoanIdResponse buyDownFeeCalculationType(StringEnumOptionData buyDownFeeCalculationType) {
    
    this.buyDownFeeCalculationType = buyDownFeeCalculationType;
    return this;
  }

  /**
   * Get buyDownFeeCalculationType
   * @return buyDownFeeCalculationType
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getBuyDownFeeCalculationType() {
    return buyDownFeeCalculationType;
  }


  public void setBuyDownFeeCalculationType(StringEnumOptionData buyDownFeeCalculationType) {
    this.buyDownFeeCalculationType = buyDownFeeCalculationType;
  }

  public GetLoansLoanIdResponse buyDownFeeIncomeType(StringEnumOptionData buyDownFeeIncomeType) {
    
    this.buyDownFeeIncomeType = buyDownFeeIncomeType;
    return this;
  }

  /**
   * Get buyDownFeeIncomeType
   * @return buyDownFeeIncomeType
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getBuyDownFeeIncomeType() {
    return buyDownFeeIncomeType;
  }


  public void setBuyDownFeeIncomeType(StringEnumOptionData buyDownFeeIncomeType) {
    this.buyDownFeeIncomeType = buyDownFeeIncomeType;
  }

  public GetLoansLoanIdResponse buyDownFeeStrategy(StringEnumOptionData buyDownFeeStrategy) {
    
    this.buyDownFeeStrategy = buyDownFeeStrategy;
    return this;
  }

  /**
   * Get buyDownFeeStrategy
   * @return buyDownFeeStrategy
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getBuyDownFeeStrategy() {
    return buyDownFeeStrategy;
  }


  public void setBuyDownFeeStrategy(StringEnumOptionData buyDownFeeStrategy) {
    this.buyDownFeeStrategy = buyDownFeeStrategy;
  }

  public GetLoansLoanIdResponse capitalizedIncomeCalculationType(StringEnumOptionData capitalizedIncomeCalculationType) {
    
    this.capitalizedIncomeCalculationType = capitalizedIncomeCalculationType;
    return this;
  }

  /**
   * Get capitalizedIncomeCalculationType
   * @return capitalizedIncomeCalculationType
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getCapitalizedIncomeCalculationType() {
    return capitalizedIncomeCalculationType;
  }


  public void setCapitalizedIncomeCalculationType(StringEnumOptionData capitalizedIncomeCalculationType) {
    this.capitalizedIncomeCalculationType = capitalizedIncomeCalculationType;
  }

  public GetLoansLoanIdResponse capitalizedIncomeStrategy(StringEnumOptionData capitalizedIncomeStrategy) {
    
    this.capitalizedIncomeStrategy = capitalizedIncomeStrategy;
    return this;
  }

  /**
   * Get capitalizedIncomeStrategy
   * @return capitalizedIncomeStrategy
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getCapitalizedIncomeStrategy() {
    return capitalizedIncomeStrategy;
  }


  public void setCapitalizedIncomeStrategy(StringEnumOptionData capitalizedIncomeStrategy) {
    this.capitalizedIncomeStrategy = capitalizedIncomeStrategy;
  }

  public GetLoansLoanIdResponse capitalizedIncomeType(StringEnumOptionData capitalizedIncomeType) {
    
    this.capitalizedIncomeType = capitalizedIncomeType;
    return this;
  }

  /**
   * Get capitalizedIncomeType
   * @return capitalizedIncomeType
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getCapitalizedIncomeType() {
    return capitalizedIncomeType;
  }


  public void setCapitalizedIncomeType(StringEnumOptionData capitalizedIncomeType) {
    this.capitalizedIncomeType = capitalizedIncomeType;
  }

  public GetLoansLoanIdResponse chargeOffBehaviour(StringEnumOptionData chargeOffBehaviour) {
    
    this.chargeOffBehaviour = chargeOffBehaviour;
    return this;
  }

  /**
   * Get chargeOffBehaviour
   * @return chargeOffBehaviour
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getChargeOffBehaviour() {
    return chargeOffBehaviour;
  }


  public void setChargeOffBehaviour(StringEnumOptionData chargeOffBehaviour) {
    this.chargeOffBehaviour = chargeOffBehaviour;
  }

  public GetLoansLoanIdResponse chargedOff(Boolean chargedOff) {
    
    this.chargedOff = chargedOff;
    return this;
  }

  /**
   * Get chargedOff
   * @return chargedOff
   */
  @javax.annotation.Nullable

  public Boolean getChargedOff() {
    return chargedOff;
  }


  public void setChargedOff(Boolean chargedOff) {
    this.chargedOff = chargedOff;
  }

  public GetLoansLoanIdResponse charges(List<GetLoansLoanIdLoanChargeData> charges) {
    
    this.charges = charges;
    return this;
  }

  public GetLoansLoanIdResponse addChargesItem(GetLoansLoanIdLoanChargeData chargesItem) {
    if (this.charges == null) {
      this.charges = new ArrayList<>();
    }
    this.charges.add(chargesItem);
    return this;
  }

  /**
   * Set of charges
   * @return charges
   */
  @javax.annotation.Nullable

  public List<GetLoansLoanIdLoanChargeData> getCharges() {
    return charges;
  }


  public void setCharges(List<GetLoansLoanIdLoanChargeData> charges) {
    this.charges = charges;
  }

  public GetLoansLoanIdResponse clientExternalId(String clientExternalId) {
    
    this.clientExternalId = clientExternalId;
    return this;
  }

  /**
   * Get clientExternalId
   * @return clientExternalId
   */
  @javax.annotation.Nullable

  public String getClientExternalId() {
    return clientExternalId;
  }


  public void setClientExternalId(String clientExternalId) {
    this.clientExternalId = clientExternalId;
  }

  public GetLoansLoanIdResponse clientId(Long clientId) {
    
    this.clientId = clientId;
    return this;
  }

  /**
   * Get clientId
   * @return clientId
   */
  @javax.annotation.Nullable

  public Long getClientId() {
    return clientId;
  }


  public void setClientId(Long clientId) {
    this.clientId = clientId;
  }

  public GetLoansLoanIdResponse clientName(String clientName) {
    
    this.clientName = clientName;
    return this;
  }

  /**
   * Get clientName
   * @return clientName
   */
  @javax.annotation.Nullable

  public String getClientName() {
    return clientName;
  }


  public void setClientName(String clientName) {
    this.clientName = clientName;
  }

  public GetLoansLoanIdResponse clientOfficeId(Long clientOfficeId) {
    
    this.clientOfficeId = clientOfficeId;
    return this;
  }

  /**
   * Get clientOfficeId
   * @return clientOfficeId
   */
  @javax.annotation.Nullable

  public Long getClientOfficeId() {
    return clientOfficeId;
  }


  public void setClientOfficeId(Long clientOfficeId) {
    this.clientOfficeId = clientOfficeId;
  }

  public GetLoansLoanIdResponse currency(GetLoansLoanIdCurrency currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public GetLoansLoanIdCurrency getCurrency() {
    return currency;
  }


  public void setCurrency(GetLoansLoanIdCurrency currency) {
    this.currency = currency;
  }

  public GetLoansLoanIdResponse delinquencyRange(DelinquencyRangeData delinquencyRange) {
    
    this.delinquencyRange = delinquencyRange;
    return this;
  }

  /**
   * Get delinquencyRange
   * @return delinquencyRange
   */
  @javax.annotation.Nullable

  public DelinquencyRangeData getDelinquencyRange() {
    return delinquencyRange;
  }


  public void setDelinquencyRange(DelinquencyRangeData delinquencyRange) {
    this.delinquencyRange = delinquencyRange;
  }

  public GetLoansLoanIdResponse delinquent(GetLoansLoanIdDelinquencySummary delinquent) {
    
    this.delinquent = delinquent;
    return this;
  }

  /**
   * Get delinquent
   * @return delinquent
   */
  @javax.annotation.Nullable

  public GetLoansLoanIdDelinquencySummary getDelinquent() {
    return delinquent;
  }


  public void setDelinquent(GetLoansLoanIdDelinquencySummary delinquent) {
    this.delinquent = delinquent;
  }

  public GetLoansLoanIdResponse disallowExpectedDisbursements(Boolean disallowExpectedDisbursements) {
    
    this.disallowExpectedDisbursements = disallowExpectedDisbursements;
    return this;
  }

  /**
   * Get disallowExpectedDisbursements
   * @return disallowExpectedDisbursements
   */
  @javax.annotation.Nullable

  public Boolean getDisallowExpectedDisbursements() {
    return disallowExpectedDisbursements;
  }


  public void setDisallowExpectedDisbursements(Boolean disallowExpectedDisbursements) {
    this.disallowExpectedDisbursements = disallowExpectedDisbursements;
  }

  public GetLoansLoanIdResponse disbursedAmountPercentageForDownPayment(BigDecimal disbursedAmountPercentageForDownPayment) {
    
    this.disbursedAmountPercentageForDownPayment = disbursedAmountPercentageForDownPayment;
    return this;
  }

  /**
   * Get disbursedAmountPercentageForDownPayment
   * @return disbursedAmountPercentageForDownPayment
   */
  @javax.annotation.Nullable

  public BigDecimal getDisbursedAmountPercentageForDownPayment() {
    return disbursedAmountPercentageForDownPayment;
  }


  public void setDisbursedAmountPercentageForDownPayment(BigDecimal disbursedAmountPercentageForDownPayment) {
    this.disbursedAmountPercentageForDownPayment = disbursedAmountPercentageForDownPayment;
  }

  public GetLoansLoanIdResponse disbursementDetails(Set<GetLoansLoanIdDisbursementDetails> disbursementDetails) {
    
    this.disbursementDetails = disbursementDetails;
    return this;
  }

  public GetLoansLoanIdResponse addDisbursementDetailsItem(GetLoansLoanIdDisbursementDetails disbursementDetailsItem) {
    if (this.disbursementDetails == null) {
      this.disbursementDetails = new LinkedHashSet<>();
    }
    this.disbursementDetails.add(disbursementDetailsItem);
    return this;
  }

  /**
   * Set of GetLoansLoanIdDisbursementDetails
   * @return disbursementDetails
   */
  @javax.annotation.Nullable

  public Set<GetLoansLoanIdDisbursementDetails> getDisbursementDetails() {
    return disbursementDetails;
  }


  public void setDisbursementDetails(Set<GetLoansLoanIdDisbursementDetails> disbursementDetails) {
    this.disbursementDetails = disbursementDetails;
  }

  public GetLoansLoanIdResponse emiAmountVariations(List<GetLoansLoanIdLoanTermVariations> emiAmountVariations) {
    
    this.emiAmountVariations = emiAmountVariations;
    return this;
  }

  public GetLoansLoanIdResponse addEmiAmountVariationsItem(GetLoansLoanIdLoanTermVariations emiAmountVariationsItem) {
    if (this.emiAmountVariations == null) {
      this.emiAmountVariations = new ArrayList<>();
    }
    this.emiAmountVariations.add(emiAmountVariationsItem);
    return this;
  }

  /**
   * List of GetLoansLoanIdLoanTermVariations
   * @return emiAmountVariations
   */
  @javax.annotation.Nullable

  public List<GetLoansLoanIdLoanTermVariations> getEmiAmountVariations() {
    return emiAmountVariations;
  }


  public void setEmiAmountVariations(List<GetLoansLoanIdLoanTermVariations> emiAmountVariations) {
    this.emiAmountVariations = emiAmountVariations;
  }

  public GetLoansLoanIdResponse enableAutoRepaymentForDownPayment(Boolean enableAutoRepaymentForDownPayment) {
    
    this.enableAutoRepaymentForDownPayment = enableAutoRepaymentForDownPayment;
    return this;
  }

  /**
   * Get enableAutoRepaymentForDownPayment
   * @return enableAutoRepaymentForDownPayment
   */
  @javax.annotation.Nullable

  public Boolean getEnableAutoRepaymentForDownPayment() {
    return enableAutoRepaymentForDownPayment;
  }


  public void setEnableAutoRepaymentForDownPayment(Boolean enableAutoRepaymentForDownPayment) {
    this.enableAutoRepaymentForDownPayment = enableAutoRepaymentForDownPayment;
  }

  public GetLoansLoanIdResponse enableBuyDownFee(Boolean enableBuyDownFee) {
    
    this.enableBuyDownFee = enableBuyDownFee;
    return this;
  }

  /**
   * Get enableBuyDownFee
   * @return enableBuyDownFee
   */
  @javax.annotation.Nullable

  public Boolean getEnableBuyDownFee() {
    return enableBuyDownFee;
  }


  public void setEnableBuyDownFee(Boolean enableBuyDownFee) {
    this.enableBuyDownFee = enableBuyDownFee;
  }

  public GetLoansLoanIdResponse enableDownPayment(Boolean enableDownPayment) {
    
    this.enableDownPayment = enableDownPayment;
    return this;
  }

  /**
   * Get enableDownPayment
   * @return enableDownPayment
   */
  @javax.annotation.Nullable

  public Boolean getEnableDownPayment() {
    return enableDownPayment;
  }


  public void setEnableDownPayment(Boolean enableDownPayment) {
    this.enableDownPayment = enableDownPayment;
  }

  public GetLoansLoanIdResponse enableIncomeCapitalization(Boolean enableIncomeCapitalization) {
    
    this.enableIncomeCapitalization = enableIncomeCapitalization;
    return this;
  }

  /**
   * Get enableIncomeCapitalization
   * @return enableIncomeCapitalization
   */
  @javax.annotation.Nullable

  public Boolean getEnableIncomeCapitalization() {
    return enableIncomeCapitalization;
  }


  public void setEnableIncomeCapitalization(Boolean enableIncomeCapitalization) {
    this.enableIncomeCapitalization = enableIncomeCapitalization;
  }

  public GetLoansLoanIdResponse enableInstallmentLevelDelinquency(Boolean enableInstallmentLevelDelinquency) {
    
    this.enableInstallmentLevelDelinquency = enableInstallmentLevelDelinquency;
    return this;
  }

  /**
   * Get enableInstallmentLevelDelinquency
   * @return enableInstallmentLevelDelinquency
   */
  @javax.annotation.Nullable

  public Boolean getEnableInstallmentLevelDelinquency() {
    return enableInstallmentLevelDelinquency;
  }


  public void setEnableInstallmentLevelDelinquency(Boolean enableInstallmentLevelDelinquency) {
    this.enableInstallmentLevelDelinquency = enableInstallmentLevelDelinquency;
  }

  public GetLoansLoanIdResponse externalId(String externalId) {
    
    this.externalId = externalId;
    return this;
  }

  /**
   * Get externalId
   * @return externalId
   */
  @javax.annotation.Nullable

  public String getExternalId() {
    return externalId;
  }


  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public GetLoansLoanIdResponse fixedLength(Integer fixedLength) {
    
    this.fixedLength = fixedLength;
    return this;
  }

  /**
   * Get fixedLength
   * @return fixedLength
   */
  @javax.annotation.Nullable

  public Integer getFixedLength() {
    return fixedLength;
  }


  public void setFixedLength(Integer fixedLength) {
    this.fixedLength = fixedLength;
  }

  public GetLoansLoanIdResponse fixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
    
    this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
    return this;
  }

  /**
   * Get fixedPrincipalPercentagePerInstallment
   * @return fixedPrincipalPercentagePerInstallment
   */
  @javax.annotation.Nullable

  public BigDecimal getFixedPrincipalPercentagePerInstallment() {
    return fixedPrincipalPercentagePerInstallment;
  }


  public void setFixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
    this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
  }

  public GetLoansLoanIdResponse fraud(Boolean fraud) {
    
    this.fraud = fraud;
    return this;
  }

  /**
   * Get fraud
   * @return fraud
   */
  @javax.annotation.Nullable

  public Boolean getFraud() {
    return fraud;
  }


  public void setFraud(Boolean fraud) {
    this.fraud = fraud;
  }

  public GetLoansLoanIdResponse id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public GetLoansLoanIdResponse inArrearsTolerance(Integer inArrearsTolerance) {
    
    this.inArrearsTolerance = inArrearsTolerance;
    return this;
  }

  /**
   * Get inArrearsTolerance
   * @return inArrearsTolerance
   */
  @javax.annotation.Nullable

  public Integer getInArrearsTolerance() {
    return inArrearsTolerance;
  }


  public void setInArrearsTolerance(Integer inArrearsTolerance) {
    this.inArrearsTolerance = inArrearsTolerance;
  }

  public GetLoansLoanIdResponse interestCalculationPeriodType(GetLoansLoanIdInterestCalculationPeriodType interestCalculationPeriodType) {
    
    this.interestCalculationPeriodType = interestCalculationPeriodType;
    return this;
  }

  /**
   * Get interestCalculationPeriodType
   * @return interestCalculationPeriodType
   */
  @javax.annotation.Nullable

  public GetLoansLoanIdInterestCalculationPeriodType getInterestCalculationPeriodType() {
    return interestCalculationPeriodType;
  }


  public void setInterestCalculationPeriodType(GetLoansLoanIdInterestCalculationPeriodType interestCalculationPeriodType) {
    this.interestCalculationPeriodType = interestCalculationPeriodType;
  }

  public GetLoansLoanIdResponse interestRateFrequencyType(GetLoansLoanIdInterestRateFrequencyType interestRateFrequencyType) {
    
    this.interestRateFrequencyType = interestRateFrequencyType;
    return this;
  }

  /**
   * Get interestRateFrequencyType
   * @return interestRateFrequencyType
   */
  @javax.annotation.Nullable

  public GetLoansLoanIdInterestRateFrequencyType getInterestRateFrequencyType() {
    return interestRateFrequencyType;
  }


  public void setInterestRateFrequencyType(GetLoansLoanIdInterestRateFrequencyType interestRateFrequencyType) {
    this.interestRateFrequencyType = interestRateFrequencyType;
  }

  public GetLoansLoanIdResponse interestRatePerPeriod(BigDecimal interestRatePerPeriod) {
    
    this.interestRatePerPeriod = interestRatePerPeriod;
    return this;
  }

  /**
   * Get interestRatePerPeriod
   * @return interestRatePerPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestRatePerPeriod() {
    return interestRatePerPeriod;
  }


  public void setInterestRatePerPeriod(BigDecimal interestRatePerPeriod) {
    this.interestRatePerPeriod = interestRatePerPeriod;
  }

  public GetLoansLoanIdResponse interestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
    return this;
  }

  /**
   * Get interestRecognitionOnDisbursementDate
   * @return interestRecognitionOnDisbursementDate
   */
  @javax.annotation.Nullable

  public Boolean getInterestRecognitionOnDisbursementDate() {
    return interestRecognitionOnDisbursementDate;
  }


  public void setInterestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
  }

  public GetLoansLoanIdResponse interestType(GetLoansLoanIdInterestType interestType) {
    
    this.interestType = interestType;
    return this;
  }

  /**
   * Get interestType
   * @return interestType
   */
  @javax.annotation.Nullable

  public GetLoansLoanIdInterestType getInterestType() {
    return interestType;
  }


  public void setInterestType(GetLoansLoanIdInterestType interestType) {
    this.interestType = interestType;
  }

  public GetLoansLoanIdResponse isFloatingInterestRate(Boolean isFloatingInterestRate) {
    
    this.isFloatingInterestRate = isFloatingInterestRate;
    return this;
  }

  /**
   * Get isFloatingInterestRate
   * @return isFloatingInterestRate
   */
  @javax.annotation.Nullable

  public Boolean getIsFloatingInterestRate() {
    return isFloatingInterestRate;
  }


  public void setIsFloatingInterestRate(Boolean isFloatingInterestRate) {
    this.isFloatingInterestRate = isFloatingInterestRate;
  }

  public GetLoansLoanIdResponse lastClosedBusinessDate(LocalDate lastClosedBusinessDate) {
    
    this.lastClosedBusinessDate = lastClosedBusinessDate;
    return this;
  }

  /**
   * Get lastClosedBusinessDate
   * @return lastClosedBusinessDate
   */
  @javax.annotation.Nullable

  public LocalDate getLastClosedBusinessDate() {
    return lastClosedBusinessDate;
  }


  public void setLastClosedBusinessDate(LocalDate lastClosedBusinessDate) {
    this.lastClosedBusinessDate = lastClosedBusinessDate;
  }

  public GetLoansLoanIdResponse loanOfficerId(Long loanOfficerId) {
    
    this.loanOfficerId = loanOfficerId;
    return this;
  }

  /**
   * Get loanOfficerId
   * @return loanOfficerId
   */
  @javax.annotation.Nullable

  public Long getLoanOfficerId() {
    return loanOfficerId;
  }


  public void setLoanOfficerId(Long loanOfficerId) {
    this.loanOfficerId = loanOfficerId;
  }

  public GetLoansLoanIdResponse loanOfficerName(String loanOfficerName) {
    
    this.loanOfficerName = loanOfficerName;
    return this;
  }

  /**
   * Get loanOfficerName
   * @return loanOfficerName
   */
  @javax.annotation.Nullable

  public String getLoanOfficerName() {
    return loanOfficerName;
  }


  public void setLoanOfficerName(String loanOfficerName) {
    this.loanOfficerName = loanOfficerName;
  }

  public GetLoansLoanIdResponse loanProductDescription(String loanProductDescription) {
    
    this.loanProductDescription = loanProductDescription;
    return this;
  }

  /**
   * Get loanProductDescription
   * @return loanProductDescription
   */
  @javax.annotation.Nullable

  public String getLoanProductDescription() {
    return loanProductDescription;
  }


  public void setLoanProductDescription(String loanProductDescription) {
    this.loanProductDescription = loanProductDescription;
  }

  public GetLoansLoanIdResponse loanProductId(Long loanProductId) {
    
    this.loanProductId = loanProductId;
    return this;
  }

  /**
   * Get loanProductId
   * @return loanProductId
   */
  @javax.annotation.Nullable

  public Long getLoanProductId() {
    return loanProductId;
  }


  public void setLoanProductId(Long loanProductId) {
    this.loanProductId = loanProductId;
  }

  public GetLoansLoanIdResponse loanProductName(String loanProductName) {
    
    this.loanProductName = loanProductName;
    return this;
  }

  /**
   * Get loanProductName
   * @return loanProductName
   */
  @javax.annotation.Nullable

  public String getLoanProductName() {
    return loanProductName;
  }


  public void setLoanProductName(String loanProductName) {
    this.loanProductName = loanProductName;
  }

  public GetLoansLoanIdResponse loanPurposeId(Long loanPurposeId) {
    
    this.loanPurposeId = loanPurposeId;
    return this;
  }

  /**
   * Get loanPurposeId
   * @return loanPurposeId
   */
  @javax.annotation.Nullable

  public Long getLoanPurposeId() {
    return loanPurposeId;
  }


  public void setLoanPurposeId(Long loanPurposeId) {
    this.loanPurposeId = loanPurposeId;
  }

  public GetLoansLoanIdResponse loanPurposeName(String loanPurposeName) {
    
    this.loanPurposeName = loanPurposeName;
    return this;
  }

  /**
   * Get loanPurposeName
   * @return loanPurposeName
   */
  @javax.annotation.Nullable

  public String getLoanPurposeName() {
    return loanPurposeName;
  }


  public void setLoanPurposeName(String loanPurposeName) {
    this.loanPurposeName = loanPurposeName;
  }

  public GetLoansLoanIdResponse loanScheduleProcessingType(EnumOptionData loanScheduleProcessingType) {
    
    this.loanScheduleProcessingType = loanScheduleProcessingType;
    return this;
  }

  /**
   * Get loanScheduleProcessingType
   * @return loanScheduleProcessingType
   */
  @javax.annotation.Nullable

  public EnumOptionData getLoanScheduleProcessingType() {
    return loanScheduleProcessingType;
  }


  public void setLoanScheduleProcessingType(EnumOptionData loanScheduleProcessingType) {
    this.loanScheduleProcessingType = loanScheduleProcessingType;
  }

  public GetLoansLoanIdResponse loanScheduleType(EnumOptionData loanScheduleType) {
    
    this.loanScheduleType = loanScheduleType;
    return this;
  }

  /**
   * Get loanScheduleType
   * @return loanScheduleType
   */
  @javax.annotation.Nullable

  public EnumOptionData getLoanScheduleType() {
    return loanScheduleType;
  }


  public void setLoanScheduleType(EnumOptionData loanScheduleType) {
    this.loanScheduleType = loanScheduleType;
  }

  public GetLoansLoanIdResponse loanTermVariations(List<GetLoansLoanIdLoanTermVariations> loanTermVariations) {
    
    this.loanTermVariations = loanTermVariations;
    return this;
  }

  public GetLoansLoanIdResponse addLoanTermVariationsItem(GetLoansLoanIdLoanTermVariations loanTermVariationsItem) {
    if (this.loanTermVariations == null) {
      this.loanTermVariations = new ArrayList<>();
    }
    this.loanTermVariations.add(loanTermVariationsItem);
    return this;
  }

  /**
   * List of GetLoansLoanIdLoanTermVariations
   * @return loanTermVariations
   */
  @javax.annotation.Nullable

  public List<GetLoansLoanIdLoanTermVariations> getLoanTermVariations() {
    return loanTermVariations;
  }


  public void setLoanTermVariations(List<GetLoansLoanIdLoanTermVariations> loanTermVariations) {
    this.loanTermVariations = loanTermVariations;
  }

  public GetLoansLoanIdResponse loanType(GetLoansLoanIdLoanType loanType) {
    
    this.loanType = loanType;
    return this;
  }

  /**
   * Get loanType
   * @return loanType
   */
  @javax.annotation.Nullable

  public GetLoansLoanIdLoanType getLoanType() {
    return loanType;
  }


  public void setLoanType(GetLoansLoanIdLoanType loanType) {
    this.loanType = loanType;
  }

  public GetLoansLoanIdResponse netDisbursalAmount(BigDecimal netDisbursalAmount) {
    
    this.netDisbursalAmount = netDisbursalAmount;
    return this;
  }

  /**
   * Get netDisbursalAmount
   * @return netDisbursalAmount
   */
  @javax.annotation.Nullable

  public BigDecimal getNetDisbursalAmount() {
    return netDisbursalAmount;
  }


  public void setNetDisbursalAmount(BigDecimal netDisbursalAmount) {
    this.netDisbursalAmount = netDisbursalAmount;
  }

  public GetLoansLoanIdResponse numberOfRepayments(Integer numberOfRepayments) {
    
    this.numberOfRepayments = numberOfRepayments;
    return this;
  }

  /**
   * Get numberOfRepayments
   * @return numberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getNumberOfRepayments() {
    return numberOfRepayments;
  }


  public void setNumberOfRepayments(Integer numberOfRepayments) {
    this.numberOfRepayments = numberOfRepayments;
  }

  public GetLoansLoanIdResponse overpaidOnDate(LocalDate overpaidOnDate) {
    
    this.overpaidOnDate = overpaidOnDate;
    return this;
  }

  /**
   * Get overpaidOnDate
   * @return overpaidOnDate
   */
  @javax.annotation.Nullable

  public LocalDate getOverpaidOnDate() {
    return overpaidOnDate;
  }


  public void setOverpaidOnDate(LocalDate overpaidOnDate) {
    this.overpaidOnDate = overpaidOnDate;
  }

  public GetLoansLoanIdResponse principal(BigDecimal principal) {
    
    this.principal = principal;
    return this;
  }

  /**
   * Get principal
   * @return principal
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipal() {
    return principal;
  }


  public void setPrincipal(BigDecimal principal) {
    this.principal = principal;
  }

  public GetLoansLoanIdResponse proposedPrincipal(BigDecimal proposedPrincipal) {
    
    this.proposedPrincipal = proposedPrincipal;
    return this;
  }

  /**
   * Get proposedPrincipal
   * @return proposedPrincipal
   */
  @javax.annotation.Nullable

  public BigDecimal getProposedPrincipal() {
    return proposedPrincipal;
  }


  public void setProposedPrincipal(BigDecimal proposedPrincipal) {
    this.proposedPrincipal = proposedPrincipal;
  }

  public GetLoansLoanIdResponse repaymentEvery(Integer repaymentEvery) {
    
    this.repaymentEvery = repaymentEvery;
    return this;
  }

  /**
   * Get repaymentEvery
   * @return repaymentEvery
   */
  @javax.annotation.Nullable

  public Integer getRepaymentEvery() {
    return repaymentEvery;
  }


  public void setRepaymentEvery(Integer repaymentEvery) {
    this.repaymentEvery = repaymentEvery;
  }

  public GetLoansLoanIdResponse repaymentFrequencyType(GetLoansLoanIdRepaymentFrequencyType repaymentFrequencyType) {
    
    this.repaymentFrequencyType = repaymentFrequencyType;
    return this;
  }

  /**
   * Get repaymentFrequencyType
   * @return repaymentFrequencyType
   */
  @javax.annotation.Nullable

  public GetLoansLoanIdRepaymentFrequencyType getRepaymentFrequencyType() {
    return repaymentFrequencyType;
  }


  public void setRepaymentFrequencyType(GetLoansLoanIdRepaymentFrequencyType repaymentFrequencyType) {
    this.repaymentFrequencyType = repaymentFrequencyType;
  }

  public GetLoansLoanIdResponse repaymentSchedule(GetLoansLoanIdRepaymentSchedule repaymentSchedule) {
    
    this.repaymentSchedule = repaymentSchedule;
    return this;
  }

  /**
   * Get repaymentSchedule
   * @return repaymentSchedule
   */
  @javax.annotation.Nullable

  public GetLoansLoanIdRepaymentSchedule getRepaymentSchedule() {
    return repaymentSchedule;
  }


  public void setRepaymentSchedule(GetLoansLoanIdRepaymentSchedule repaymentSchedule) {
    this.repaymentSchedule = repaymentSchedule;
  }

  public GetLoansLoanIdResponse status(GetLoansLoanIdStatus status) {
    
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
   */
  @javax.annotation.Nullable

  public GetLoansLoanIdStatus getStatus() {
    return status;
  }


  public void setStatus(GetLoansLoanIdStatus status) {
    this.status = status;
  }

  public GetLoansLoanIdResponse summary(GetLoansLoanIdSummary summary) {
    
    this.summary = summary;
    return this;
  }

  /**
   * Get summary
   * @return summary
   */
  @javax.annotation.Nullable

  public GetLoansLoanIdSummary getSummary() {
    return summary;
  }


  public void setSummary(GetLoansLoanIdSummary summary) {
    this.summary = summary;
  }

  public GetLoansLoanIdResponse termFrequency(Integer termFrequency) {
    
    this.termFrequency = termFrequency;
    return this;
  }

  /**
   * Get termFrequency
   * @return termFrequency
   */
  @javax.annotation.Nullable

  public Integer getTermFrequency() {
    return termFrequency;
  }


  public void setTermFrequency(Integer termFrequency) {
    this.termFrequency = termFrequency;
  }

  public GetLoansLoanIdResponse termPeriodFrequencyType(GetLoansLoanIdTermPeriodFrequencyType termPeriodFrequencyType) {
    
    this.termPeriodFrequencyType = termPeriodFrequencyType;
    return this;
  }

  /**
   * Get termPeriodFrequencyType
   * @return termPeriodFrequencyType
   */
  @javax.annotation.Nullable

  public GetLoansLoanIdTermPeriodFrequencyType getTermPeriodFrequencyType() {
    return termPeriodFrequencyType;
  }


  public void setTermPeriodFrequencyType(GetLoansLoanIdTermPeriodFrequencyType termPeriodFrequencyType) {
    this.termPeriodFrequencyType = termPeriodFrequencyType;
  }

  public GetLoansLoanIdResponse timeline(GetLoansLoanIdTimeline timeline) {
    
    this.timeline = timeline;
    return this;
  }

  /**
   * Get timeline
   * @return timeline
   */
  @javax.annotation.Nullable

  public GetLoansLoanIdTimeline getTimeline() {
    return timeline;
  }


  public void setTimeline(GetLoansLoanIdTimeline timeline) {
    this.timeline = timeline;
  }

  public GetLoansLoanIdResponse totalOverpaid(BigDecimal totalOverpaid) {
    
    this.totalOverpaid = totalOverpaid;
    return this;
  }

  /**
   * Get totalOverpaid
   * @return totalOverpaid
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalOverpaid() {
    return totalOverpaid;
  }


  public void setTotalOverpaid(BigDecimal totalOverpaid) {
    this.totalOverpaid = totalOverpaid;
  }

  public GetLoansLoanIdResponse transactionProcessingStrategyCode(String transactionProcessingStrategyCode) {
    
    this.transactionProcessingStrategyCode = transactionProcessingStrategyCode;
    return this;
  }

  /**
   * Get transactionProcessingStrategyCode
   * @return transactionProcessingStrategyCode
   */
  @javax.annotation.Nullable

  public String getTransactionProcessingStrategyCode() {
    return transactionProcessingStrategyCode;
  }


  public void setTransactionProcessingStrategyCode(String transactionProcessingStrategyCode) {
    this.transactionProcessingStrategyCode = transactionProcessingStrategyCode;
  }

  public GetLoansLoanIdResponse transactions(List<GetLoansLoanIdTransactions> transactions) {
    
    this.transactions = transactions;
    return this;
  }

  public GetLoansLoanIdResponse addTransactionsItem(GetLoansLoanIdTransactions transactionsItem) {
    if (this.transactions == null) {
      this.transactions = new ArrayList<>();
    }
    this.transactions.add(transactionsItem);
    return this;
  }

  /**
   * Set of GetLoansLoanIdTransactions
   * @return transactions
   */
  @javax.annotation.Nullable

  public List<GetLoansLoanIdTransactions> getTransactions() {
    return transactions;
  }


  public void setTransactions(List<GetLoansLoanIdTransactions> transactions) {
    this.transactions = transactions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetLoansLoanIdResponse getLoansLoanIdResponse = (GetLoansLoanIdResponse) o;
    return Objects.equals(this.accountNo, getLoansLoanIdResponse.accountNo) &&
        Objects.equals(this.amortizationType, getLoansLoanIdResponse.amortizationType) &&
        Objects.equals(this.annualInterestRate, getLoansLoanIdResponse.annualInterestRate) &&
        Objects.equals(this.approvedPrincipal, getLoansLoanIdResponse.approvedPrincipal) &&
        Objects.equals(this.buyDownFeeCalculationType, getLoansLoanIdResponse.buyDownFeeCalculationType) &&
        Objects.equals(this.buyDownFeeIncomeType, getLoansLoanIdResponse.buyDownFeeIncomeType) &&
        Objects.equals(this.buyDownFeeStrategy, getLoansLoanIdResponse.buyDownFeeStrategy) &&
        Objects.equals(this.capitalizedIncomeCalculationType, getLoansLoanIdResponse.capitalizedIncomeCalculationType) &&
        Objects.equals(this.capitalizedIncomeStrategy, getLoansLoanIdResponse.capitalizedIncomeStrategy) &&
        Objects.equals(this.capitalizedIncomeType, getLoansLoanIdResponse.capitalizedIncomeType) &&
        Objects.equals(this.chargeOffBehaviour, getLoansLoanIdResponse.chargeOffBehaviour) &&
        Objects.equals(this.chargedOff, getLoansLoanIdResponse.chargedOff) &&
        Objects.equals(this.charges, getLoansLoanIdResponse.charges) &&
        Objects.equals(this.clientExternalId, getLoansLoanIdResponse.clientExternalId) &&
        Objects.equals(this.clientId, getLoansLoanIdResponse.clientId) &&
        Objects.equals(this.clientName, getLoansLoanIdResponse.clientName) &&
        Objects.equals(this.clientOfficeId, getLoansLoanIdResponse.clientOfficeId) &&
        Objects.equals(this.currency, getLoansLoanIdResponse.currency) &&
        Objects.equals(this.delinquencyRange, getLoansLoanIdResponse.delinquencyRange) &&
        Objects.equals(this.delinquent, getLoansLoanIdResponse.delinquent) &&
        Objects.equals(this.disallowExpectedDisbursements, getLoansLoanIdResponse.disallowExpectedDisbursements) &&
        Objects.equals(this.disbursedAmountPercentageForDownPayment, getLoansLoanIdResponse.disbursedAmountPercentageForDownPayment) &&
        Objects.equals(this.disbursementDetails, getLoansLoanIdResponse.disbursementDetails) &&
        Objects.equals(this.emiAmountVariations, getLoansLoanIdResponse.emiAmountVariations) &&
        Objects.equals(this.enableAutoRepaymentForDownPayment, getLoansLoanIdResponse.enableAutoRepaymentForDownPayment) &&
        Objects.equals(this.enableBuyDownFee, getLoansLoanIdResponse.enableBuyDownFee) &&
        Objects.equals(this.enableDownPayment, getLoansLoanIdResponse.enableDownPayment) &&
        Objects.equals(this.enableIncomeCapitalization, getLoansLoanIdResponse.enableIncomeCapitalization) &&
        Objects.equals(this.enableInstallmentLevelDelinquency, getLoansLoanIdResponse.enableInstallmentLevelDelinquency) &&
        Objects.equals(this.externalId, getLoansLoanIdResponse.externalId) &&
        Objects.equals(this.fixedLength, getLoansLoanIdResponse.fixedLength) &&
        Objects.equals(this.fixedPrincipalPercentagePerInstallment, getLoansLoanIdResponse.fixedPrincipalPercentagePerInstallment) &&
        Objects.equals(this.fraud, getLoansLoanIdResponse.fraud) &&
        Objects.equals(this.id, getLoansLoanIdResponse.id) &&
        Objects.equals(this.inArrearsTolerance, getLoansLoanIdResponse.inArrearsTolerance) &&
        Objects.equals(this.interestCalculationPeriodType, getLoansLoanIdResponse.interestCalculationPeriodType) &&
        Objects.equals(this.interestRateFrequencyType, getLoansLoanIdResponse.interestRateFrequencyType) &&
        Objects.equals(this.interestRatePerPeriod, getLoansLoanIdResponse.interestRatePerPeriod) &&
        Objects.equals(this.interestRecognitionOnDisbursementDate, getLoansLoanIdResponse.interestRecognitionOnDisbursementDate) &&
        Objects.equals(this.interestType, getLoansLoanIdResponse.interestType) &&
        Objects.equals(this.isFloatingInterestRate, getLoansLoanIdResponse.isFloatingInterestRate) &&
        Objects.equals(this.lastClosedBusinessDate, getLoansLoanIdResponse.lastClosedBusinessDate) &&
        Objects.equals(this.loanOfficerId, getLoansLoanIdResponse.loanOfficerId) &&
        Objects.equals(this.loanOfficerName, getLoansLoanIdResponse.loanOfficerName) &&
        Objects.equals(this.loanProductDescription, getLoansLoanIdResponse.loanProductDescription) &&
        Objects.equals(this.loanProductId, getLoansLoanIdResponse.loanProductId) &&
        Objects.equals(this.loanProductName, getLoansLoanIdResponse.loanProductName) &&
        Objects.equals(this.loanPurposeId, getLoansLoanIdResponse.loanPurposeId) &&
        Objects.equals(this.loanPurposeName, getLoansLoanIdResponse.loanPurposeName) &&
        Objects.equals(this.loanScheduleProcessingType, getLoansLoanIdResponse.loanScheduleProcessingType) &&
        Objects.equals(this.loanScheduleType, getLoansLoanIdResponse.loanScheduleType) &&
        Objects.equals(this.loanTermVariations, getLoansLoanIdResponse.loanTermVariations) &&
        Objects.equals(this.loanType, getLoansLoanIdResponse.loanType) &&
        Objects.equals(this.netDisbursalAmount, getLoansLoanIdResponse.netDisbursalAmount) &&
        Objects.equals(this.numberOfRepayments, getLoansLoanIdResponse.numberOfRepayments) &&
        Objects.equals(this.overpaidOnDate, getLoansLoanIdResponse.overpaidOnDate) &&
        Objects.equals(this.principal, getLoansLoanIdResponse.principal) &&
        Objects.equals(this.proposedPrincipal, getLoansLoanIdResponse.proposedPrincipal) &&
        Objects.equals(this.repaymentEvery, getLoansLoanIdResponse.repaymentEvery) &&
        Objects.equals(this.repaymentFrequencyType, getLoansLoanIdResponse.repaymentFrequencyType) &&
        Objects.equals(this.repaymentSchedule, getLoansLoanIdResponse.repaymentSchedule) &&
        Objects.equals(this.status, getLoansLoanIdResponse.status) &&
        Objects.equals(this.summary, getLoansLoanIdResponse.summary) &&
        Objects.equals(this.termFrequency, getLoansLoanIdResponse.termFrequency) &&
        Objects.equals(this.termPeriodFrequencyType, getLoansLoanIdResponse.termPeriodFrequencyType) &&
        Objects.equals(this.timeline, getLoansLoanIdResponse.timeline) &&
        Objects.equals(this.totalOverpaid, getLoansLoanIdResponse.totalOverpaid) &&
        Objects.equals(this.transactionProcessingStrategyCode, getLoansLoanIdResponse.transactionProcessingStrategyCode) &&
        Objects.equals(this.transactions, getLoansLoanIdResponse.transactions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountNo, amortizationType, annualInterestRate, approvedPrincipal, buyDownFeeCalculationType, buyDownFeeIncomeType, buyDownFeeStrategy, capitalizedIncomeCalculationType, capitalizedIncomeStrategy, capitalizedIncomeType, chargeOffBehaviour, chargedOff, charges, clientExternalId, clientId, clientName, clientOfficeId, currency, delinquencyRange, delinquent, disallowExpectedDisbursements, disbursedAmountPercentageForDownPayment, disbursementDetails, emiAmountVariations, enableAutoRepaymentForDownPayment, enableBuyDownFee, enableDownPayment, enableIncomeCapitalization, enableInstallmentLevelDelinquency, externalId, fixedLength, fixedPrincipalPercentagePerInstallment, fraud, id, inArrearsTolerance, interestCalculationPeriodType, interestRateFrequencyType, interestRatePerPeriod, interestRecognitionOnDisbursementDate, interestType, isFloatingInterestRate, lastClosedBusinessDate, loanOfficerId, loanOfficerName, loanProductDescription, loanProductId, loanProductName, loanPurposeId, loanPurposeName, loanScheduleProcessingType, loanScheduleType, loanTermVariations, loanType, netDisbursalAmount, numberOfRepayments, overpaidOnDate, principal, proposedPrincipal, repaymentEvery, repaymentFrequencyType, repaymentSchedule, status, summary, termFrequency, termPeriodFrequencyType, timeline, totalOverpaid, transactionProcessingStrategyCode, transactions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetLoansLoanIdResponse {\n");
    sb.append("    accountNo: ").append(toIndentedString(accountNo)).append("\n");
    sb.append("    amortizationType: ").append(toIndentedString(amortizationType)).append("\n");
    sb.append("    annualInterestRate: ").append(toIndentedString(annualInterestRate)).append("\n");
    sb.append("    approvedPrincipal: ").append(toIndentedString(approvedPrincipal)).append("\n");
    sb.append("    buyDownFeeCalculationType: ").append(toIndentedString(buyDownFeeCalculationType)).append("\n");
    sb.append("    buyDownFeeIncomeType: ").append(toIndentedString(buyDownFeeIncomeType)).append("\n");
    sb.append("    buyDownFeeStrategy: ").append(toIndentedString(buyDownFeeStrategy)).append("\n");
    sb.append("    capitalizedIncomeCalculationType: ").append(toIndentedString(capitalizedIncomeCalculationType)).append("\n");
    sb.append("    capitalizedIncomeStrategy: ").append(toIndentedString(capitalizedIncomeStrategy)).append("\n");
    sb.append("    capitalizedIncomeType: ").append(toIndentedString(capitalizedIncomeType)).append("\n");
    sb.append("    chargeOffBehaviour: ").append(toIndentedString(chargeOffBehaviour)).append("\n");
    sb.append("    chargedOff: ").append(toIndentedString(chargedOff)).append("\n");
    sb.append("    charges: ").append(toIndentedString(charges)).append("\n");
    sb.append("    clientExternalId: ").append(toIndentedString(clientExternalId)).append("\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    clientName: ").append(toIndentedString(clientName)).append("\n");
    sb.append("    clientOfficeId: ").append(toIndentedString(clientOfficeId)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    delinquencyRange: ").append(toIndentedString(delinquencyRange)).append("\n");
    sb.append("    delinquent: ").append(toIndentedString(delinquent)).append("\n");
    sb.append("    disallowExpectedDisbursements: ").append(toIndentedString(disallowExpectedDisbursements)).append("\n");
    sb.append("    disbursedAmountPercentageForDownPayment: ").append(toIndentedString(disbursedAmountPercentageForDownPayment)).append("\n");
    sb.append("    disbursementDetails: ").append(toIndentedString(disbursementDetails)).append("\n");
    sb.append("    emiAmountVariations: ").append(toIndentedString(emiAmountVariations)).append("\n");
    sb.append("    enableAutoRepaymentForDownPayment: ").append(toIndentedString(enableAutoRepaymentForDownPayment)).append("\n");
    sb.append("    enableBuyDownFee: ").append(toIndentedString(enableBuyDownFee)).append("\n");
    sb.append("    enableDownPayment: ").append(toIndentedString(enableDownPayment)).append("\n");
    sb.append("    enableIncomeCapitalization: ").append(toIndentedString(enableIncomeCapitalization)).append("\n");
    sb.append("    enableInstallmentLevelDelinquency: ").append(toIndentedString(enableInstallmentLevelDelinquency)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    fixedLength: ").append(toIndentedString(fixedLength)).append("\n");
    sb.append("    fixedPrincipalPercentagePerInstallment: ").append(toIndentedString(fixedPrincipalPercentagePerInstallment)).append("\n");
    sb.append("    fraud: ").append(toIndentedString(fraud)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    inArrearsTolerance: ").append(toIndentedString(inArrearsTolerance)).append("\n");
    sb.append("    interestCalculationPeriodType: ").append(toIndentedString(interestCalculationPeriodType)).append("\n");
    sb.append("    interestRateFrequencyType: ").append(toIndentedString(interestRateFrequencyType)).append("\n");
    sb.append("    interestRatePerPeriod: ").append(toIndentedString(interestRatePerPeriod)).append("\n");
    sb.append("    interestRecognitionOnDisbursementDate: ").append(toIndentedString(interestRecognitionOnDisbursementDate)).append("\n");
    sb.append("    interestType: ").append(toIndentedString(interestType)).append("\n");
    sb.append("    isFloatingInterestRate: ").append(toIndentedString(isFloatingInterestRate)).append("\n");
    sb.append("    lastClosedBusinessDate: ").append(toIndentedString(lastClosedBusinessDate)).append("\n");
    sb.append("    loanOfficerId: ").append(toIndentedString(loanOfficerId)).append("\n");
    sb.append("    loanOfficerName: ").append(toIndentedString(loanOfficerName)).append("\n");
    sb.append("    loanProductDescription: ").append(toIndentedString(loanProductDescription)).append("\n");
    sb.append("    loanProductId: ").append(toIndentedString(loanProductId)).append("\n");
    sb.append("    loanProductName: ").append(toIndentedString(loanProductName)).append("\n");
    sb.append("    loanPurposeId: ").append(toIndentedString(loanPurposeId)).append("\n");
    sb.append("    loanPurposeName: ").append(toIndentedString(loanPurposeName)).append("\n");
    sb.append("    loanScheduleProcessingType: ").append(toIndentedString(loanScheduleProcessingType)).append("\n");
    sb.append("    loanScheduleType: ").append(toIndentedString(loanScheduleType)).append("\n");
    sb.append("    loanTermVariations: ").append(toIndentedString(loanTermVariations)).append("\n");
    sb.append("    loanType: ").append(toIndentedString(loanType)).append("\n");
    sb.append("    netDisbursalAmount: ").append(toIndentedString(netDisbursalAmount)).append("\n");
    sb.append("    numberOfRepayments: ").append(toIndentedString(numberOfRepayments)).append("\n");
    sb.append("    overpaidOnDate: ").append(toIndentedString(overpaidOnDate)).append("\n");
    sb.append("    principal: ").append(toIndentedString(principal)).append("\n");
    sb.append("    proposedPrincipal: ").append(toIndentedString(proposedPrincipal)).append("\n");
    sb.append("    repaymentEvery: ").append(toIndentedString(repaymentEvery)).append("\n");
    sb.append("    repaymentFrequencyType: ").append(toIndentedString(repaymentFrequencyType)).append("\n");
    sb.append("    repaymentSchedule: ").append(toIndentedString(repaymentSchedule)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    summary: ").append(toIndentedString(summary)).append("\n");
    sb.append("    termFrequency: ").append(toIndentedString(termFrequency)).append("\n");
    sb.append("    termPeriodFrequencyType: ").append(toIndentedString(termPeriodFrequencyType)).append("\n");
    sb.append("    timeline: ").append(toIndentedString(timeline)).append("\n");
    sb.append("    totalOverpaid: ").append(toIndentedString(totalOverpaid)).append("\n");
    sb.append("    transactionProcessingStrategyCode: ").append(toIndentedString(transactionProcessingStrategyCode)).append("\n");
    sb.append("    transactions: ").append(toIndentedString(transactions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

