/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0-SNAPSHOT
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * FinancialActivityData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class FinancialActivityData {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Integer id;

  /**
   * Gets or Sets mappedGLAccountType
   */
  @JsonAdapter(MappedGLAccountTypeEnum.Adapter.class)
  public enum MappedGLAccountTypeEnum {
    ASSET("ASSET"),
    
    LIABILITY("LIABILITY"),
    
    EQUITY("EQUITY"),
    
    INCOME("INCOME"),
    
    EXPENSE("EXPENSE");

    private String value;

    MappedGLAccountTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static MappedGLAccountTypeEnum fromValue(String value) {
      for (MappedGLAccountTypeEnum b : MappedGLAccountTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<MappedGLAccountTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final MappedGLAccountTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public MappedGLAccountTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return MappedGLAccountTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_MAPPED_G_L_ACCOUNT_TYPE = "mappedGLAccountType";
  @SerializedName(SERIALIZED_NAME_MAPPED_G_L_ACCOUNT_TYPE)
  private MappedGLAccountTypeEnum mappedGLAccountType;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public FinancialActivityData() {
  }

  public FinancialActivityData id(Integer id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Integer getId() {
    return id;
  }


  public void setId(Integer id) {
    this.id = id;
  }

  public FinancialActivityData mappedGLAccountType(MappedGLAccountTypeEnum mappedGLAccountType) {
    
    this.mappedGLAccountType = mappedGLAccountType;
    return this;
  }

  /**
   * Get mappedGLAccountType
   * @return mappedGLAccountType
   */
  @javax.annotation.Nullable

  public MappedGLAccountTypeEnum getMappedGLAccountType() {
    return mappedGLAccountType;
  }


  public void setMappedGLAccountType(MappedGLAccountTypeEnum mappedGLAccountType) {
    this.mappedGLAccountType = mappedGLAccountType;
  }

  public FinancialActivityData name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @javax.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FinancialActivityData financialActivityData = (FinancialActivityData) o;
    return Objects.equals(this.id, financialActivityData.id) &&
        Objects.equals(this.mappedGLAccountType, financialActivityData.mappedGLAccountType) &&
        Objects.equals(this.name, financialActivityData.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, mappedGLAccountType, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FinancialActivityData {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    mappedGLAccountType: ").append(toIndentedString(mappedGLAccountType)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

