/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0-SNAPSHOT
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.AccountChargesRequest;

/**
 * AccountRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class AccountRequest {
  public static final String SERIALIZED_NAME_ALLOW_DIVIDEND_CALCULATION_FOR_INACTIVE_CLIENTS = "allowDividendCalculationForInactiveClients";
  @SerializedName(SERIALIZED_NAME_ALLOW_DIVIDEND_CALCULATION_FOR_INACTIVE_CLIENTS)
  private String allowDividendCalculationForInactiveClients;

  public static final String SERIALIZED_NAME_APPLICATION_DATE = "applicationDate";
  @SerializedName(SERIALIZED_NAME_APPLICATION_DATE)
  private String applicationDate;

  public static final String SERIALIZED_NAME_APPROVED_DATE = "approvedDate";
  @SerializedName(SERIALIZED_NAME_APPROVED_DATE)
  private String approvedDate;

  public static final String SERIALIZED_NAME_CHARGES = "charges";
  @SerializedName(SERIALIZED_NAME_CHARGES)
  private List<AccountChargesRequest> charges;

  public static final String SERIALIZED_NAME_CLIENT_ID = "clientId";
  @SerializedName(SERIALIZED_NAME_CLIENT_ID)
  private Long clientId;

  public static final String SERIALIZED_NAME_CURRENCY_CODE = "currencyCode";
  @SerializedName(SERIALIZED_NAME_CURRENCY_CODE)
  private String currencyCode;

  public static final String SERIALIZED_NAME_DATE_FORMAT = "dateFormat";
  @SerializedName(SERIALIZED_NAME_DATE_FORMAT)
  private String dateFormat;

  public static final String SERIALIZED_NAME_DIGITS_AFTER_DECIMAL = "digitsAfterDecimal";
  @SerializedName(SERIALIZED_NAME_DIGITS_AFTER_DECIMAL)
  private Integer digitsAfterDecimal;

  public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
  @SerializedName(SERIALIZED_NAME_EXTERNAL_ID)
  private String externalId;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_IN_MULTIPLES_OF = "inMultiplesOf";
  @SerializedName(SERIALIZED_NAME_IN_MULTIPLES_OF)
  private String inMultiplesOf;

  public static final String SERIALIZED_NAME_LOCALE = "locale";
  @SerializedName(SERIALIZED_NAME_LOCALE)
  private String locale;

  public static final String SERIALIZED_NAME_LOCKIN_PERIOD_FREQUENCY = "lockinPeriodFrequency";
  @SerializedName(SERIALIZED_NAME_LOCKIN_PERIOD_FREQUENCY)
  private Integer lockinPeriodFrequency;

  public static final String SERIALIZED_NAME_LOCKIN_PERIOD_FREQUENCY_TYPE = "lockinPeriodFrequencyType";
  @SerializedName(SERIALIZED_NAME_LOCKIN_PERIOD_FREQUENCY_TYPE)
  private String lockinPeriodFrequencyType;

  public static final String SERIALIZED_NAME_MINIMUM_ACTIVE_PERIOD = "minimumActivePeriod";
  @SerializedName(SERIALIZED_NAME_MINIMUM_ACTIVE_PERIOD)
  private Integer minimumActivePeriod;

  public static final String SERIALIZED_NAME_MINIMUM_ACTIVE_PERIOD_FREQUENCY_TYPE = "minimumActivePeriodFrequencyType";
  @SerializedName(SERIALIZED_NAME_MINIMUM_ACTIVE_PERIOD_FREQUENCY_TYPE)
  private String minimumActivePeriodFrequencyType;

  public static final String SERIALIZED_NAME_NUMBER_OF_SHARES = "numberOfShares";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_SHARES)
  private Long numberOfShares;

  public static final String SERIALIZED_NAME_PRODUCT_ID = "productId";
  @SerializedName(SERIALIZED_NAME_PRODUCT_ID)
  private Long productId;

  public static final String SERIALIZED_NAME_PURCHASED_DATE = "purchasedDate";
  @SerializedName(SERIALIZED_NAME_PURCHASED_DATE)
  private String purchasedDate;

  public static final String SERIALIZED_NAME_REQUESTED_SHARES = "requestedShares";
  @SerializedName(SERIALIZED_NAME_REQUESTED_SHARES)
  private Long requestedShares;

  public static final String SERIALIZED_NAME_SAVINGS_ACCOUNT_ID = "savingsAccountId";
  @SerializedName(SERIALIZED_NAME_SAVINGS_ACCOUNT_ID)
  private Long savingsAccountId;

  public static final String SERIALIZED_NAME_SUBMITTED_DATE = "submittedDate";
  @SerializedName(SERIALIZED_NAME_SUBMITTED_DATE)
  private String submittedDate;

  public static final String SERIALIZED_NAME_UNIT_PRICE = "unitPrice";
  @SerializedName(SERIALIZED_NAME_UNIT_PRICE)
  private BigDecimal unitPrice;

  public AccountRequest() {
  }

  public AccountRequest allowDividendCalculationForInactiveClients(String allowDividendCalculationForInactiveClients) {
    
    this.allowDividendCalculationForInactiveClients = allowDividendCalculationForInactiveClients;
    return this;
  }

  /**
   * Get allowDividendCalculationForInactiveClients
   * @return allowDividendCalculationForInactiveClients
   */
  @javax.annotation.Nullable

  public String getAllowDividendCalculationForInactiveClients() {
    return allowDividendCalculationForInactiveClients;
  }


  public void setAllowDividendCalculationForInactiveClients(String allowDividendCalculationForInactiveClients) {
    this.allowDividendCalculationForInactiveClients = allowDividendCalculationForInactiveClients;
  }

  public AccountRequest applicationDate(String applicationDate) {
    
    this.applicationDate = applicationDate;
    return this;
  }

  /**
   * Get applicationDate
   * @return applicationDate
   */
  @javax.annotation.Nullable

  public String getApplicationDate() {
    return applicationDate;
  }


  public void setApplicationDate(String applicationDate) {
    this.applicationDate = applicationDate;
  }

  public AccountRequest approvedDate(String approvedDate) {
    
    this.approvedDate = approvedDate;
    return this;
  }

  /**
   * Get approvedDate
   * @return approvedDate
   */
  @javax.annotation.Nullable

  public String getApprovedDate() {
    return approvedDate;
  }


  public void setApprovedDate(String approvedDate) {
    this.approvedDate = approvedDate;
  }

  public AccountRequest charges(List<AccountChargesRequest> charges) {
    
    this.charges = charges;
    return this;
  }

  public AccountRequest addChargesItem(AccountChargesRequest chargesItem) {
    if (this.charges == null) {
      this.charges = new ArrayList<>();
    }
    this.charges.add(chargesItem);
    return this;
  }

  /**
   * Get charges
   * @return charges
   */
  @javax.annotation.Nullable

  public List<AccountChargesRequest> getCharges() {
    return charges;
  }


  public void setCharges(List<AccountChargesRequest> charges) {
    this.charges = charges;
  }

  public AccountRequest clientId(Long clientId) {
    
    this.clientId = clientId;
    return this;
  }

  /**
   * Get clientId
   * @return clientId
   */
  @javax.annotation.Nullable

  public Long getClientId() {
    return clientId;
  }


  public void setClientId(Long clientId) {
    this.clientId = clientId;
  }

  public AccountRequest currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Get currencyCode
   * @return currencyCode
   */
  @javax.annotation.Nullable

  public String getCurrencyCode() {
    return currencyCode;
  }


  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }

  public AccountRequest dateFormat(String dateFormat) {
    
    this.dateFormat = dateFormat;
    return this;
  }

  /**
   * Get dateFormat
   * @return dateFormat
   */
  @javax.annotation.Nullable

  public String getDateFormat() {
    return dateFormat;
  }


  public void setDateFormat(String dateFormat) {
    this.dateFormat = dateFormat;
  }

  public AccountRequest digitsAfterDecimal(Integer digitsAfterDecimal) {
    
    this.digitsAfterDecimal = digitsAfterDecimal;
    return this;
  }

  /**
   * Get digitsAfterDecimal
   * @return digitsAfterDecimal
   */
  @javax.annotation.Nullable

  public Integer getDigitsAfterDecimal() {
    return digitsAfterDecimal;
  }


  public void setDigitsAfterDecimal(Integer digitsAfterDecimal) {
    this.digitsAfterDecimal = digitsAfterDecimal;
  }

  public AccountRequest externalId(String externalId) {
    
    this.externalId = externalId;
    return this;
  }

  /**
   * Get externalId
   * @return externalId
   */
  @javax.annotation.Nullable

  public String getExternalId() {
    return externalId;
  }


  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public AccountRequest id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public AccountRequest inMultiplesOf(String inMultiplesOf) {
    
    this.inMultiplesOf = inMultiplesOf;
    return this;
  }

  /**
   * Get inMultiplesOf
   * @return inMultiplesOf
   */
  @javax.annotation.Nullable

  public String getInMultiplesOf() {
    return inMultiplesOf;
  }


  public void setInMultiplesOf(String inMultiplesOf) {
    this.inMultiplesOf = inMultiplesOf;
  }

  public AccountRequest locale(String locale) {
    
    this.locale = locale;
    return this;
  }

  /**
   * Get locale
   * @return locale
   */
  @javax.annotation.Nullable

  public String getLocale() {
    return locale;
  }


  public void setLocale(String locale) {
    this.locale = locale;
  }

  public AccountRequest lockinPeriodFrequency(Integer lockinPeriodFrequency) {
    
    this.lockinPeriodFrequency = lockinPeriodFrequency;
    return this;
  }

  /**
   * Get lockinPeriodFrequency
   * @return lockinPeriodFrequency
   */
  @javax.annotation.Nullable

  public Integer getLockinPeriodFrequency() {
    return lockinPeriodFrequency;
  }


  public void setLockinPeriodFrequency(Integer lockinPeriodFrequency) {
    this.lockinPeriodFrequency = lockinPeriodFrequency;
  }

  public AccountRequest lockinPeriodFrequencyType(String lockinPeriodFrequencyType) {
    
    this.lockinPeriodFrequencyType = lockinPeriodFrequencyType;
    return this;
  }

  /**
   * Get lockinPeriodFrequencyType
   * @return lockinPeriodFrequencyType
   */
  @javax.annotation.Nullable

  public String getLockinPeriodFrequencyType() {
    return lockinPeriodFrequencyType;
  }


  public void setLockinPeriodFrequencyType(String lockinPeriodFrequencyType) {
    this.lockinPeriodFrequencyType = lockinPeriodFrequencyType;
  }

  public AccountRequest minimumActivePeriod(Integer minimumActivePeriod) {
    
    this.minimumActivePeriod = minimumActivePeriod;
    return this;
  }

  /**
   * Get minimumActivePeriod
   * @return minimumActivePeriod
   */
  @javax.annotation.Nullable

  public Integer getMinimumActivePeriod() {
    return minimumActivePeriod;
  }


  public void setMinimumActivePeriod(Integer minimumActivePeriod) {
    this.minimumActivePeriod = minimumActivePeriod;
  }

  public AccountRequest minimumActivePeriodFrequencyType(String minimumActivePeriodFrequencyType) {
    
    this.minimumActivePeriodFrequencyType = minimumActivePeriodFrequencyType;
    return this;
  }

  /**
   * Get minimumActivePeriodFrequencyType
   * @return minimumActivePeriodFrequencyType
   */
  @javax.annotation.Nullable

  public String getMinimumActivePeriodFrequencyType() {
    return minimumActivePeriodFrequencyType;
  }


  public void setMinimumActivePeriodFrequencyType(String minimumActivePeriodFrequencyType) {
    this.minimumActivePeriodFrequencyType = minimumActivePeriodFrequencyType;
  }

  public AccountRequest numberOfShares(Long numberOfShares) {
    
    this.numberOfShares = numberOfShares;
    return this;
  }

  /**
   * Get numberOfShares
   * @return numberOfShares
   */
  @javax.annotation.Nullable

  public Long getNumberOfShares() {
    return numberOfShares;
  }


  public void setNumberOfShares(Long numberOfShares) {
    this.numberOfShares = numberOfShares;
  }

  public AccountRequest productId(Long productId) {
    
    this.productId = productId;
    return this;
  }

  /**
   * Get productId
   * @return productId
   */
  @javax.annotation.Nullable

  public Long getProductId() {
    return productId;
  }


  public void setProductId(Long productId) {
    this.productId = productId;
  }

  public AccountRequest purchasedDate(String purchasedDate) {
    
    this.purchasedDate = purchasedDate;
    return this;
  }

  /**
   * Get purchasedDate
   * @return purchasedDate
   */
  @javax.annotation.Nullable

  public String getPurchasedDate() {
    return purchasedDate;
  }


  public void setPurchasedDate(String purchasedDate) {
    this.purchasedDate = purchasedDate;
  }

  public AccountRequest requestedShares(Long requestedShares) {
    
    this.requestedShares = requestedShares;
    return this;
  }

  /**
   * Get requestedShares
   * @return requestedShares
   */
  @javax.annotation.Nullable

  public Long getRequestedShares() {
    return requestedShares;
  }


  public void setRequestedShares(Long requestedShares) {
    this.requestedShares = requestedShares;
  }

  public AccountRequest savingsAccountId(Long savingsAccountId) {
    
    this.savingsAccountId = savingsAccountId;
    return this;
  }

  /**
   * Get savingsAccountId
   * @return savingsAccountId
   */
  @javax.annotation.Nullable

  public Long getSavingsAccountId() {
    return savingsAccountId;
  }


  public void setSavingsAccountId(Long savingsAccountId) {
    this.savingsAccountId = savingsAccountId;
  }

  public AccountRequest submittedDate(String submittedDate) {
    
    this.submittedDate = submittedDate;
    return this;
  }

  /**
   * Get submittedDate
   * @return submittedDate
   */
  @javax.annotation.Nullable

  public String getSubmittedDate() {
    return submittedDate;
  }


  public void setSubmittedDate(String submittedDate) {
    this.submittedDate = submittedDate;
  }

  public AccountRequest unitPrice(BigDecimal unitPrice) {
    
    this.unitPrice = unitPrice;
    return this;
  }

  /**
   * Get unitPrice
   * @return unitPrice
   */
  @javax.annotation.Nullable

  public BigDecimal getUnitPrice() {
    return unitPrice;
  }


  public void setUnitPrice(BigDecimal unitPrice) {
    this.unitPrice = unitPrice;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountRequest accountRequest = (AccountRequest) o;
    return Objects.equals(this.allowDividendCalculationForInactiveClients, accountRequest.allowDividendCalculationForInactiveClients) &&
        Objects.equals(this.applicationDate, accountRequest.applicationDate) &&
        Objects.equals(this.approvedDate, accountRequest.approvedDate) &&
        Objects.equals(this.charges, accountRequest.charges) &&
        Objects.equals(this.clientId, accountRequest.clientId) &&
        Objects.equals(this.currencyCode, accountRequest.currencyCode) &&
        Objects.equals(this.dateFormat, accountRequest.dateFormat) &&
        Objects.equals(this.digitsAfterDecimal, accountRequest.digitsAfterDecimal) &&
        Objects.equals(this.externalId, accountRequest.externalId) &&
        Objects.equals(this.id, accountRequest.id) &&
        Objects.equals(this.inMultiplesOf, accountRequest.inMultiplesOf) &&
        Objects.equals(this.locale, accountRequest.locale) &&
        Objects.equals(this.lockinPeriodFrequency, accountRequest.lockinPeriodFrequency) &&
        Objects.equals(this.lockinPeriodFrequencyType, accountRequest.lockinPeriodFrequencyType) &&
        Objects.equals(this.minimumActivePeriod, accountRequest.minimumActivePeriod) &&
        Objects.equals(this.minimumActivePeriodFrequencyType, accountRequest.minimumActivePeriodFrequencyType) &&
        Objects.equals(this.numberOfShares, accountRequest.numberOfShares) &&
        Objects.equals(this.productId, accountRequest.productId) &&
        Objects.equals(this.purchasedDate, accountRequest.purchasedDate) &&
        Objects.equals(this.requestedShares, accountRequest.requestedShares) &&
        Objects.equals(this.savingsAccountId, accountRequest.savingsAccountId) &&
        Objects.equals(this.submittedDate, accountRequest.submittedDate) &&
        Objects.equals(this.unitPrice, accountRequest.unitPrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(allowDividendCalculationForInactiveClients, applicationDate, approvedDate, charges, clientId, currencyCode, dateFormat, digitsAfterDecimal, externalId, id, inMultiplesOf, locale, lockinPeriodFrequency, lockinPeriodFrequencyType, minimumActivePeriod, minimumActivePeriodFrequencyType, numberOfShares, productId, purchasedDate, requestedShares, savingsAccountId, submittedDate, unitPrice);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountRequest {\n");
    sb.append("    allowDividendCalculationForInactiveClients: ").append(toIndentedString(allowDividendCalculationForInactiveClients)).append("\n");
    sb.append("    applicationDate: ").append(toIndentedString(applicationDate)).append("\n");
    sb.append("    approvedDate: ").append(toIndentedString(approvedDate)).append("\n");
    sb.append("    charges: ").append(toIndentedString(charges)).append("\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    dateFormat: ").append(toIndentedString(dateFormat)).append("\n");
    sb.append("    digitsAfterDecimal: ").append(toIndentedString(digitsAfterDecimal)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    inMultiplesOf: ").append(toIndentedString(inMultiplesOf)).append("\n");
    sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
    sb.append("    lockinPeriodFrequency: ").append(toIndentedString(lockinPeriodFrequency)).append("\n");
    sb.append("    lockinPeriodFrequencyType: ").append(toIndentedString(lockinPeriodFrequencyType)).append("\n");
    sb.append("    minimumActivePeriod: ").append(toIndentedString(minimumActivePeriod)).append("\n");
    sb.append("    minimumActivePeriodFrequencyType: ").append(toIndentedString(minimumActivePeriodFrequencyType)).append("\n");
    sb.append("    numberOfShares: ").append(toIndentedString(numberOfShares)).append("\n");
    sb.append("    productId: ").append(toIndentedString(productId)).append("\n");
    sb.append("    purchasedDate: ").append(toIndentedString(purchasedDate)).append("\n");
    sb.append("    requestedShares: ").append(toIndentedString(requestedShares)).append("\n");
    sb.append("    savingsAccountId: ").append(toIndentedString(savingsAccountId)).append("\n");
    sb.append("    submittedDate: ").append(toIndentedString(submittedDate)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

