/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareproducts.data;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.accounting.common.AccountingRuleType;
import org.apache.fineract.accounting.glaccount.data.GLAccountData;
import org.apache.fineract.accounting.producttoaccountmapping.data.ChargeToGLAccountMapper;
import org.apache.fineract.accounting.producttoaccountmapping.data.PaymentTypeToGLAccountMapper;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.portfolio.charge.data.ChargeData;
import org.apache.fineract.portfolio.products.data.ProductData;
import org.apache.fineract.portfolio.shareproducts.data.ShareProductMarketPriceData;

public final class ShareProductData
implements ProductData {
    private final Long id;
    private final String name;
    private final String shortName;
    private final String description;
    private final String externalId;
    private final CurrencyData currency;
    private final Long totalShares;
    private final Long totalSharesIssued;
    private final BigDecimal unitPrice;
    private final BigDecimal shareCapital;
    private final Long minimumShares;
    private final Long nominalShares;
    private final Long maximumShares;
    private final Collection<ShareProductMarketPriceData> marketPrice;
    private final Collection<ChargeData> charges;
    private final Boolean allowDividendCalculationForInactiveClients;
    private final Integer lockinPeriod;
    private final EnumOptionData lockPeriodTypeEnum;
    private final Integer minimumActivePeriod;
    private final EnumOptionData minimumActivePeriodForDividendsTypeEnum;
    private final EnumOptionData accountingRule;
    private final Map<String, Object> accountingMappings;
    private final Collection<PaymentTypeToGLAccountMapper> paymentChannelToFundSourceMappings;
    private final Collection<ChargeToGLAccountMapper> feeToGLAccountMappings;
    private final Collection<CurrencyData> currencyOptions;
    private final Collection<ChargeData> chargeOptions;
    final Collection<EnumOptionData> minimumActivePeriodFrequencyTypeOptions;
    final Collection<EnumOptionData> lockinPeriodFrequencyTypeOptions;
    private final Map<String, List<GLAccountData>> accountingMappingOptions;

    private ShareProductData(Long id, String name, String shortName, String description, String externalId, CurrencyData currency, Long totalShares, Long totalSharesIssued, BigDecimal unitPrice, BigDecimal shareCapital, Long minimumShares, Long nominaltShares, Long maximumShares, Collection<ShareProductMarketPriceData> marketPrice, Collection<ChargeData> charges, Boolean allowDividendCalculationForInactiveClients, Integer lockinPeriod, EnumOptionData lockPeriodEnum, Integer minimumActivePeriod, EnumOptionData minimumActivePeriodForDividendsTypeEnum, EnumOptionData accountingRule, Map<String, Object> accountingMappings, Collection<PaymentTypeToGLAccountMapper> paymentChannelToFundSourceMappings, Collection<ChargeToGLAccountMapper> feeToGLAccountMappings, Collection<CurrencyData> currencyOptions, Collection<ChargeData> chargeOptions, Collection<EnumOptionData> minimumActivePeriodFrequencyTypeOptions, Collection<EnumOptionData> lockinPeriodFrequencyTypeOptions, Map<String, List<GLAccountData>> accountingMappingOptions) {
        this.id = id;
        this.name = name;
        this.shortName = shortName;
        this.description = description;
        this.externalId = externalId;
        this.currency = currency;
        this.totalShares = totalShares;
        this.totalSharesIssued = totalSharesIssued;
        this.unitPrice = unitPrice;
        this.shareCapital = shareCapital;
        this.minimumShares = minimumShares;
        this.nominalShares = nominaltShares;
        this.maximumShares = maximumShares;
        this.marketPrice = marketPrice;
        this.charges = charges;
        this.allowDividendCalculationForInactiveClients = allowDividendCalculationForInactiveClients;
        this.lockinPeriod = lockinPeriod;
        this.lockPeriodTypeEnum = lockPeriodEnum;
        this.minimumActivePeriod = minimumActivePeriod;
        this.minimumActivePeriodForDividendsTypeEnum = minimumActivePeriodForDividendsTypeEnum;
        this.accountingMappings = accountingMappings;
        this.accountingRule = accountingRule;
        this.paymentChannelToFundSourceMappings = paymentChannelToFundSourceMappings;
        this.feeToGLAccountMappings = feeToGLAccountMappings;
        this.currencyOptions = currencyOptions;
        this.chargeOptions = chargeOptions;
        this.minimumActivePeriodFrequencyTypeOptions = minimumActivePeriodFrequencyTypeOptions;
        this.lockinPeriodFrequencyTypeOptions = lockinPeriodFrequencyTypeOptions;
        this.accountingMappingOptions = accountingMappingOptions;
    }

    public static ShareProductData data(Long id, String name, String shortName, String description, String externalId, CurrencyData currency, Long totalShares, Long totalSharesIssued, BigDecimal unitPrice, BigDecimal shareCapital, Long minimumShares, Long nominaltShares, Long maximumShares, Collection<ShareProductMarketPriceData> marketPrice, Collection<ChargeData> charges, Boolean allowDividendCalculationForInactiveClients, Integer lockinPeriod, EnumOptionData lockPeriodTypeEnum, Integer minimumActivePeriod, EnumOptionData minimumActivePeriodForDividendsEnum, EnumOptionData accountingRule) {
        Map accountingMappings = null;
        Collection paymentChannelToFundSourceMappings = null;
        Map accountingMappingOptions = null;
        Collection feeToGLAccountMappings = null;
        Collection currencyOptions = null;
        Collection chargeOptions = null;
        Collection minimumActivePeriodFrequencyTypeOptions = null;
        Collection lockinPeriodFrequencyTypeOptions = null;
        return new ShareProductData(id, name, shortName, description, externalId, currency, totalShares, totalSharesIssued, unitPrice, shareCapital, minimumShares, nominaltShares, maximumShares, marketPrice, charges, allowDividendCalculationForInactiveClients, lockinPeriod, lockPeriodTypeEnum, minimumActivePeriod, minimumActivePeriodForDividendsEnum, accountingRule, accountingMappings, paymentChannelToFundSourceMappings, feeToGLAccountMappings, currencyOptions, chargeOptions, minimumActivePeriodFrequencyTypeOptions, lockinPeriodFrequencyTypeOptions, accountingMappingOptions);
    }

    private ShareProductData(Collection<CurrencyData> currencyOptions, Collection<ChargeData> chargeOptions, Collection<EnumOptionData> minimumActivePeriodFrequencyTypeOptions, Collection<EnumOptionData> lockinPeriodFrequencyTypeOptions, Map<String, List<GLAccountData>> accountingMappingOptions) {
        this.id = null;
        this.name = null;
        this.shortName = null;
        this.description = null;
        this.externalId = null;
        this.currency = null;
        this.totalShares = null;
        this.totalSharesIssued = null;
        this.unitPrice = null;
        this.shareCapital = null;
        this.minimumShares = null;
        this.nominalShares = null;
        this.maximumShares = null;
        this.marketPrice = null;
        this.charges = null;
        this.allowDividendCalculationForInactiveClients = null;
        this.lockPeriodTypeEnum = null;
        this.minimumActivePeriodForDividendsTypeEnum = null;
        this.accountingRule = null;
        this.accountingMappings = null;
        this.paymentChannelToFundSourceMappings = null;
        this.feeToGLAccountMappings = null;
        this.currencyOptions = currencyOptions;
        this.chargeOptions = chargeOptions;
        this.minimumActivePeriodFrequencyTypeOptions = minimumActivePeriodFrequencyTypeOptions;
        this.lockinPeriodFrequencyTypeOptions = lockinPeriodFrequencyTypeOptions;
        this.lockinPeriod = null;
        this.minimumActivePeriod = null;
        this.accountingMappingOptions = accountingMappingOptions;
    }

    public static ShareProductData template(Collection<CurrencyData> currencyOptions, Collection<ChargeData> chargeOptions, Collection<EnumOptionData> minimumActivePeriodFrequencyTypeOptions, Collection<EnumOptionData> lockinPeriodFrequencyTypeOptions, Map<String, List<GLAccountData>> accountingMappingOptions) {
        return new ShareProductData(currencyOptions, chargeOptions, minimumActivePeriodFrequencyTypeOptions, lockinPeriodFrequencyTypeOptions, accountingMappingOptions);
    }

    public static ShareProductData template(ShareProductData data, Collection<CurrencyData> currencyOptions, Collection<ChargeData> chargeOptions, Collection<EnumOptionData> minimumActivePeriodFrequencyTypeOptions, Collection<EnumOptionData> lockinPeriodFrequencyTypeOptions, Map<String, List<GLAccountData>> accountingMappingOptions) {
        return new ShareProductData(data.id, data.name, data.shortName, data.description, data.externalId, data.currency, data.totalShares, data.totalSharesIssued, data.unitPrice, data.shareCapital, data.minimumShares, data.nominalShares, data.maximumShares, data.marketPrice, data.charges, data.allowDividendCalculationForInactiveClients, data.lockinPeriod, data.lockPeriodTypeEnum, data.minimumActivePeriod, data.minimumActivePeriodForDividendsTypeEnum, data.accountingRule, data.accountingMappings, data.paymentChannelToFundSourceMappings, data.feeToGLAccountMappings, currencyOptions, chargeOptions, minimumActivePeriodFrequencyTypeOptions, lockinPeriodFrequencyTypeOptions, accountingMappingOptions);
    }

    public static ShareProductData withAccountingDetails(ShareProductData data, Map<String, Object> accountingMappings, Collection<PaymentTypeToGLAccountMapper> paymentChannelToFundSourceMappings, Collection<ChargeToGLAccountMapper> feeToGLAccountMappings) {
        return new ShareProductData(data.id, data.name, data.shortName, data.description, data.externalId, data.currency, data.totalShares, data.totalSharesIssued, data.unitPrice, data.shareCapital, data.minimumShares, data.nominalShares, data.maximumShares, data.marketPrice, data.charges, data.allowDividendCalculationForInactiveClients, data.lockinPeriod, data.lockPeriodTypeEnum, data.minimumActivePeriod, data.minimumActivePeriodForDividendsTypeEnum, data.accountingRule, accountingMappings, paymentChannelToFundSourceMappings, feeToGLAccountMappings, data.currencyOptions, data.chargeOptions, data.minimumActivePeriodFrequencyTypeOptions, data.lockinPeriodFrequencyTypeOptions, data.accountingMappingOptions);
    }

    private ShareProductData(Long id, String name, String shortName, Long totalShares) {
        this.id = id;
        this.name = name;
        this.shortName = shortName;
        this.description = null;
        this.externalId = null;
        this.currency = null;
        this.totalShares = totalShares;
        this.totalSharesIssued = null;
        this.unitPrice = null;
        this.shareCapital = null;
        this.minimumShares = null;
        this.nominalShares = null;
        this.maximumShares = null;
        this.marketPrice = null;
        this.charges = null;
        this.allowDividendCalculationForInactiveClients = null;
        this.lockPeriodTypeEnum = null;
        this.minimumActivePeriodForDividendsTypeEnum = null;
        this.currencyOptions = null;
        this.chargeOptions = null;
        this.minimumActivePeriodFrequencyTypeOptions = null;
        this.lockinPeriodFrequencyTypeOptions = null;
        this.lockinPeriod = null;
        this.minimumActivePeriod = null;
        this.accountingRule = null;
        this.accountingMappings = null;
        this.paymentChannelToFundSourceMappings = null;
        this.feeToGLAccountMappings = null;
        this.accountingMappingOptions = null;
    }

    public static ShareProductData generic(Long id, String name, String shortName, Long totalShares) {
        return new ShareProductData(id, name, shortName, totalShares);
    }

    public static ShareProductData lookup(Long id, String name) {
        String shortName = null;
        Long totalShares = null;
        return new ShareProductData(id, name, shortName, totalShares);
    }

    public boolean hasAccountingEnabled() {
        return (Long)this.accountingRule.getId() > (long)AccountingRuleType.NONE.getValue().intValue();
    }

    public int accountingRuleTypeId() {
        return ((Long)this.accountingRule.getId()).intValue();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getShortName() {
        return this.shortName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getExternalId() {
        return this.externalId;
    }

    @Generated
    public CurrencyData getCurrency() {
        return this.currency;
    }

    @Generated
    public Long getTotalShares() {
        return this.totalShares;
    }

    @Generated
    public Long getTotalSharesIssued() {
        return this.totalSharesIssued;
    }

    @Generated
    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    @Generated
    public BigDecimal getShareCapital() {
        return this.shareCapital;
    }

    @Generated
    public Long getMinimumShares() {
        return this.minimumShares;
    }

    @Generated
    public Long getNominalShares() {
        return this.nominalShares;
    }

    @Generated
    public Long getMaximumShares() {
        return this.maximumShares;
    }

    @Generated
    public Collection<ShareProductMarketPriceData> getMarketPrice() {
        return this.marketPrice;
    }

    @Generated
    public Collection<ChargeData> getCharges() {
        return this.charges;
    }

    @Generated
    public Boolean getAllowDividendCalculationForInactiveClients() {
        return this.allowDividendCalculationForInactiveClients;
    }

    @Generated
    public Integer getLockinPeriod() {
        return this.lockinPeriod;
    }

    @Generated
    public EnumOptionData getLockPeriodTypeEnum() {
        return this.lockPeriodTypeEnum;
    }

    @Generated
    public Integer getMinimumActivePeriod() {
        return this.minimumActivePeriod;
    }

    @Generated
    public EnumOptionData getMinimumActivePeriodForDividendsTypeEnum() {
        return this.minimumActivePeriodForDividendsTypeEnum;
    }

    @Generated
    public EnumOptionData getAccountingRule() {
        return this.accountingRule;
    }

    @Generated
    public Map<String, Object> getAccountingMappings() {
        return this.accountingMappings;
    }

    @Generated
    public Collection<PaymentTypeToGLAccountMapper> getPaymentChannelToFundSourceMappings() {
        return this.paymentChannelToFundSourceMappings;
    }

    @Generated
    public Collection<ChargeToGLAccountMapper> getFeeToGLAccountMappings() {
        return this.feeToGLAccountMappings;
    }

    @Generated
    public Collection<CurrencyData> getCurrencyOptions() {
        return this.currencyOptions;
    }

    @Generated
    public Collection<ChargeData> getChargeOptions() {
        return this.chargeOptions;
    }

    @Generated
    public Collection<EnumOptionData> getMinimumActivePeriodFrequencyTypeOptions() {
        return this.minimumActivePeriodFrequencyTypeOptions;
    }

    @Generated
    public Collection<EnumOptionData> getLockinPeriodFrequencyTypeOptions() {
        return this.lockinPeriodFrequencyTypeOptions;
    }

    @Generated
    public Map<String, List<GLAccountData>> getAccountingMappingOptions() {
        return this.accountingMappingOptions;
    }
}

