/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.StatusEnum;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksWritePlatformService;
import org.apache.fineract.organisation.holiday.domain.Holiday;
import org.apache.fineract.organisation.holiday.service.HolidayUtil;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrency;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrencyRepository;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.exception.CurrencyNotFoundException;
import org.apache.fineract.organisation.workingdays.domain.WorkingDays;
import org.apache.fineract.organisation.workingdays.service.WorkingDaysUtil;
import org.apache.fineract.portfolio.calendar.domain.Calendar;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstance;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstanceRepository;
import org.apache.fineract.portfolio.calendar.exception.NotValidRecurringDateException;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.exception.ClientNotActiveException;
import org.apache.fineract.portfolio.collateralmanagement.exception.LoanCollateralAmountNotSufficientException;
import org.apache.fineract.portfolio.common.service.Validator;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.exception.GroupNotActiveException;
import org.apache.fineract.portfolio.loanaccount.data.HolidayDetailDTO;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCollateralManagement;
import org.apache.fineract.portfolio.loanaccount.domain.LoanDisbursementDetails;
import org.apache.fineract.portfolio.loanaccount.domain.LoanEvent;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.exception.DateMismatchException;
import org.apache.fineract.portfolio.loanaccount.exception.InvalidLoanStateTransitionException;
import org.apache.fineract.portfolio.loanaccount.exception.InvalidLoanTransactionTypeException;
import org.apache.fineract.portfolio.loanaccount.exception.InvalidRefundDateException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanApplicationDateException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanChargeRefundException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanDisbursalException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanNotFoundException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanRepaymentScheduleNotFoundException;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleType;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanApplicationValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanDisbursementValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanDownPaymentTransactionValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanTransactionValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanTransactionValidatorImpl;
import org.apache.fineract.portfolio.loanaccount.service.LoanUtilService;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="loanTransactionValidator")
public final class LoanTransactionValidatorImpl
implements LoanTransactionValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private final LoanApplicationValidator fromApiJsonDeserializer;
    private final LoanRepository loanRepository;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final ApplicationCurrencyRepository applicationCurrencyRepository;
    private final LoanUtilService loanUtilService;
    private final EntityDatatableChecksWritePlatformService entityDatatableChecksWritePlatformService;
    private final CalendarInstanceRepository calendarInstanceRepository;
    private final LoanDownPaymentTransactionValidator loanDownPaymentTransactionValidator;
    private final LoanDisbursementValidator loanDisbursementValidator;

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    public void validateDisbursement(JsonCommand command, boolean isAccountTransfer, Long loanId) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)LoanTransactionValidatorImpl.getDisbursementParameters((boolean)isAccountTransfer));
        Validator.validateOrThrow((String)"loan.disbursement", baseDataValidator -> {
            LocalDate submittedOnDate;
            HolidayDetailDTO holidayDetailDTO;
            BigDecimal totalCollateral;
            Set loanCollateralManagements;
            boolean isMultiDisburseLoanAndAllTranchesDisbursed;
            JsonElement element = this.fromApiJsonHelper.parse(json);
            LocalDate actualDisbursementDate = this.fromApiJsonHelper.extractLocalDateNamed("actualDisbursementDate", element);
            baseDataValidator.reset().parameter("actualDisbursementDate").value((Object)actualDisbursementDate).notNull();
            String note = this.fromApiJsonHelper.extractStringNamed("note", element);
            baseDataValidator.reset().parameter("note").value((Object)note).notExceedingLengthOf(Integer.valueOf(1000));
            BigDecimal principal = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("transactionAmount", element);
            baseDataValidator.reset().parameter("transactionAmount").value((Object)principal).ignoreIfNull().positiveAmount();
            BigDecimal netDisbursalAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("netDisbursalAmount", element);
            baseDataValidator.reset().parameter("netDisbursalAmount").value((Object)netDisbursalAmount).ignoreIfNull().positiveAmount();
            BigDecimal emiAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("fixedEmiAmount", element);
            baseDataValidator.reset().parameter("fixedEmiAmount").value((Object)emiAmount).ignoreIfNull().positiveAmount().notGreaterThanMax(principal);
            this.validatePaymentDetails(baseDataValidator, element);
            if (command.parameterExists("postDatedChecks")) {
                this.validateDisbursementWithPostDatedChecks(command.json(), loanId);
            }
            Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
            this.validateLoanClientIsActive(loan);
            this.validateLoanGroupIsActive(loan);
            BigDecimal disbursedAmount = loan.getDisbursedAmount();
            this.loanDisbursementValidator.compareDisbursedToApprovedOrProposedPrincipal(loan, principal, disbursedAmount);
            if (loan.isChargedOff()) {
                throw new GeneralPlatformDomainRuleException("error.msg.loan.disbursal.not.allowed.on.charged.off", "Loan: " + String.valueOf(loan.getId()) + " disbursement is not allowed on charged-off loan.", new Object[0]);
            }
            boolean isSingleDisburseLoan = !loan.getLoanProduct().isMultiDisburseLoan();
            boolean isSingleDisburseNotApprovedOrDisbursedAlready = isSingleDisburseLoan && (!loan.isApproved() || !loan.isNotDisbursed());
            boolean bl = isMultiDisburseLoanAndAllTranchesDisbursed = loan.getLoanProduct().isMultiDisburseLoan() && !loan.isAllTranchesNotDisbursed();
            if (isSingleDisburseNotApprovedOrDisbursedAlready || isMultiDisburseLoanAndAllTranchesDisbursed) {
                String defaultUserMessage = "Loan Disbursal is not allowed. Loan Account is not in approved and not disbursed state.";
                ApiParameterError error = ApiParameterError.generalError((String)"error.msg.loan.disbursal.account.is.not.approve.not.disbursed.state", (String)"Loan Disbursal is not allowed. Loan Account is not in approved and not disbursed state.", (Object[])new Object[0]);
                baseDataValidator.getDataValidationErrors().add(error);
            }
            if ((loanCollateralManagements = loan.getLoanCollateralManagements()) != null && !loanCollateralManagements.isEmpty() && loan.getLoanType().isIndividualAccount() && disbursedAmount.compareTo(totalCollateral = LoanTransactionValidatorImpl.collectTotalCollateral((Set)loanCollateralManagements)) > 0) {
                throw new LoanCollateralAmountNotSufficientException(disbursedAmount);
            }
            LoanProduct loanProduct = loan.loanProduct();
            if (loanProduct.isSyncExpectedWithDisbursementDate() && !loan.getExpectedDisbursedOnLocalDate().equals(actualDisbursementDate)) {
                throw new DateMismatchException(actualDisbursementDate, loan.getExpectedDisbursedOnLocalDate());
            }
            this.entityDatatableChecksWritePlatformService.runTheCheckForProduct((Long)loan.getId(), EntityTables.LOAN.getName(), StatusEnum.DISBURSE.getValue(), EntityTables.LOAN.getForeignKeyColumnNameOnDatatable(), loan.productId().longValue());
            ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, null);
            CalendarInstance calendarInstance = this.calendarInstanceRepository.findCalendarInstanceByEntityId((Long)loan.getId(), CalendarEntityType.LOANS.getValue());
            if (loan.isSyncDisbursementWithMeeting()) {
                this.validateDisbursementDateWithMeetingDate(actualDisbursementDate, calendarInstance, Boolean.valueOf(scheduleGeneratorDTO.isSkipRepaymentOnFirstDayofMonth()), scheduleGeneratorDTO.getNumberOfdays());
            }
            if (!(holidayDetailDTO = scheduleGeneratorDTO.getHolidayDetailDTO()).isAllowTransactionsOnNonWorkingDay() && !WorkingDaysUtil.isWorkingDay((WorkingDays)holidayDetailDTO.getWorkingDays(), (LocalDate)loan.getDisbursementDate())) {
                String errorMessage = "Expected disbursement date cannot be on a non working day";
                throw new LoanApplicationDateException("disbursement.date.on.non.working.day", "Expected disbursement date cannot be on a non working day", new Object[]{loan.getExpectedDisbursedOnLocalDate()});
            }
            if (!holidayDetailDTO.isAllowTransactionsOnHoliday() && HolidayUtil.isHoliday((LocalDate)loan.getDisbursementDate(), (List)holidayDetailDTO.getHolidays())) {
                String errorMessage = "Expected disbursement date cannot be on a holiday";
                throw new LoanApplicationDateException("disbursement.date.on.holiday", "Expected disbursement date cannot be on a holiday", new Object[]{loan.getExpectedDisbursedOnLocalDate()});
            }
            if ((loan.getStatus().isActive() || loan.getStatus().isClosedObligationsMet() || loan.getStatus().isOverpaid()) && loan.isAllTranchesNotDisbursed() && DateUtils.isBefore((LocalDate)actualDisbursementDate, (LocalDate)(submittedOnDate = loan.getSubmittedOnDate()))) {
                String errorMsg = "Loan can't be disbursed before " + String.valueOf(submittedOnDate);
                throw new LoanDisbursalException(errorMsg, "actualdisbursementdate.before.submittedDate", new Object[]{submittedOnDate, actualDisbursementDate});
            }
            LocalDate approvedOnDate = loan.getApprovedOnDate();
            if (actualDisbursementDate != null && DateUtils.isBefore((LocalDate)actualDisbursementDate, (LocalDate)approvedOnDate)) {
                String errorMessage = "The date on which a loan is disbursed cannot be before its approval date: " + String.valueOf(approvedOnDate);
                throw new InvalidLoanStateTransitionException("disbursal", "cannot.be.before.approval.date", errorMessage, new Object[]{actualDisbursementDate, approvedOnDate});
            }
        });
    }

    private void validateDisbursementWithPostDatedChecks(String json, Long loanId) {
        JsonElement jsonElement = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.disbursement");
        Loan loan = (Loan)this.loanRepository.findById((Object)loanId).orElseThrow(() -> new LoanNotFoundException(loanId));
        List loanRepaymentScheduleInstallment = loan.getRepaymentScheduleInstallments();
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(jsonObject);
        if (jsonObject.has("postDatedChecks") && jsonObject.get("postDatedChecks").isJsonArray()) {
            JsonArray postDatedChecks = jsonObject.get("postDatedChecks").getAsJsonArray();
            for (int i = 0; i < postDatedChecks.size(); ++i) {
                JsonObject postDatedCheck = postDatedChecks.get(i).getAsJsonObject();
                String name = this.fromApiJsonHelper.extractStringNamed("name", (JsonElement)postDatedCheck);
                baseDataValidator.reset().parameter("name").value((Object)name).notNull();
                BigDecimal amount = this.fromApiJsonHelper.extractBigDecimalNamed("amount", (JsonElement)postDatedCheck, locale);
                baseDataValidator.reset().parameter("amount").value((Object)amount).notNull().positiveAmount();
                Long accountNo = this.fromApiJsonHelper.extractLongNamed("accountNo", (JsonElement)postDatedCheck);
                baseDataValidator.reset().parameter("accountNo").value((Object)accountNo).notNull().positiveAmount();
                Long checkNo = this.fromApiJsonHelper.extractLongNamed("checkNo", (JsonElement)postDatedCheck);
                baseDataValidator.reset().parameter("checkNo").value((Object)checkNo).notNull().positiveAmount();
                Integer installmentId = this.fromApiJsonHelper.extractIntegerNamed("installmentId", (JsonElement)postDatedCheck, locale);
                List installmentList = loanRepaymentScheduleInstallment.stream().filter(repayment -> repayment.getInstallmentNumber().equals(installmentId) && ((Long)repayment.getLoan().getId()).equals(loanId)).collect(Collectors.toList());
                if (installmentList.size() > 1) {
                    throw new PlatformDataIntegrityException("error.repayment.redundancy", "Multiple installment data found", "postDatedChecks", new Object[0]);
                }
                if (installmentList.size() != 0) continue;
                throw new LoanRepaymentScheduleNotFoundException(installmentId);
            }
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
            }
        }
    }

    private void validateDisbursementDateWithMeetingDate(LocalDate actualDisbursementDate, CalendarInstance calendarInstance, Boolean isSkipRepaymentOnFirstMonth, Integer numberOfDays) {
        Calendar calendar;
        if (null != calendarInstance && !(calendar = calendarInstance.getCalendar()).isValidRecurringDate(actualDisbursementDate, isSkipRepaymentOnFirstMonth, numberOfDays)) {
            String errorMessage = "Expected disbursement date '" + actualDisbursementDate.toString() + "' does not fall on a meeting date.";
            throw new NotValidRecurringDateException("loan.actual.disbursement.date", errorMessage, new Object[]{actualDisbursementDate.toString(), calendar.getTitle()});
        }
    }

    public void validateUndoChargeOff(String json) {
        if (!StringUtils.isBlank((CharSequence)json)) {
            HashSet<String> transactionParameters = new HashSet<String>(Arrays.asList("reversalExternalId"));
            Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
            this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, transactionParameters);
            ArrayList dataValidationErrors = new ArrayList();
            DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.transaction");
            JsonElement element = this.fromApiJsonHelper.parse(json);
            String reversalExternalId = this.fromApiJsonHelper.extractStringNamed("reversalExternalId", element);
            baseDataValidator.reset().parameter("reversalExternalId").ignoreIfNull().value((Object)reversalExternalId).notExceedingLengthOf(Integer.valueOf(100));
            this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
        }
    }

    public void validateTransaction(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        HashSet<String> transactionParameters = new HashSet<String>(Arrays.asList("transactionDate", "transactionAmount", "externalId", "note", "locale", "dateFormat", "paymentTypeId", "accountNumber", "checkNumber", "routingCode", "receiptNumber", "bankNumber", "reversalExternalId"));
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, transactionParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.transaction");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        LocalDate transactionDate = this.fromApiJsonHelper.extractLocalDateNamed("transactionDate", element);
        baseDataValidator.reset().parameter("transactionDate").value((Object)transactionDate).notNull();
        BigDecimal transactionAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("transactionAmount", element);
        baseDataValidator.reset().parameter("transactionAmount").value((Object)transactionAmount).notNull().zeroOrPositiveAmount();
        String note = this.fromApiJsonHelper.extractStringNamed("note", element);
        baseDataValidator.reset().parameter("note").value((Object)note).notExceedingLengthOf(Integer.valueOf(1000));
        String reversalExternalId = this.fromApiJsonHelper.extractStringNamed("reversalExternalId", element);
        baseDataValidator.reset().parameter("reversalExternalId").ignoreIfNull().value((Object)reversalExternalId).notExceedingLengthOf(Integer.valueOf(100));
        this.validatePaymentDetails(baseDataValidator, element);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateChargebackTransaction(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        HashSet<String> transactionParameters = new HashSet<String>(Arrays.asList("transactionAmount", "locale", "externalId", "note", "paymentTypeId"));
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, transactionParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.transaction");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        BigDecimal transactionAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("transactionAmount", element);
        baseDataValidator.reset().parameter("transactionAmount").value((Object)transactionAmount).notNull().positiveAmount();
        String note = this.fromApiJsonHelper.extractStringNamed("note", element);
        baseDataValidator.reset().parameter("note").value((Object)note).notExceedingLengthOf(Integer.valueOf(1000));
        this.validatePaymentDetails(baseDataValidator, element);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateNewRepaymentTransaction(String json) {
        this.validatePaymentTransaction(json);
    }

    public void validateTransactionWithNoAmount(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        HashSet<String> disbursementParameters = new HashSet<String>(Arrays.asList("transactionDate", "note", "locale", "dateFormat", "writeoffReasonId", "externalId"));
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, disbursementParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.transaction");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        LocalDate transactionDate = this.fromApiJsonHelper.extractLocalDateNamed("transactionDate", element);
        baseDataValidator.reset().parameter("transactionDate").value((Object)transactionDate).notNull();
        String note = this.fromApiJsonHelper.extractStringNamed("note", element);
        baseDataValidator.reset().parameter("note").value((Object)note).notExceedingLengthOf(Integer.valueOf(1000));
        String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
        baseDataValidator.reset().parameter("externalId").value((Object)externalId).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(100));
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateChargeOffTransaction(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        HashSet<String> chargeOffParameters = new HashSet<String>(Arrays.asList("transactionDate", "note", "locale", "dateFormat", "chargeOffReasonId", "externalId"));
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, chargeOffParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.transaction");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        LocalDate transactionDate = this.fromApiJsonHelper.extractLocalDateNamed("transactionDate", element);
        baseDataValidator.reset().parameter("transactionDate").value((Object)transactionDate).notNull();
        String note = this.fromApiJsonHelper.extractStringNamed("note", element);
        baseDataValidator.reset().parameter("note").value((Object)note).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(1000));
        String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
        baseDataValidator.reset().parameter("externalId").value((Object)externalId).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(100));
        Long chargeOffReasonId = this.fromApiJsonHelper.extractLongNamed("chargeOffReasonId", element);
        baseDataValidator.reset().parameter("chargeOffReasonId").value((Object)chargeOffReasonId).ignoreIfNull().integerGreaterThanZero();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateUpdateOfLoanOfficer(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        HashSet<String> disbursementParameters = new HashSet<String>(Arrays.asList("assignmentDate", "fromLoanOfficerId", "toLoanOfficerId", "locale", "dateFormat"));
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, disbursementParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loanOfficer");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        Long toLoanOfficerId = this.fromApiJsonHelper.extractLongNamed("toLoanOfficerId", element);
        baseDataValidator.reset().parameter("toLoanOfficerId").value((Object)toLoanOfficerId).notNull().integerGreaterThanZero();
        String assignmentDateStr = this.fromApiJsonHelper.extractStringNamed("assignmentDate", element);
        baseDataValidator.reset().parameter("assignmentDate").value((Object)assignmentDateStr).notBlank();
        if (!StringUtils.isBlank((CharSequence)assignmentDateStr)) {
            LocalDate assignmentDate = this.fromApiJsonHelper.extractLocalDateNamed("assignmentDate", element);
            baseDataValidator.reset().parameter("assignmentDate").value((Object)assignmentDate).notNull();
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForBulkLoanReassignment(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        HashSet<String> supportedParameters = new HashSet<String>(Arrays.asList("assignmentDate", "fromLoanOfficerId", "toLoanOfficerId", "loans", "locale", "dateFormat"));
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, supportedParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loanOfficer");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        LocalDate assignmentDate = this.fromApiJsonHelper.extractLocalDateNamed("assignmentDate", element);
        baseDataValidator.reset().parameter("assignmentDate").value((Object)assignmentDate).notNull();
        Long fromLoanOfficerId = this.fromApiJsonHelper.extractLongNamed("fromLoanOfficerId", element);
        baseDataValidator.reset().parameter("fromLoanOfficerId").value((Object)fromLoanOfficerId).notNull().longGreaterThanZero();
        Long toLoanOfficerId = this.fromApiJsonHelper.extractLongNamed("toLoanOfficerId", element);
        baseDataValidator.reset().parameter("toLoanOfficerId").value((Object)toLoanOfficerId).notNull().longGreaterThanZero();
        String[] loans = this.fromApiJsonHelper.extractArrayNamed("loans", element);
        baseDataValidator.reset().parameter("loans").value((Object)loans).arrayNotEmpty();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateMarkAsFraudLoan(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return;
        }
        HashSet<String> transactionParameters = new HashSet<String>(Arrays.asList("fraud"));
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, transactionParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loans.fraud");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        boolean isFraud = this.fromApiJsonHelper.extractBooleanNamed("fraud", element);
        baseDataValidator.reset().parameter("fraud").value((Object)isFraud).notNull();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateUpdateDisbursementDateAndAmount(String json, LoanDisbursementDetails loanDisbursementDetails) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        HashSet<String> disbursementParameters = new HashSet<String>(Arrays.asList("locale", "dateFormat", "disbursementData", "approvedLoanAmount", "updatedExpectedDisbursementDate", "updatedPrincipal", "expectedDisbursementDate"));
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, disbursementParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.update.disbursement");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        LocalDate actualDisbursementDate = this.fromApiJsonHelper.extractLocalDateNamed("expectedDisbursementDate", element);
        baseDataValidator.reset().parameter("expectedDisbursementDate").value((Object)actualDisbursementDate).notNull();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(element.getAsJsonObject());
        BigDecimal principal = this.fromApiJsonHelper.extractBigDecimalNamed("updatedPrincipal", element, locale);
        baseDataValidator.reset().parameter("principal").value((Object)principal).notNull();
        BigDecimal approvedPrincipal = this.fromApiJsonHelper.extractBigDecimalNamed("approvedLoanAmount", element, locale);
        if (loanDisbursementDetails.actualDisbursementDate() != null) {
            baseDataValidator.reset().parameter("expectedDisbursementDate").failWithCode("can.not.change.disbursement.date", new Object[0]);
        }
        this.fromApiJsonDeserializer.validateLoanMultiDisbursementDate(element, baseDataValidator, actualDisbursementDate, approvedPrincipal);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateNewRefundTransaction(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        HashSet<String> transactionParameters = new HashSet<String>(Arrays.asList("transactionDate", "transactionAmount", "externalId", "note", "locale", "dateFormat", "paymentTypeId", "accountNumber", "checkNumber", "routingCode", "receiptNumber", "bankNumber"));
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, transactionParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.transaction");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        LocalDate transactionDate = this.fromApiJsonHelper.extractLocalDateNamed("transactionDate", element);
        baseDataValidator.reset().parameter("transactionDate").value((Object)transactionDate).notNull();
        BigDecimal transactionAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("transactionAmount", element);
        baseDataValidator.reset().parameter("transactionAmount").value((Object)transactionAmount).notNull().positiveAmount();
        String note = this.fromApiJsonHelper.extractStringNamed("note", element);
        baseDataValidator.reset().parameter("note").value((Object)note).notExceedingLengthOf(Integer.valueOf(1000));
        String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
        baseDataValidator.reset().parameter("externalId").value((Object)externalId).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(100));
        this.validatePaymentDetails(baseDataValidator, element);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateLoanForeclosure(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        HashSet<String> foreclosureParameters = new HashSet<String>(Arrays.asList("transactionDate", "note", "locale", "dateFormat", "externalId"));
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, foreclosureParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        LocalDate transactionDate = this.fromApiJsonHelper.extractLocalDateNamed("transactionDate", element);
        baseDataValidator.reset().parameter("transactionDate").value((Object)transactionDate).notNull();
        String note = this.fromApiJsonHelper.extractStringNamed("note", element);
        baseDataValidator.reset().parameter("note").value((Object)note).notExceedingLengthOf(Integer.valueOf(1000));
        String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
        baseDataValidator.reset().parameter("externalId").value((Object)externalId).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(100));
        this.validatePaymentDetails(baseDataValidator, element);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateLoanClientIsActive(Loan loan) {
        Client client = loan.client();
        if (client != null && client.isNotActive()) {
            throw new ClientNotActiveException((Long)client.getId());
        }
    }

    public void validateLoanGroupIsActive(Loan loan) {
        Group group = loan.group();
        if (group != null && group.isNotActive()) {
            throw new GroupNotActiveException((Long)group.getId());
        }
    }

    private void validateLoanHasNoLaterChargeRefundTransactionToReverseOrCreateATransaction(Loan loan, LocalDate transactionDate, String reversedOrCreated) {
        for (LoanTransaction txn : loan.getLoanTransactions()) {
            if (!txn.isChargeRefund() || !DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)txn.getTransactionDate())) continue;
            String errorMessage = "loan.transaction.cant.be." + reversedOrCreated + ".because.later.charge.refund.exists";
            String details = "Loan Transaction: " + String.valueOf(loan.getId()) + " Can't be " + reversedOrCreated + " because a Later Charge Refund Exists.";
            throw new LoanChargeRefundException(errorMessage, new Object[]{details});
        }
    }

    private void validateLoanDisbursementIsBeforeTransactionDate(Loan loan, LocalDate transactionDate) {
        if (DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)loan.getDisbursementDate())) {
            String errorMessage = "The transaction date cannot be before the loan disbursement date: " + loan.getDisbursementDate().toString();
            throw new InvalidLoanStateTransitionException("transaction", "cannot.be.before.disbursement.date", errorMessage, new Object[]{transactionDate, loan.getDisbursementDate()});
        }
    }

    private void validateTransactionShouldNotBeInTheFuture(LocalDate transactionDate) {
        if (DateUtils.isDateInTheFuture((LocalDate)transactionDate)) {
            String errorMessage = "The transaction date cannot be in the future.";
            throw new InvalidLoanStateTransitionException("transaction", "cannot.be.a.future.date", "The transaction date cannot be in the future.", new Object[]{transactionDate});
        }
    }

    private void validateLoanHasCurrency(Loan loan) {
        MonetaryCurrency currency = loan.getCurrency();
        ApplicationCurrency defaultApplicationCurrency = this.applicationCurrencyRepository.findOneByCode(currency.getCode());
        if (defaultApplicationCurrency == null) {
            throw new CurrencyNotFoundException(currency.getCode());
        }
    }

    private void validateClientOfficeJoiningDateIsBeforeTransactionDate(Loan loan, LocalDate transactionDate) {
        LocalDate clientOfficeJoiningDate;
        if (loan.getClient() != null && loan.getClient().getOfficeJoiningDate() != null && DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)(clientOfficeJoiningDate = loan.getClient().getOfficeJoiningDate()))) {
            String errorMessage = "The date on which a repayment or waiver is made cannot be earlier than client's transfer date to this office";
            String action = "repayment.or.waiver";
            String postfix = "cannot.be.made.before.client.transfer.date";
            throw new InvalidLoanStateTransitionException(action, postfix, errorMessage, new Object[]{clientOfficeJoiningDate});
        }
    }

    public void validateActivityNotBeforeLastTransactionDate(Loan loan, LocalDate activityDate, LoanEvent event) {
        if (!loan.isInterestBearingAndInterestRecalculationEnabled() && !loan.loanProduct().isHoldGuaranteeFunds() || !loan.getLoanRepaymentScheduleDetail().getLoanScheduleType().equals((Object)LoanScheduleType.CUMULATIVE)) {
            return;
        }
        LocalDate lastTransactionDate = loan.getLastUserTransactionDate();
        if (DateUtils.isAfter((LocalDate)lastTransactionDate, (LocalDate)activityDate)) {
            String errorMessage = null;
            String action = null;
            String postfix = null;
            switch (14.$SwitchMap$org$apache$fineract$portfolio$loanaccount$domain$LoanEvent[event.ordinal()]) {
                case 1: {
                    errorMessage = "The date on which a repayment or waiver is made cannot be earlier than last transaction date";
                    action = "repayment.or.waiver";
                    postfix = "cannot.be.made.before.last.transaction.date";
                    break;
                }
                case 2: {
                    errorMessage = "The date on which a write off is made cannot be earlier than last transaction date";
                    action = "writeoff";
                    postfix = "cannot.be.made.before.last.transaction.date";
                    break;
                }
                case 3: {
                    errorMessage = "The date on which a charge payment is made cannot be earlier than last transaction date";
                    action = "charge.payment";
                    postfix = "cannot.be.made.before.last.transaction.date";
                    break;
                }
            }
            throw new InvalidLoanStateTransitionException(action, postfix, errorMessage, new Object[]{lastTransactionDate});
        }
    }

    public void validateRepaymentDateIsOnNonWorkingDay(LocalDate repaymentDate, WorkingDays workingDays, boolean allowTransactionsOnNonWorkingDay) {
        if (!allowTransactionsOnNonWorkingDay && !WorkingDaysUtil.isWorkingDay((WorkingDays)workingDays, (LocalDate)repaymentDate)) {
            String errorMessage = "Repayment date cannot be on a non working day";
            throw new LoanApplicationDateException("repayment.date.on.non.working.day", "Repayment date cannot be on a non working day", new Object[]{repaymentDate});
        }
    }

    public void validateRepaymentDateIsOnHoliday(LocalDate repaymentDate, boolean allowTransactionsOnHoliday, List<Holiday> holidays) {
        if (!allowTransactionsOnHoliday && HolidayUtil.isHoliday((LocalDate)repaymentDate, holidays)) {
            String errorMessage = "Repayment date cannot be on a holiday";
            throw new LoanApplicationDateException("repayment.date.on.holiday", "Repayment date cannot be on a holiday", new Object[]{repaymentDate});
        }
    }

    private void validateTransactionAmountNotExceedThresholdForMultiDisburseLoan(Loan loan) {
        BigDecimal totalPrincipalAdjusted;
        BigDecimal totalDisbursed;
        BigDecimal totalPrincipalCredited;
        if (loan.getLoanProduct().isMultiDisburseLoan() && (totalPrincipalCredited = (totalDisbursed = loan.getDisbursedAmount()).add(totalPrincipalAdjusted = loan.getSummary().getTotalPrincipalAdjustments())).compareTo(loan.getSummary().getTotalPrincipalRepaid()) < 0) {
            String errorMessage = "The transaction amount cannot exceed threshold.";
            throw new InvalidLoanStateTransitionException("transaction", "amount.exceeds.threshold", "The transaction amount cannot exceed threshold.", new Object[0]);
        }
    }

    public void validateLoanTransactionInterestPaymentWaiver(JsonCommand command) {
        Long loanId = command.getLoanId();
        Loan loan = (Loan)this.loanRepository.findById((Object)loanId).orElseThrow(() -> new LoanNotFoundException(loanId));
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        this.validateNewRepaymentTransaction(command.json());
        this.validateTransactionShouldNotBeInTheFuture(transactionDate);
        this.validateLoanClientIsActive(loan);
        this.validateLoanHasCurrency(loan);
        this.validateLoanGroupIsActive(loan);
        this.loanDownPaymentTransactionValidator.validateLoanStatusIsActiveOrFullyPaidOrOverpaid(loan);
        this.validateLoanDisbursementIsBeforeTransactionDate(loan, transactionDate);
        this.validateLoanHasNoLaterChargeRefundTransactionToReverseOrCreateATransaction(loan, transactionDate, "created");
        this.validateClientOfficeJoiningDateIsBeforeTransactionDate(loan, transactionDate);
        this.validateActivityNotBeforeLastTransactionDate(loan, transactionDate, LoanEvent.LOAN_REPAYMENT_OR_WAIVER);
        HolidayDetailDTO holidayDetailDTO = this.loanUtilService.constructHolidayDTO(loan.getOfficeId(), loan.getDisbursementDate());
        this.validateRepaymentDateIsOnHoliday(transactionDate, holidayDetailDTO.isAllowTransactionsOnHoliday(), holidayDetailDTO.getHolidays());
        this.validateRepaymentDateIsOnNonWorkingDay(transactionDate, holidayDetailDTO.getWorkingDays(), holidayDetailDTO.isAllowTransactionsOnNonWorkingDay());
        this.validateTransactionAmountNotExceedThresholdForMultiDisburseLoan(loan);
    }

    public void validateLoanTransactionInterestPaymentWaiverAfterRecalculation(Loan loan) {
        BigDecimal totalPrincipalAdjusted;
        BigDecimal totalDisbursed;
        BigDecimal totalPrincipalCredited;
        if (loan.getLoanProduct().isMultiDisburseLoan() && (totalPrincipalCredited = (totalDisbursed = loan.getDisbursedAmount()).add(totalPrincipalAdjusted = loan.getSummary().getTotalPrincipalAdjustments())).compareTo(loan.getSummary().getTotalPrincipalRepaid()) < 0 && loan.getLoanRepaymentScheduleDetail().getPrincipal().minus(totalDisbursed).isGreaterThanZero()) {
            String errorMessage = "The transaction amount cannot exceed threshold.";
            throw new InvalidLoanStateTransitionException("transaction", "amount.exceeds.threshold", "The transaction amount cannot exceed threshold.", new Object[0]);
        }
    }

    public void validateRefund(String json) {
        this.validatePaymentTransaction(json);
    }

    public void validateRefund(Loan loan, LoanTransactionType loanTransactionType, LocalDate transactionDate, ScheduleGeneratorDTO scheduleGeneratorDTO) {
        this.checkClientOrGroupActive(loan);
        this.loanDownPaymentTransactionValidator.validateLoanStatusIsActiveOrFullyPaidOrOverpaid(loan);
        this.validateActivityNotBeforeClientOrGroupTransferDate(loan, transactionDate);
        this.validateRepaymentTypeTransactionNotBeforeAChargeRefund(loan, loanTransactionType, transactionDate);
        this.validateTransactionNotBeforeLastTransactionDate(loan, loanTransactionType, transactionDate);
        this.validateRepaymentDateIsOnHoliday(transactionDate, scheduleGeneratorDTO.getHolidayDetailDTO().isAllowTransactionsOnHoliday(), scheduleGeneratorDTO.getHolidayDetailDTO().getHolidays());
        this.validateRepaymentDateIsOnNonWorkingDay(transactionDate, scheduleGeneratorDTO.getHolidayDetailDTO().getWorkingDays(), scheduleGeneratorDTO.getHolidayDetailDTO().isAllowTransactionsOnNonWorkingDay());
        this.validateTransactionShouldNotBeInTheFuture(transactionDate);
        this.validateTransactionAmountNotExceedThresholdForMultiDisburseLoan(loan);
    }

    private void validateRepaymentTypeTransactionNotBeforeAChargeRefund(Loan loan, LoanTransactionType loanTransactionType, LocalDate transactionDate) {
        if (loanTransactionType.isRepaymentType() && !loanTransactionType.isChargeRefund()) {
            for (LoanTransaction txn : loan.getLoanTransactions()) {
                if (!txn.isChargeRefund() || !DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)txn.getTransactionDate())) continue;
                String errorMessage = "loan.transaction.cant.be.created.because.later.charge.refund.exists";
                String details = "Loan Transaction: " + String.valueOf(loan.getId()) + " Can't be created because a Later Charge Refund Exists.";
                throw new LoanChargeRefundException("loan.transaction.cant.be.created.because.later.charge.refund.exists", new Object[]{details});
            }
        }
    }

    public void validateRefundDateIsAfterLastRepayment(Loan loan, LocalDate refundTransactionDate) {
        LocalDate possibleNextRefundDate = loan.possibleNextRefundDate();
        if (possibleNextRefundDate == null || DateUtils.isBefore((LocalDate)refundTransactionDate, (LocalDate)possibleNextRefundDate)) {
            throw new InvalidRefundDateException(refundTransactionDate.toString());
        }
    }

    public void validateActivityNotBeforeClientOrGroupTransferDate(Loan loan, LoanEvent event, LocalDate activityDate) {
        LocalDate clientOfficeJoiningDate;
        if (loan.getClient() != null && loan.getClient().getOfficeJoiningDate() != null && DateUtils.isBefore((LocalDate)activityDate, (LocalDate)(clientOfficeJoiningDate = loan.getClient().getOfficeJoiningDate()))) {
            String errorMessage = null;
            String action = null;
            String postfix = null;
            switch (14.$SwitchMap$org$apache$fineract$portfolio$loanaccount$domain$LoanEvent[event.ordinal()]) {
                case 4: {
                    errorMessage = "The date on which a loan is approved cannot be earlier than client's transfer date to this office";
                    action = "approval";
                    postfix = "cannot.be.before.client.transfer.date";
                    break;
                }
                case 5: {
                    errorMessage = "The date on which a loan is approved cannot be earlier than client's transfer date to this office";
                    action = "approval";
                    postfix = "cannot.be.undone.before.client.transfer.date";
                    break;
                }
                case 6: {
                    errorMessage = "The date on which a loan is disbursed cannot be earlier than client's transfer date to this office";
                    action = "disbursal";
                    postfix = "cannot.be.before.client.transfer.date";
                    break;
                }
                case 7: {
                    errorMessage = "Cannot undo a disbursal done in another branch";
                    action = "disbursal";
                    postfix = "cannot.be.undone.before.client.transfer.date";
                    break;
                }
                case 1: {
                    errorMessage = "The date on which a repayment or waiver is made cannot be earlier than client's transfer date to this office";
                    action = "repayment.or.waiver";
                    postfix = "cannot.be.made.before.client.transfer.date";
                    break;
                }
                case 2: {
                    errorMessage = "The date on which a write off is made cannot be earlier than client's transfer date to this office";
                    action = "writeoff";
                    postfix = "cannot.be.undone.before.client.transfer.date";
                    break;
                }
                case 8: {
                    errorMessage = "The date on which the loan is repaid in full cannot be earlier than client's transfer date to this office";
                    action = "close";
                    postfix = "cannot.be.undone.before.client.transfer.date";
                    break;
                }
                case 3: {
                    errorMessage = "The date on which a charge payment is made cannot be earlier than client's transfer date to this office";
                    action = "charge.payment";
                    postfix = "cannot.be.made.before.client.transfer.date";
                    break;
                }
                case 9: {
                    errorMessage = "The date on which a refund is made cannot be earlier than client's transfer date to this office";
                    action = "refund";
                    postfix = "cannot.be.made.before.client.transfer.date";
                    break;
                }
                case 10: {
                    errorMessage = "Cannot undo a last disbursal in another branch";
                    action = "disbursal";
                    postfix = "cannot.be.undone.before.client.transfer.date";
                    break;
                }
            }
            throw new InvalidLoanStateTransitionException(action, postfix, errorMessage, new Object[]{clientOfficeJoiningDate});
        }
    }

    @NonNull
    private static BigDecimal collectTotalCollateral(Set<LoanCollateralManagement> loanCollateralManagements) {
        BigDecimal totalCollateral = BigDecimal.ZERO;
        for (LoanCollateralManagement loanCollateralManagement : loanCollateralManagements) {
            BigDecimal quantity = loanCollateralManagement.getQuantity();
            BigDecimal pctToBase = loanCollateralManagement.getClientCollateralManagement().getCollaterals().getPctToBase();
            BigDecimal basePrice = loanCollateralManagement.getClientCollateralManagement().getCollaterals().getBasePrice();
            totalCollateral = totalCollateral.add(quantity.multiply(basePrice).multiply(pctToBase).divide(BigDecimal.valueOf(100L)));
        }
        return totalCollateral;
    }

    @NonNull
    private static Set<String> getDisbursementParameters(boolean isAccountTransfer) {
        HashSet<String> disbursementParameters = isAccountTransfer ? new HashSet<String>(Arrays.asList("actualDisbursementDate", "externalId", "note", "locale", "dateFormat", "transactionAmount", "fixedEmiAmount", "netDisbursalAmount")) : new HashSet<String>(Arrays.asList("actualDisbursementDate", "externalId", "note", "locale", "dateFormat", "paymentTypeId", "accountNumber", "checkNumber", "routingCode", "receiptNumber", "bankNumber", "adjustRepaymentDate", "transactionAmount", "fixedEmiAmount", "postDatedChecks", "netDisbursalAmount"));
        return disbursementParameters;
    }

    private void validatePaymentTransaction(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        HashSet<String> transactionParameters = new HashSet<String>(Arrays.asList("transactionDate", "transactionAmount", "externalId", "note", "locale", "dateFormat", "paymentTypeId", "accountNumber", "checkNumber", "routingCode", "receiptNumber", "bankNumber", "loanId", "numberOfRepayments", "interestRefundCalculation"));
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, transactionParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.transaction");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        LocalDate transactionDate = this.fromApiJsonHelper.extractLocalDateNamed("transactionDate", element);
        baseDataValidator.reset().parameter("transactionDate").value((Object)transactionDate).notNull();
        BigDecimal transactionAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("transactionAmount", element);
        baseDataValidator.reset().parameter("transactionAmount").value((Object)transactionAmount).notNull().positiveAmount();
        String note = this.fromApiJsonHelper.extractStringNamed("note", element);
        baseDataValidator.reset().parameter("note").value((Object)note).notExceedingLengthOf(Integer.valueOf(1000));
        this.validatePaymentDetails(baseDataValidator, element);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validatePaymentDetails(DataValidatorBuilder baseDataValidator, JsonElement element) {
        Integer paymentTypeId = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("paymentTypeId", element);
        baseDataValidator.reset().parameter("paymentTypeId").value((Object)paymentTypeId).ignoreIfNull().integerGreaterThanZero();
        HashSet<String> paymentDetailParameters = new HashSet<String>(Arrays.asList("accountNumber", "checkNumber", "routingCode", "receiptNumber", "bankNumber"));
        for (String paymentDetailParameterName : paymentDetailParameters) {
            String paymentDetailParameterValue = this.fromApiJsonHelper.extractStringNamed(paymentDetailParameterName, element);
            baseDataValidator.reset().parameter(paymentDetailParameterName).value((Object)paymentDetailParameterValue).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(50));
        }
    }

    private void checkClientOrGroupActive(Loan loan) {
        Client client = loan.client();
        if (client != null && client.isNotActive()) {
            throw new ClientNotActiveException((Long)client.getId());
        }
        Group group = loan.group();
        if (group != null && group.isNotActive()) {
            throw new GroupNotActiveException((Long)group.getId());
        }
    }

    private void validateActivityNotBeforeClientOrGroupTransferDate(Loan loan, LocalDate transactionDate) {
        LocalDate clientOfficeJoiningDate;
        if (loan.getClient() != null && loan.getClient().getOfficeJoiningDate() != null && DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)(clientOfficeJoiningDate = loan.getClient().getOfficeJoiningDate()))) {
            String errorMessage = "The date on which the transaction is made cannot be earlier than client's transfer date to this office";
            String action = "repayment.or.waiver";
            String postfix = "cannot.be.made.before.client.transfer.date";
            throw new InvalidLoanStateTransitionException(action, postfix, errorMessage, new Object[]{clientOfficeJoiningDate});
        }
    }

    private void validateTransactionNotBeforeLastTransactionDate(Loan loan, LoanTransactionType loanTransactionType, LocalDate transactionDate) {
        String humanReadable;
        if (!(LoanScheduleType.CUMULATIVE.equals((Object)loan.getLoanProductRelatedDetail().getLoanScheduleType()) && loan.isInterestBearingAndInterestRecalculationEnabled() || loan.getLoanProduct().isHoldGuaranteeFunds())) {
            return;
        }
        LocalDate lastTransactionDate = loan.getLastUserTransactionDate();
        String action = switch (14.$SwitchMap$org$apache$fineract$portfolio$loanaccount$domain$LoanTransactionType[loanTransactionType.ordinal()]) {
            case 1 -> {
                humanReadable = "merchant issued refund";
                yield "merchant.issued.refund";
            }
            case 2 -> {
                humanReadable = "payout refund";
                yield "payout.refund";
            }
            default -> {
                humanReadable = "transaction";
                yield "transaction";
            }
        };
        if (DateUtils.isAfter((LocalDate)lastTransactionDate, (LocalDate)transactionDate)) {
            String errorMessage = "The date on which the " + humanReadable + " is made cannot be earlier than last transaction date";
            String postfix = "cannot.be.made.before.last.transaction.date";
            throw new InvalidLoanStateTransitionException(action, postfix, errorMessage, new Object[]{lastTransactionDate});
        }
    }

    public void validateIfTransactionIsChargeback(LoanTransaction chargebackTransaction) {
        if (!chargebackTransaction.isChargeback()) {
            String errorMessage = "A transaction of type chargeback was expected but not received.";
            throw new InvalidLoanTransactionTypeException("transaction", "is.not.a.chargeback.transaction", "A transaction of type chargeback was expected but not received.", new Object[0]);
        }
    }

    public void validateLoanRescheduleDate(Loan loan) {
        if (DateUtils.isBefore((LocalDate)loan.getRescheduledOnDate(), (LocalDate)loan.getDisbursementDate())) {
            String errorMessage = "The date on which a loan is rescheduled cannot be before the loan disbursement date: " + loan.getDisbursementDate().toString();
            throw new InvalidLoanStateTransitionException("close.reschedule", "cannot.be.before.submittal.date", errorMessage, new Object[]{loan.getRescheduledOnDate(), loan.getDisbursementDate()});
        }
        if (DateUtils.isDateInTheFuture((LocalDate)loan.getRescheduledOnDate())) {
            String errorMessage = "The date on which a loan is rescheduled cannot be in the future.";
            throw new InvalidLoanStateTransitionException("close.reschedule", "cannot.be.a.future.date", "The date on which a loan is rescheduled cannot be in the future.", new Object[]{loan.getRescheduledOnDate()});
        }
    }

    public void validateNote(DataValidatorBuilder baseDataValidator, JsonElement element) {
        String note = this.fromApiJsonHelper.extractStringNamed("note", element);
        if (StringUtils.isNotBlank((CharSequence)note)) {
            baseDataValidator.reset().parameter("note").value((Object)note).notExceedingLengthOf(Integer.valueOf(1000));
        }
    }

    public void validateExternalId(DataValidatorBuilder baseDataValidator, JsonElement element) {
        String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
        if (StringUtils.isNotBlank((CharSequence)externalId)) {
            baseDataValidator.reset().parameter("externalId").value((Object)externalId).notExceedingLengthOf(Integer.valueOf(100));
        }
    }

    public void validateReversalExternalId(DataValidatorBuilder baseDataValidator, JsonElement element) {
        String reversalExternalId = this.fromApiJsonHelper.extractStringNamed("reversalExternalId", element);
        if (StringUtils.isNotBlank((CharSequence)reversalExternalId)) {
            baseDataValidator.reset().parameter("reversalExternalId").value((Object)reversalExternalId).notExceedingLengthOf(Integer.valueOf(100));
        }
    }

    @Generated
    public LoanTransactionValidatorImpl(FromJsonHelper fromApiJsonHelper, LoanApplicationValidator fromApiJsonDeserializer, LoanRepository loanRepository, LoanRepositoryWrapper loanRepositoryWrapper, ApplicationCurrencyRepository applicationCurrencyRepository, LoanUtilService loanUtilService, EntityDatatableChecksWritePlatformService entityDatatableChecksWritePlatformService, CalendarInstanceRepository calendarInstanceRepository, LoanDownPaymentTransactionValidator loanDownPaymentTransactionValidator, LoanDisbursementValidator loanDisbursementValidator) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.loanRepository = loanRepository;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.applicationCurrencyRepository = applicationCurrencyRepository;
        this.loanUtilService = loanUtilService;
        this.entityDatatableChecksWritePlatformService = entityDatatableChecksWritePlatformService;
        this.calendarInstanceRepository = calendarInstanceRepository;
        this.loanDownPaymentTransactionValidator = loanDownPaymentTransactionValidator;
        this.loanDisbursementValidator = loanDisbursementValidator;
    }
}

