/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.group.service;

import jakarta.persistence.PersistenceException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandProcessingService;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormat;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormatRepositoryWrapper;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.codes.domain.CodeValueRepositoryWrapper;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.StatusEnum;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksWritePlatformService;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.group.CentersCreateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.group.GroupsCreateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.office.domain.OfficeRepositoryWrapper;
import org.apache.fineract.organisation.office.exception.InvalidOfficeException;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.staff.domain.StaffRepositoryWrapper;
import org.apache.fineract.portfolio.account.service.AccountNumberGenerator;
import org.apache.fineract.portfolio.calendar.domain.Calendar;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstance;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstanceRepository;
import org.apache.fineract.portfolio.calendar.domain.CalendarType;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.client.service.LoanStatusMapper;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupLevel;
import org.apache.fineract.portfolio.group.domain.GroupLevelRepository;
import org.apache.fineract.portfolio.group.domain.GroupRepositoryWrapper;
import org.apache.fineract.portfolio.group.domain.GroupTypes;
import org.apache.fineract.portfolio.group.exception.GroupAccountExistsException;
import org.apache.fineract.portfolio.group.exception.GroupHasNoStaffException;
import org.apache.fineract.portfolio.group.exception.GroupMemberCountNotInPermissibleRangeException;
import org.apache.fineract.portfolio.group.exception.GroupMustBePendingToBeDeletedException;
import org.apache.fineract.portfolio.group.exception.InvalidGroupLevelException;
import org.apache.fineract.portfolio.group.exception.InvalidGroupStateTransitionException;
import org.apache.fineract.portfolio.group.serialization.GroupingTypesDataValidator;
import org.apache.fineract.portfolio.group.service.GroupingTypesWritePlatformService;
import org.apache.fineract.portfolio.group.service.GroupingTypesWritePlatformServiceJpaRepositoryImpl;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.service.LoanOfficerService;
import org.apache.fineract.portfolio.note.domain.NoteRepository;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepositoryWrapper;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class GroupingTypesWritePlatformServiceJpaRepositoryImpl
implements GroupingTypesWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GroupingTypesWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final GroupRepositoryWrapper groupRepository;
    private final ClientRepositoryWrapper clientRepositoryWrapper;
    private final OfficeRepositoryWrapper officeRepositoryWrapper;
    private final StaffRepositoryWrapper staffRepository;
    private final NoteRepository noteRepository;
    private final GroupLevelRepository groupLevelRepository;
    private final GroupingTypesDataValidator fromApiJsonDeserializer;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final CodeValueRepositoryWrapper codeValueRepository;
    private final CommandProcessingService commandProcessingService;
    private final CalendarInstanceRepository calendarInstanceRepository;
    private final ConfigurationDomainService configurationDomainService;
    private final SavingsAccountRepositoryWrapper savingsAccountRepositoryWrapper;
    private final AccountNumberFormatRepositoryWrapper accountNumberFormatRepository;
    private final AccountNumberGenerator accountNumberGenerator;
    private final EntityDatatableChecksWritePlatformService entityDatatableChecksWritePlatformService;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final LoanOfficerService loanOfficerService;

    private CommandProcessingResult createGroupingType(JsonCommand command, GroupTypes groupingType, Long centerId) {
        try {
            CommandWrapper commandWrapper;
            String accountNo = command.stringValueOfParameterNamed("accountNo");
            String name = command.stringValueOfParameterNamed("name");
            String externalId = command.stringValueOfParameterNamed("externalId");
            AppUser currentUser = this.context.authenticatedUser();
            Long officeId = null;
            Group parentGroup = null;
            if (centerId == null) {
                officeId = command.longValueOfParameterNamed("officeId");
            } else {
                parentGroup = this.groupRepository.findOneWithNotFoundDetection(centerId);
                officeId = parentGroup.officeId();
            }
            Office groupOffice = this.officeRepositoryWrapper.findOneWithNotFoundDetection(officeId);
            LocalDate activationDate = command.localDateValueOfParameterNamed("activationDate");
            GroupLevel groupLevel = this.groupLevelRepository.findById((Object)groupingType.getId()).orElse(null);
            this.validateOfficeOpeningDateisAfterGroupOrCenterOpeningDate(groupOffice, groupLevel, activationDate);
            Staff staff = null;
            Long staffId = command.longValueOfParameterNamed("staffId");
            if (staffId != null) {
                staff = this.staffRepository.findByOfficeHierarchyWithNotFoundDetection(staffId, groupOffice.getHierarchy());
            }
            Set clientMembers = this.assembleSetOfClients(officeId, command);
            Set groupMembers = this.assembleSetOfChildGroups(officeId, command);
            boolean active = command.booleanPrimitiveValueOfParameterNamed("active");
            LocalDate submittedOnDate = DateUtils.getBusinessLocalDate();
            if (active && DateUtils.isAfter((LocalDate)submittedOnDate, (LocalDate)activationDate)) {
                submittedOnDate = activationDate;
            }
            if (command.hasParameter("submittedOnDate")) {
                submittedOnDate = command.localDateValueOfParameterNamed("submittedOnDate");
            }
            Group newGroup = Group.newGroup((Office)groupOffice, (Staff)staff, (Group)parentGroup, (GroupLevel)groupLevel, (String)name, (String)externalId, (boolean)active, (LocalDate)activationDate, (Set)clientMembers, (Set)groupMembers, (LocalDate)submittedOnDate, (AppUser)currentUser, (String)accountNo);
            boolean rollbackTransaction = false;
            if (newGroup.isActive()) {
                this.groupRepository.saveAndFlush(newGroup);
                if (newGroup.isGroup()) {
                    this.validateGroupRulesBeforeActivation(newGroup);
                }
                if (newGroup.isCenter()) {
                    commandWrapper = new CommandWrapperBuilder().activateCenter(null).build();
                    rollbackTransaction = this.commandProcessingService.validateRollbackCommand(commandWrapper, currentUser);
                } else {
                    commandWrapper = new CommandWrapperBuilder().activateGroup(null).build();
                    rollbackTransaction = this.commandProcessingService.validateRollbackCommand(commandWrapper, currentUser);
                }
            }
            if (!newGroup.isCenter() && newGroup.hasActiveClients()) {
                commandWrapper = new CommandWrapperBuilder().associateClientsToGroup((Long)newGroup.getId()).build();
                rollbackTransaction = this.commandProcessingService.validateRollbackCommand(commandWrapper, currentUser);
            }
            this.groupRepository.save(newGroup);
            newGroup.generateHierarchy();
            this.generateAccountNumberIfRequired(newGroup);
            this.groupRepository.saveAndFlush(newGroup);
            newGroup.captureStaffHistoryDuringCenterCreation(staff, activationDate);
            if (newGroup.isGroup()) {
                if (command.parameterExists("datatables")) {
                    this.entityDatatableChecksWritePlatformService.saveDatatables(StatusEnum.CREATE.getValue(), EntityTables.GROUP.getName(), (Long)newGroup.getId(), null, command.arrayOfParameterNamed("datatables"));
                }
                this.entityDatatableChecksWritePlatformService.runTheCheck((Long)newGroup.getId(), EntityTables.GROUP.getName(), StatusEnum.CREATE.getValue(), EntityTables.GROUP.getForeignKeyColumnNameOnDatatable(), null);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId((Long)groupOffice.getId()).withGroupId((Long)newGroup.getId()).withEntityId((Long)newGroup.getId()).setRollbackTransaction(rollbackTransaction).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleGroupDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve, groupingType);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleGroupDataIntegrityIssues(command, throwable, (Exception)((Object)dve), groupingType);
            return CommandProcessingResult.empty();
        }
    }

    private void generateAccountNumberIfRequired(Group newGroup) {
        if (newGroup.isAccountNumberRequiresAutoGeneration()) {
            EntityAccountType entityAccountType = null;
            AccountNumberFormat accountNumberFormat = null;
            if (newGroup.isCenter()) {
                entityAccountType = EntityAccountType.CENTER;
                accountNumberFormat = this.accountNumberFormatRepository.findByAccountType(entityAccountType);
                newGroup.updateAccountNo(this.accountNumberGenerator.generateCenterAccountNumber(newGroup, accountNumberFormat));
            } else {
                entityAccountType = EntityAccountType.GROUP;
                accountNumberFormat = this.accountNumberFormatRepository.findByAccountType(entityAccountType);
                newGroup.updateAccountNo(this.accountNumberGenerator.generateGroupAccountNumber(newGroup, accountNumberFormat));
            }
        }
    }

    @Transactional
    public CommandProcessingResult createCenter(JsonCommand command) {
        this.fromApiJsonDeserializer.validateForCreateCenter(command);
        Long centerId = null;
        CommandProcessingResult commandProcessingResult = this.createGroupingType(command, GroupTypes.CENTER, centerId);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new CentersCreateBusinessEvent(commandProcessingResult));
        return commandProcessingResult;
    }

    @Transactional
    public CommandProcessingResult createGroup(Long centerId, JsonCommand command) {
        if (centerId != null) {
            this.fromApiJsonDeserializer.validateForCreateCenterGroup(command);
        } else {
            this.fromApiJsonDeserializer.validateForCreateGroup(command);
        }
        CommandProcessingResult commandProcessingResult = this.createGroupingType(command, GroupTypes.GROUP, centerId);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new GroupsCreateBusinessEvent(commandProcessingResult));
        return commandProcessingResult;
    }

    @Transactional
    public CommandProcessingResult activateGroupOrCenter(Long groupId, JsonCommand command) {
        try {
            this.fromApiJsonDeserializer.validateForActivation(command, "group");
            AppUser currentUser = this.context.authenticatedUser();
            Group group = this.groupRepository.findOneWithNotFoundDetection(groupId);
            if (group.isGroup()) {
                this.validateGroupRulesBeforeActivation(group);
            }
            LocalDate activationDate = command.localDateValueOfParameterNamed("activationDate");
            this.validateOfficeOpeningDateisAfterGroupOrCenterOpeningDate(group.getOffice(), group.getGroupLevel(), activationDate);
            group.activate(currentUser, activationDate);
            this.groupRepository.saveAndFlush(group);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(group.officeId()).withGroupId(groupId).withEntityId(groupId).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleGroupDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve, GroupTypes.GROUP);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleGroupDataIntegrityIssues(command, throwable, (Exception)((Object)dve), GroupTypes.GROUP);
            return CommandProcessingResult.empty();
        }
    }

    private void validateGroupRulesBeforeActivation(Group group) {
        Integer maxClients;
        Integer minClients = this.configurationDomainService.retrieveMinAllowedClientsInGroup();
        boolean isGroupClientCountValid = group.isGroupsClientCountWithinMinMaxRange(minClients, maxClients = this.configurationDomainService.retrieveMaxAllowedClientsInGroup());
        if (!isGroupClientCountValid) {
            throw new GroupMemberCountNotInPermissibleRangeException((Long)group.getId(), minClients, maxClients);
        }
        this.entityDatatableChecksWritePlatformService.runTheCheck((Long)group.getId(), EntityTables.GROUP.getName(), StatusEnum.ACTIVATE.getValue(), EntityTables.GROUP.getForeignKeyColumnNameOnDatatable(), null);
    }

    public void validateGroupRulesBeforeClientAssociation(Group group) {
        Integer minClients = this.configurationDomainService.retrieveMinAllowedClientsInGroup();
        Integer maxClients = this.configurationDomainService.retrieveMaxAllowedClientsInGroup();
        boolean isGroupClientCountValid = group.isGroupsClientCountWithinMaxRange(maxClients);
        if (!isGroupClientCountValid) {
            throw new GroupMemberCountNotInPermissibleRangeException((Long)group.getId(), minClients, maxClients);
        }
    }

    @Transactional
    public CommandProcessingResult updateCenter(Long centerId, JsonCommand command) {
        this.fromApiJsonDeserializer.validateForUpdateCenter(command, centerId);
        return this.updateGroupingType(centerId, command, GroupTypes.CENTER);
    }

    @Transactional
    public CommandProcessingResult updateGroup(Long groupId, JsonCommand command) {
        this.fromApiJsonDeserializer.validateForUpdateGroup(command, groupId);
        return this.updateGroupingType(groupId, command, GroupTypes.GROUP);
    }

    private CommandProcessingResult updateGroupingType(Long groupId, JsonCommand command, GroupTypes groupingType) {
        try {
            GroupLevel groupLevel;
            this.context.authenticatedUser();
            Group groupForUpdate = this.groupRepository.findOneWithNotFoundDetection(groupId);
            Long officeId = groupForUpdate.officeId();
            Office groupOffice = groupForUpdate.getOffice();
            String groupHierarchy = groupOffice.getHierarchy();
            this.context.validateAccessRights(groupHierarchy);
            LocalDate activationDate = command.localDateValueOfParameterNamed("activationDate");
            this.validateOfficeOpeningDateisAfterGroupOrCenterOpeningDate(groupOffice, groupForUpdate.getGroupLevel(), activationDate);
            Map actualChanges = groupForUpdate.update(command);
            if (actualChanges.containsKey("staffId")) {
                Long newValue = command.longValueOfParameterNamed("staffId");
                Staff newStaff = null;
                if (newValue != null) {
                    newStaff = this.staffRepository.findByOfficeHierarchyWithNotFoundDetection(newValue, groupHierarchy);
                }
                groupForUpdate.updateStaff(newStaff);
            }
            if (!(groupLevel = (GroupLevel)this.groupLevelRepository.findById((Object)((Long)groupForUpdate.getGroupLevel().getId())).orElse(null)).isSuperParent()) {
                Long parentId = null;
                Group presentParentGroup = groupForUpdate.getParent();
                if (presentParentGroup != null) {
                    parentId = (Long)presentParentGroup.getId();
                }
                if (command.isChangeInLongParameterNamed("centerId", parentId)) {
                    Long newValue = command.longValueOfParameterNamed("centerId");
                    actualChanges.put("centerId", newValue);
                    Group newParentGroup = null;
                    if (newValue != null) {
                        newParentGroup = this.groupRepository.findOneWithNotFoundDetection(newValue);
                        if (!newParentGroup.isOfficeIdentifiedBy(officeId)) {
                            String errorMessage = "Group and parent group must have the same office";
                            throw new InvalidOfficeException("group", "attach.to.parent.group", "Group and parent group must have the same office", new Object[0]);
                        }
                        if (!groupForUpdate.getGroupLevel().isIdentifiedByParentId((Long)newParentGroup.getGroupLevel().getId())) {
                            String errorMessage = "Parent group's level is  not equal to child level's parent level ";
                            throw new InvalidGroupLevelException("add", "invalid.level", "Parent group's level is  not equal to child level's parent level ", new Object[0]);
                        }
                    }
                    groupForUpdate.setParent(newParentGroup);
                    groupForUpdate.generateHierarchy();
                }
            }
            this.groupRepository.saveAndFlush(groupForUpdate);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(groupForUpdate.officeId()).withGroupId((Long)groupForUpdate.getId()).withEntityId((Long)groupForUpdate.getId()).with(actualChanges).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleGroupDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve, groupingType);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleGroupDataIntegrityIssues(command, throwable, (Exception)((Object)dve), groupingType);
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult unassignGroupOrCenterStaff(Long grouptId, JsonCommand command) {
        this.context.authenticatedUser();
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(9);
        this.fromApiJsonDeserializer.validateForUnassignStaff(command.json());
        Group groupForUpdate = this.groupRepository.findOneWithNotFoundDetection(grouptId);
        Staff presentStaff = groupForUpdate.getStaff();
        Long presentStaffId = null;
        if (presentStaff == null) {
            throw new GroupHasNoStaffException(grouptId);
        }
        presentStaffId = (Long)presentStaff.getId();
        String staffIdParamName = "staffId";
        if (!command.isChangeInLongParameterNamed("staffId", presentStaffId)) {
            groupForUpdate.unassignStaff();
        }
        this.groupRepository.saveAndFlush(groupForUpdate);
        actualChanges.put("staffId", null);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId((Long)groupForUpdate.getId()).withGroupId(groupForUpdate.officeId()).withEntityId((Long)groupForUpdate.getId()).with(actualChanges).build();
    }

    public CommandProcessingResult assignGroupOrCenterStaff(Long groupId, JsonCommand command) {
        this.context.authenticatedUser();
        LinkedHashMap<String, Long> actualChanges = new LinkedHashMap<String, Long>(5);
        this.fromApiJsonDeserializer.validateForAssignStaff(command.json());
        Group groupForUpdate = this.groupRepository.findOneWithNotFoundDetection(groupId);
        Staff staff = null;
        Long staffId = command.longValueOfParameterNamed("staffId");
        boolean inheritStaffForClientAccounts = command.booleanPrimitiveValueOfParameterNamed("inheritStaffForClientAccounts");
        staff = this.staffRepository.findByOfficeHierarchyWithNotFoundDetection(staffId, groupForUpdate.getOffice().getHierarchy());
        groupForUpdate.updateStaff(staff);
        if (inheritStaffForClientAccounts) {
            LocalDate loanOfficerReassignmentDate = DateUtils.getBusinessLocalDate();
            Set clients = groupForUpdate.getClientMembers();
            if (clients != null) {
                for (Client client : clients) {
                    client.updateStaff(staff);
                    if (this.loanRepositoryWrapper.doNonClosedLoanAccountsExistForClient((Long)client.getId())) {
                        for (Loan loan : this.loanRepositoryWrapper.findLoanByClientId((Long)client.getId())) {
                            if (!loan.isDisbursed() || loan.isClosed()) continue;
                            this.loanOfficerService.reassignLoanOfficer(loan, staff, loanOfficerReassignmentDate);
                        }
                    }
                    if (!this.savingsAccountRepositoryWrapper.doNonClosedSavingAccountsExistForClient((Long)client.getId())) continue;
                    for (SavingsAccount savingsAccount : this.savingsAccountRepositoryWrapper.findSavingAccountByClientId((Long)client.getId())) {
                        if (savingsAccount.isClosed()) continue;
                        savingsAccount.reassignSavingsOfficer(staff, loanOfficerReassignmentDate);
                    }
                }
            }
        }
        this.groupRepository.saveAndFlush(groupForUpdate);
        actualChanges.put("staffId", staffId);
        return new CommandProcessingResultBuilder().withOfficeId(groupForUpdate.officeId()).withEntityId((Long)groupForUpdate.getId()).withGroupId(groupId).with(actualChanges).build();
    }

    @Transactional
    public CommandProcessingResult deleteGroup(Long groupId) {
        try {
            Group groupForDelete = this.groupRepository.findOneWithNotFoundDetection(groupId);
            if (groupForDelete.isNotPending()) {
                throw new GroupMustBePendingToBeDeletedException(groupId);
            }
            List relatedNotes = this.noteRepository.findByGroup(groupForDelete);
            this.noteRepository.deleteAllInBatch((Iterable)relatedNotes);
            this.groupRepository.delete(groupForDelete);
            this.groupRepository.flush();
            return new CommandProcessingResultBuilder().withOfficeId((Long)groupForDelete.getId()).withGroupId(groupForDelete.officeId()).withEntityId((Long)groupForDelete.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            log.error("Error occured.", throwable);
            throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.group.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
        }
    }

    public CommandProcessingResult closeGroup(Long groupId, JsonCommand command) {
        this.fromApiJsonDeserializer.validateForGroupClose(command);
        Group group = this.groupRepository.findOneWithNotFoundDetection(groupId);
        LocalDate closureDate = command.localDateValueOfParameterNamed("closureDate");
        Long closureReasonId = command.longValueOfParameterNamed("closureReasonId");
        AppUser currentUser = this.context.authenticatedUser();
        CodeValue closureReason = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("GroupClosureReason", closureReasonId);
        if (group.hasActiveClients()) {
            String errorMessage = group.getGroupLevel().getLevelName() + " cannot be closed because of active clients associated with it.";
            throw new InvalidGroupStateTransitionException(group.getGroupLevel().getLevelName(), "close", "active.clients.exist", errorMessage, new Object[0]);
        }
        this.validateLoansAndSavingsForGroupOrCenterClose(group, closureDate);
        this.entityDatatableChecksWritePlatformService.runTheCheck(groupId, EntityTables.GROUP.getName(), StatusEnum.CLOSE.getValue(), EntityTables.GROUP.getForeignKeyColumnNameOnDatatable(), null);
        group.close(currentUser, closureReason, closureDate);
        this.groupRepository.saveAndFlush(group);
        return new CommandProcessingResultBuilder().withGroupId(groupId).withEntityId(groupId).build();
    }

    private void validateLoansAndSavingsForGroupOrCenterClose(Group groupOrCenter, LocalDate closureDate) {
        List groupLoans = this.loanRepositoryWrapper.findByGroupId((Long)groupOrCenter.getId());
        for (Loan loan : groupLoans) {
            LoanStatusMapper loanStatus = new LoanStatusMapper(loan.getStatus().getValue());
            if (loanStatus.isOpen()) {
                String errorMessage = groupOrCenter.getGroupLevel().getLevelName() + " cannot be closed because of non-closed loans.";
                throw new InvalidGroupStateTransitionException(groupOrCenter.getGroupLevel().getLevelName(), "close", "loan.not.closed", errorMessage, new Object[0]);
            }
            if (loanStatus.isClosed() && DateUtils.isAfter((LocalDate)loan.getClosedOnDate(), (LocalDate)closureDate)) {
                String errorMessage = groupOrCenter.getGroupLevel().getLevelName() + "closureDate cannot be before the loan closedOnDate.";
                throw new InvalidGroupStateTransitionException(groupOrCenter.getGroupLevel().getLevelName(), "close", "date.cannot.before.loan.closed.date", errorMessage, new Object[]{closureDate, loan.getClosedOnDate()});
            }
            if (loanStatus.isPendingApproval()) {
                String errorMessage = groupOrCenter.getGroupLevel().getLevelName() + " cannot be closed because of non-closed loans.";
                throw new InvalidGroupStateTransitionException(groupOrCenter.getGroupLevel().getLevelName(), "close", "loan.not.closed", errorMessage, new Object[0]);
            }
            if (!loanStatus.isAwaitingDisbursal()) continue;
            String errorMessage = "Group cannot be closed because of non-closed loans.";
            throw new InvalidGroupStateTransitionException(groupOrCenter.getGroupLevel().getLevelName(), "close", "loan.not.closed", "Group cannot be closed because of non-closed loans.", new Object[0]);
        }
        List groupSavingAccounts = this.savingsAccountRepositoryWrapper.findByGroupId((Long)groupOrCenter.getId());
        for (SavingsAccount saving : groupSavingAccounts) {
            if (saving.isActive() || saving.isSubmittedAndPendingApproval() || saving.isApproved()) {
                String errorMessage = groupOrCenter.getGroupLevel().getLevelName() + " cannot be closed with active savings accounts associated.";
                throw new InvalidGroupStateTransitionException(groupOrCenter.getGroupLevel().getLevelName(), "close", "savings.account.not.closed", errorMessage, new Object[0]);
            }
            if (!saving.isClosed() || !DateUtils.isAfter((LocalDate)saving.getClosedOnDate(), (LocalDate)closureDate)) continue;
            String errorMessage = groupOrCenter.getGroupLevel().getLevelName() + " closureDate cannot be before the loan closedOnDate.";
            throw new InvalidGroupStateTransitionException(groupOrCenter.getGroupLevel().getLevelName(), "close", "date.cannot.before.loan.closed.date", errorMessage, new Object[]{closureDate, saving.getClosedOnDate()});
        }
    }

    public CommandProcessingResult closeCenter(Long centerId, JsonCommand command) {
        this.fromApiJsonDeserializer.validateForCenterClose(command);
        Group center = this.groupRepository.findOneWithNotFoundDetection(centerId);
        LocalDate closureDate = command.localDateValueOfParameterNamed("closureDate");
        Long closureReasonId = command.longValueOfParameterNamed("closureReasonId");
        CodeValue closureReason = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("CenterClosureReason", closureReasonId);
        AppUser currentUser = this.context.authenticatedUser();
        if (center.hasActiveGroups()) {
            String errorMessage = center.getGroupLevel().getLevelName() + " cannot be closed because of active groups associated with it.";
            throw new InvalidGroupStateTransitionException(center.getGroupLevel().getLevelName(), "close", "active.groups.exist", errorMessage, new Object[0]);
        }
        this.validateLoansAndSavingsForGroupOrCenterClose(center, closureDate);
        this.entityDatatableChecksWritePlatformService.runTheCheck(centerId, EntityTables.GROUP.getName(), StatusEnum.ACTIVATE.getValue(), EntityTables.GROUP.getForeignKeyColumnNameOnDatatable(), null);
        center.close(currentUser, closureReason, closureDate);
        this.groupRepository.saveAndFlush(center);
        return new CommandProcessingResultBuilder().withEntityId(centerId).build();
    }

    private Set<Client> assembleSetOfClients(Long groupOfficeId, JsonCommand command) {
        HashSet<Client> clientMembers = new HashSet<Client>();
        Object[] clientMembersArray = command.arrayValueOfParameterNamed("clientMembers");
        if (!ObjectUtils.isEmpty((Object[])clientMembersArray)) {
            for (Object clientId : clientMembersArray) {
                Long id = Long.valueOf((String)clientId);
                Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(id);
                if (!client.isOfficeIdentifiedBy(groupOfficeId)) {
                    String errorMessage = "Client with identifier " + (String)clientId + " must have the same office as group.";
                    throw new InvalidOfficeException("client", "attach.to.group", errorMessage, new Object[]{clientId, groupOfficeId});
                }
                clientMembers.add(client);
            }
        }
        return clientMembers;
    }

    private Set<Group> assembleSetOfChildGroups(Long officeId, JsonCommand command) {
        HashSet<Group> childGroups = new HashSet<Group>();
        Object[] childGroupsArray = command.arrayValueOfParameterNamed("groupMembers");
        if (!ObjectUtils.isEmpty((Object[])childGroupsArray)) {
            for (Object groupId : childGroupsArray) {
                Long id = Long.valueOf((String)groupId);
                Group group = this.groupRepository.findOneWithNotFoundDetection(id);
                if (!group.isOfficeIdentifiedBy(officeId)) {
                    String errorMessage = "Group and child groups must have the same office.";
                    throw new InvalidOfficeException("group", "attach.to.parent.group", "Group and child groups must have the same office.", new Object[0]);
                }
                childGroups.add(group);
            }
        }
        return childGroups;
    }

    private void handleGroupDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve, GroupTypes groupLevel) {
        String levelName = "Invalid";
        switch (1.$SwitchMap$org$apache$fineract$portfolio$group$domain$GroupTypes[groupLevel.ordinal()]) {
            case 1: {
                levelName = "Center";
                break;
            }
            case 2: {
                levelName = "Group";
                break;
            }
        }
        String errorMessageForUser = null;
        String errorMessageForMachine = null;
        if (realCause.getMessage().contains("'external_id'")) {
            String externalId = command.stringValueOfParameterNamed("externalId");
            errorMessageForUser = levelName + " with externalId `" + externalId + "` already exists.";
            errorMessageForMachine = "error.msg." + levelName.toLowerCase() + ".duplicate.externalId";
            throw new PlatformDataIntegrityException(errorMessageForMachine, errorMessageForUser, "externalId", new Object[]{externalId});
        }
        if (realCause.getMessage().contains("'name'")) {
            String name = command.stringValueOfParameterNamed("name");
            errorMessageForUser = levelName + " with name `" + name + "` already exists.";
            errorMessageForMachine = "error.msg." + levelName.toLowerCase() + ".duplicate.name";
            throw new PlatformDataIntegrityException(errorMessageForMachine, errorMessageForUser, "name", new Object[]{name});
        }
        log.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.group.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
    }

    public CommandProcessingResult associateClientsToGroup(Long groupId, JsonCommand command) {
        this.fromApiJsonDeserializer.validateForAssociateClients(command.json());
        Group groupForUpdate = this.groupRepository.findOneWithNotFoundDetection(groupId);
        Set clientMembers = this.assembleSetOfClients(groupForUpdate.officeId(), command);
        HashMap<String, List> actualChanges = new HashMap<String, List>();
        List changes = groupForUpdate.associateClients(clientMembers);
        if (groupForUpdate.isGroup()) {
            this.validateGroupRulesBeforeClientAssociation(groupForUpdate);
        }
        if (!changes.isEmpty()) {
            actualChanges.put("clientMembers", changes);
        }
        this.groupRepository.saveAndFlush(groupForUpdate);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(groupForUpdate.officeId()).withGroupId((Long)groupForUpdate.getId()).withEntityId((Long)groupForUpdate.getId()).with(actualChanges).build();
    }

    @Transactional
    public CommandProcessingResult disassociateClientsFromGroup(Long groupId, JsonCommand command) {
        this.fromApiJsonDeserializer.validateForDisassociateClients(command.json());
        Group groupForUpdate = this.groupRepository.findOneWithNotFoundDetection(groupId);
        Set clientMembers = this.assembleSetOfClients(groupForUpdate.officeId(), command);
        this.checkForActiveJLGLoans((Long)groupForUpdate.getId(), clientMembers);
        this.validateForJLGSavings((Long)groupForUpdate.getId(), clientMembers);
        HashMap<String, List> actualChanges = new HashMap<String, List>();
        List changes = groupForUpdate.disassociateClients(clientMembers);
        if (!changes.isEmpty()) {
            actualChanges.put("clientMembers", changes);
        }
        this.groupRepository.saveAndFlush(groupForUpdate);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(groupForUpdate.officeId()).withGroupId((Long)groupForUpdate.getId()).withEntityId((Long)groupForUpdate.getId()).with(actualChanges).build();
    }

    @Transactional
    public CommandProcessingResult associateGroupsToCenter(Long centerId, JsonCommand command) {
        this.fromApiJsonDeserializer.validateForAssociateGroups(command.json());
        Group centerForUpdate = this.groupRepository.findOneWithNotFoundDetection(centerId);
        Set groupMembers = this.assembleSetOfChildGroups(centerForUpdate.officeId(), command);
        this.checkGroupMembersMeetingSyncWithCenterMeeting(centerId, groupMembers);
        HashMap<String, List> actualChanges = new HashMap<String, List>();
        List changes = centerForUpdate.associateGroups(groupMembers);
        if (!changes.isEmpty()) {
            actualChanges.put("groupMembers", changes);
        }
        this.groupRepository.saveAndFlush(centerForUpdate);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(centerForUpdate.officeId()).withGroupId((Long)centerForUpdate.getId()).withEntityId((Long)centerForUpdate.getId()).with(actualChanges).build();
    }

    @Transactional
    public CommandProcessingResult disassociateGroupsToCenter(Long centerId, JsonCommand command) {
        this.fromApiJsonDeserializer.validateForDisassociateGroups(command.json());
        Group centerForUpdate = this.groupRepository.findOneWithNotFoundDetection(centerId);
        Set groupMembers = this.assembleSetOfChildGroups(centerForUpdate.officeId(), command);
        HashMap<String, List> actualChanges = new HashMap<String, List>();
        List changes = centerForUpdate.disassociateGroups(groupMembers);
        if (!changes.isEmpty()) {
            actualChanges.put("clientMembers", changes);
        }
        this.groupRepository.saveAndFlush(centerForUpdate);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(centerForUpdate.officeId()).withGroupId((Long)centerForUpdate.getId()).withEntityId((Long)centerForUpdate.getId()).with(actualChanges).build();
    }

    @Transactional
    private void checkForActiveJLGLoans(Long groupId, Set<Client> clientMembers) {
        for (Client client : clientMembers) {
            Collection loans = this.loanRepositoryWrapper.findActiveLoansByLoanIdAndGroupId((Long)client.getId(), groupId);
            if (CollectionUtils.isEmpty((Collection)loans)) continue;
            String defaultUserMessage = "Client with identifier " + String.valueOf(client.getId()) + " cannot be disassociated it has group loans.";
            throw new GroupAccountExistsException("disassociate", "client.has.group.loan", defaultUserMessage, new Object[]{client.getId(), groupId});
        }
    }

    @Transactional
    private void validateForJLGSavings(Long groupId, Set<Client> clientMembers) {
        for (Client client : clientMembers) {
            List savings = this.savingsAccountRepositoryWrapper.findByClientIdAndGroupId((Long)client.getId(), groupId);
            if (CollectionUtils.isEmpty((Collection)savings)) continue;
            String defaultUserMessage = "Client with identifier " + String.valueOf(client.getId()) + " cannot be disassociated it has group savings.";
            throw new GroupAccountExistsException("disassociate", "client.has.group.saving", defaultUserMessage, new Object[]{client.getId(), groupId});
        }
    }

    public void validateOfficeOpeningDateisAfterGroupOrCenterOpeningDate(Office groupOffice, GroupLevel groupLevel, LocalDate activationDate) {
        if (activationDate != null && DateUtils.isAfter((LocalDate)groupOffice.getOpeningLocalDate(), (LocalDate)activationDate)) {
            String levelName = groupLevel.getLevelName();
            String errorMessage = levelName + " activation date should be greater than or equal to the parent Office's creation date " + activationDate.toString();
            throw new InvalidGroupStateTransitionException(levelName.toLowerCase(), "activate.date", "cannot.be.before.office.activation.date", errorMessage, new Object[]{activationDate, groupOffice.getOpeningLocalDate()});
        }
    }

    private void checkGroupMembersMeetingSyncWithCenterMeeting(Long centerId, Set<Group> groupMembers) {
        Calendar ceneterCalendar = null;
        CalendarInstance parentCalendarInstance = this.calendarInstanceRepository.findByEntityIdAndEntityTypeIdAndCalendarTypeId(centerId, CalendarEntityType.CENTERS.getValue(), CalendarType.COLLECTION.getValue());
        if (parentCalendarInstance != null) {
            ceneterCalendar = parentCalendarInstance.getCalendar();
        }
        for (Group group : groupMembers) {
            Calendar groupCalendar = null;
            CalendarInstance groupCalendarInstance = this.calendarInstanceRepository.findByEntityIdAndEntityTypeIdAndCalendarTypeId((Long)group.getId(), CalendarEntityType.GROUPS.getValue(), CalendarType.COLLECTION.getValue());
            if (groupCalendarInstance != null) {
                groupCalendar = groupCalendarInstance.getCalendar();
            }
            if (ceneterCalendar == null && groupCalendar != null) {
                throw new GeneralPlatformDomainRuleException("error.msg.center.associating.group.not.allowed.with.meeting.attached.to.group", "Group with id " + String.valueOf(group.getId()) + " is already associated with meeting", new Object[]{group.getId()});
            }
            if (ceneterCalendar == null || groupCalendar == null || ceneterCalendar.getRecurrence().equalsIgnoreCase(groupCalendar.getRecurrence())) continue;
            throw new GeneralPlatformDomainRuleException("error.msg.center.associating.group.not.allowed.with.different.meeting", "Group with id " + String.valueOf(group.getId()) + " meeting recurrence doesnot matched with center meeting recurrence", new Object[]{group.getId()});
        }
    }

    @Generated
    public GroupingTypesWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, GroupRepositoryWrapper groupRepository, ClientRepositoryWrapper clientRepositoryWrapper, OfficeRepositoryWrapper officeRepositoryWrapper, StaffRepositoryWrapper staffRepository, NoteRepository noteRepository, GroupLevelRepository groupLevelRepository, GroupingTypesDataValidator fromApiJsonDeserializer, LoanRepositoryWrapper loanRepositoryWrapper, CodeValueRepositoryWrapper codeValueRepository, CommandProcessingService commandProcessingService, CalendarInstanceRepository calendarInstanceRepository, ConfigurationDomainService configurationDomainService, SavingsAccountRepositoryWrapper savingsAccountRepositoryWrapper, AccountNumberFormatRepositoryWrapper accountNumberFormatRepository, AccountNumberGenerator accountNumberGenerator, EntityDatatableChecksWritePlatformService entityDatatableChecksWritePlatformService, BusinessEventNotifierService businessEventNotifierService, LoanOfficerService loanOfficerService) {
        this.context = context;
        this.groupRepository = groupRepository;
        this.clientRepositoryWrapper = clientRepositoryWrapper;
        this.officeRepositoryWrapper = officeRepositoryWrapper;
        this.staffRepository = staffRepository;
        this.noteRepository = noteRepository;
        this.groupLevelRepository = groupLevelRepository;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.codeValueRepository = codeValueRepository;
        this.commandProcessingService = commandProcessingService;
        this.calendarInstanceRepository = calendarInstanceRepository;
        this.configurationDomainService = configurationDomainService;
        this.savingsAccountRepositoryWrapper = savingsAccountRepositoryWrapper;
        this.accountNumberFormatRepository = accountNumberFormatRepository;
        this.accountNumberGenerator = accountNumberGenerator;
        this.entityDatatableChecksWritePlatformService = entityDatatableChecksWritePlatformService;
        this.businessEventNotifierService = businessEventNotifierService;
        this.loanOfficerService = loanOfficerService;
    }
}

