/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.sms.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.DateFormat;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.sms.data.SmsData;
import org.apache.fineract.infrastructure.sms.data.request.SmsCreationRequest;
import org.apache.fineract.infrastructure.sms.data.request.SmsUpdateRequest;
import org.apache.fineract.infrastructure.sms.param.SmsRequestParam;
import org.apache.fineract.infrastructure.sms.service.SmsReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/sms")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
@Tag(name="SMS", description="")
public class SmsApiResource {
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "SMS";
    private final PlatformSecurityContext context;
    private final SmsReadPlatformService readPlatformService;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final DefaultToApiJsonSerializer<String> apiJsonSerializer;

    @GET
    public List<SmsData> retrieveAll() {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.readPlatformService.retrieveAll();
    }

    @POST
    public CommandProcessingResult create(SmsCreationRequest smsCreationRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createSms().withJson(this.apiJsonSerializer.serialize((Object)smsCreationRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @GET
    @Path(value="{resourceId}")
    public SmsData retrieveOne(@PathParam(value="resourceId") Long resourceId) {
        return this.readPlatformService.retrieveOne(resourceId);
    }

    @GET
    @Path(value="{campaignId}/messageByStatus")
    public Page<SmsData> retrieveAllSmsByStatus(@PathParam(value="campaignId") Long campaignId, @BeanParam SmsRequestParam smsRequestParam) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        SearchParameters searchParameters = SearchParameters.builder().limit(smsRequestParam.limit()).offset(smsRequestParam.offset()).orderBy(smsRequestParam.orderBy()).sortOrder(smsRequestParam.sortOrder()).build();
        DateFormat dateFormat = Optional.ofNullable(smsRequestParam.rawDateFormat()).map(DateFormat::new).orElse(null);
        LocalDate fromDate = Optional.ofNullable(smsRequestParam.fromDate()).map(fromDateParam -> fromDateParam.getDate("fromDate", dateFormat, smsRequestParam.locale())).orElse(null);
        LocalDate toDate = Optional.ofNullable(smsRequestParam.toDate()).map(toDateParam -> toDateParam.getDate("toDate", dateFormat, smsRequestParam.locale())).orElse(null);
        return this.readPlatformService.retrieveSmsByStatus(campaignId, searchParameters, Integer.valueOf(smsRequestParam.status().intValue()), fromDate, toDate);
    }

    @PUT
    @Path(value="{resourceId}")
    public CommandProcessingResult update(@PathParam(value="resourceId") Long resourceId, SmsUpdateRequest smsUpdateRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateSms(resourceId).withJson(this.apiJsonSerializer.serialize((Object)smsUpdateRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @DELETE
    @Path(value="{resourceId}")
    public CommandProcessingResult delete(@PathParam(value="resourceId") Long resourceId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteSms(resourceId).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @Generated
    public SmsApiResource(PlatformSecurityContext context, SmsReadPlatformService readPlatformService, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, DefaultToApiJsonSerializer<String> apiJsonSerializer) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.apiJsonSerializer = apiJsonSerializer;
    }
}

