/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.filter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.fineract.infrastructure.businessdate.service.BusinessDateReadPlatformService;
import org.apache.fineract.infrastructure.cache.domain.CacheType;
import org.apache.fineract.infrastructure.cache.service.CacheWritePlatformService;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.domain.FineractPlatformTenant;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.security.data.PlatformRequestLog;
import org.apache.fineract.infrastructure.security.exception.InvalidTenantIdentifierException;
import org.apache.fineract.infrastructure.security.service.BasicAuthTenantDetailsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class TenantAwareTenantIdentifierFilter
extends GenericFilterBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantAwareTenantIdentifierFilter.class);
    private static final AtomicBoolean FIRST_PROCESSED_REQUEST = new AtomicBoolean();
    private final BasicAuthTenantDetailsService basicAuthTenantDetailsService;
    private final ToApiJsonSerializer<PlatformRequestLog> toApiJsonSerializer;
    private final ConfigurationDomainService configurationDomainService;
    private final CacheWritePlatformService cacheWritePlatformService;
    private final BusinessDateReadPlatformService businessDateReadPlatformService;
    private static final String TENANT_ID_REQUEST_HEADER = "Fineract-Platform-TenantId";
    private static final boolean EXCEPTION_IF_HEADER_MISSING = true;
    private static final String API_URI = "/api/v1/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        StopWatch task = new StopWatch();
        task.start();
        try {
            ThreadLocalContextUtil.reset();
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS");
            String reqHead = request.getHeader("Access-Control-Request-Headers");
            if (null != reqHead && !reqHead.isEmpty()) {
                response.setHeader("Access-Control-Allow-Headers", reqHead);
            }
            if (!"OPTIONS".equalsIgnoreCase(request.getMethod())) {
                String tenantIdentifier = request.getHeader(TENANT_ID_REQUEST_HEADER);
                if (StringUtils.isBlank((CharSequence)tenantIdentifier)) {
                    tenantIdentifier = request.getParameter("tenantIdentifier");
                }
                if (tenantIdentifier == null) {
                    throw new InvalidTenantIdentifierException("No tenant identifier found: Add request header of 'Fineract-Platform-TenantId' or add the parameter 'tenantIdentifier' to query string of request URL.");
                }
                String pathInfo = request.getRequestURI();
                boolean isReportRequest = false;
                if (pathInfo != null && pathInfo.contains("report")) {
                    isReportRequest = true;
                }
                FineractPlatformTenant tenant = this.basicAuthTenantDetailsService.loadTenantById(tenantIdentifier, isReportRequest);
                ThreadLocalContextUtil.setTenant((FineractPlatformTenant)tenant);
                HashMap businessDates = this.businessDateReadPlatformService.getBusinessDates();
                ThreadLocalContextUtil.setBusinessDates((HashMap)businessDates);
                String authToken = request.getHeader("Authorization");
                if (authToken != null && authToken.startsWith("bearer ")) {
                    ThreadLocalContextUtil.setAuthToken((String)authToken.replaceFirst("bearer ", ""));
                }
                if (!FIRST_PROCESSED_REQUEST.get()) {
                    String baseUrl = request.getRequestURL().toString().replace(request.getRequestURI(), request.getContextPath() + API_URI);
                    System.setProperty("baseUrl", baseUrl);
                    boolean ehcacheEnabled = this.configurationDomainService.isEhcacheEnabled();
                    if (ehcacheEnabled) {
                        this.cacheWritePlatformService.switchToCache(CacheType.SINGLE_NODE);
                    } else {
                        this.cacheWritePlatformService.switchToCache(CacheType.NO_CACHE);
                    }
                    FIRST_PROCESSED_REQUEST.set(true);
                }
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (InvalidTenantIdentifierException e) {
            SecurityContextHolder.getContext().setAuthentication(null);
            response.addHeader("WWW-Authenticate", "Basic realm=\"Fineract Platform API\"");
            response.sendError(400, e.getMessage());
        }
        finally {
            ThreadLocalContextUtil.reset();
            task.stop();
            PlatformRequestLog logRequest = PlatformRequestLog.from((StopWatch)task, (HttpServletRequest)request);
            log.debug("{}", (Object)this.toApiJsonSerializer.serialize((Object)logRequest));
        }
    }

    @Generated
    public TenantAwareTenantIdentifierFilter(BasicAuthTenantDetailsService basicAuthTenantDetailsService, ToApiJsonSerializer<PlatformRequestLog> toApiJsonSerializer, ConfigurationDomainService configurationDomainService, CacheWritePlatformService cacheWritePlatformService, BusinessDateReadPlatformService businessDateReadPlatformService) {
        this.basicAuthTenantDetailsService = basicAuthTenantDetailsService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.configurationDomainService = configurationDomainService;
        this.cacheWritePlatformService = cacheWritePlatformService;
        this.businessDateReadPlatformService = businessDateReadPlatformService;
    }
}

