/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.fineract.infrastructure.security.data.FineractJwtAuthenticationToken;
import org.apache.fineract.infrastructure.security.filter.TwoFactorAuthenticationFilter;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.jwt.Jwt;

public class InsecureTwoFactorAuthenticationFilter
extends TwoFactorAuthenticationFilter {
    public InsecureTwoFactorAuthenticationFilter() {
        super(null);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = null;
        if (context != null) {
            authentication = context.getAuthentication();
        }
        if (authentication != null && authentication.isAuthenticated()) {
            ArrayList<SimpleGrantedAuthority> updatedAuthorities = new ArrayList<SimpleGrantedAuthority>(authentication.getAuthorities());
            updatedAuthorities.add(new SimpleGrantedAuthority("TWOFACTOR_AUTHENTICATED"));
            if (authentication instanceof UsernamePasswordAuthenticationToken) {
                UsernamePasswordAuthenticationToken updatedAuthentication = new UsernamePasswordAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials(), updatedAuthorities);
                context.setAuthentication((Authentication)updatedAuthentication);
            } else if (authentication instanceof FineractJwtAuthenticationToken) {
                FineractJwtAuthenticationToken fineractJwtAuthenticationToken = (FineractJwtAuthenticationToken)authentication;
                FineractJwtAuthenticationToken updatedAuthentication = new FineractJwtAuthenticationToken((Jwt)fineractJwtAuthenticationToken.getToken(), updatedAuthorities, (UserDetails)authentication.getPrincipal());
                context.setAuthentication((Authentication)updatedAuthentication);
            }
        }
        chain.doFilter(req, res);
    }
}

