/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service;

import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.IdTypeResolver;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.jobs.data.JobDetailData;
import org.apache.fineract.infrastructure.jobs.data.JobDetailHistoryData;
import org.apache.fineract.infrastructure.jobs.domain.ScheduledJobDetailRepository;
import org.apache.fineract.infrastructure.jobs.exception.JobNotFoundException;
import org.apache.fineract.infrastructure.jobs.exception.OperationNotAllowedException;
import org.apache.fineract.infrastructure.jobs.service.SchedulerJobRunnerReadService;
import org.apache.fineract.infrastructure.jobs.service.SchedulerJobRunnerReadServiceImpl;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SchedulerJobRunnerReadServiceImpl
implements SchedulerJobRunnerReadService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulerJobRunnerReadServiceImpl.class);
    private final JdbcTemplate jdbcTemplate;
    private final ColumnValidator columnValidator;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final ScheduledJobDetailRepository jobDetailRepository;
    private final PaginationHelper paginationHelper;

    @Autowired
    public SchedulerJobRunnerReadServiceImpl(JdbcTemplate jdbcTemplate, ColumnValidator columnValidator, DatabaseSpecificSQLGenerator sqlGenerator, ScheduledJobDetailRepository jobDetailRepository, PaginationHelper paginationHelper) {
        this.jdbcTemplate = jdbcTemplate;
        this.columnValidator = columnValidator;
        this.sqlGenerator = sqlGenerator;
        this.jobDetailRepository = jobDetailRepository;
        this.paginationHelper = paginationHelper;
    }

    public List<JobDetailData> findAllJobDetails() {
        return this.jobDetailRepository.getAllData();
    }

    public JobDetailData retrieveOne(@NotNull IdTypeResolver.IdType idType, String identifier) {
        JobDetailData jobDetail;
        switch (1.$SwitchMap$org$apache$fineract$infrastructure$core$api$IdTypeResolver$IdType[idType.ordinal()]) {
            case 1: {
                JobDetailData jobDetailData = this.jobDetailRepository.getDataById(Long.valueOf(identifier));
                break;
            }
            case 2: {
                JobDetailData jobDetailData = this.jobDetailRepository.getDataByShortName(identifier);
                break;
            }
            default: {
                JobDetailData jobDetailData = jobDetail = null;
            }
        }
        if (jobDetail == null) {
            throw new JobNotFoundException(idType, identifier);
        }
        return jobDetail;
    }

    public Page<JobDetailHistoryData> retrieveJobHistory(@NotNull IdTypeResolver.IdType idType, String identifier, SearchParameters searchParameters) {
        if (!this.isJobExist(idType, identifier)) {
            throw new JobNotFoundException(idType, identifier);
        }
        JobHistoryMapper jobHistoryMapper = new JobHistoryMapper(this.sqlGenerator);
        StringBuilder sqlBuilder = new StringBuilder("select " + this.sqlGenerator.calcFoundRows() + " ").append(jobHistoryMapper.schema()).append(" where job.");
        Object idParam = switch (1.$SwitchMap$org$apache$fineract$infrastructure$core$api$IdTypeResolver$IdType[idType.ordinal()]) {
            case 1 -> {
                sqlBuilder.append("id");
                yield Long.valueOf(identifier);
            }
            case 2 -> {
                sqlBuilder.append("short_name");
                yield identifier;
            }
            default -> throw new JobNotFoundException(idType, identifier);
        };
        sqlBuilder.append(" = ?");
        if (searchParameters.hasOrderBy()) {
            sqlBuilder.append(" order by ").append(searchParameters.getOrderBy());
            this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getOrderBy()});
            if (searchParameters.hasSortOrder()) {
                sqlBuilder.append(' ').append(searchParameters.getSortOrder());
                this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getSortOrder()});
            }
        }
        if (searchParameters.hasLimit()) {
            sqlBuilder.append(" ");
            if (searchParameters.hasOffset()) {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
            } else {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
            }
        }
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), new Object[]{idParam}, (RowMapper)jobHistoryMapper);
    }

    @NotNull
    public Long retrieveId(@NotNull IdTypeResolver.IdType idType, String identifier) {
        return switch (1.$SwitchMap$org$apache$fineract$infrastructure$core$api$IdTypeResolver$IdType[idType.ordinal()]) {
            case 1 -> Long.valueOf(identifier);
            case 2 -> (Long)this.jobDetailRepository.findIdByShortName(identifier).orElseThrow(() -> new JobNotFoundException(idType, identifier));
            default -> throw new JobNotFoundException(idType, identifier);
        };
    }

    public boolean isUpdatesAllowed() {
        String sql = "select job.display_name from job job where job.currently_running=true and job.updates_allowed=false";
        List names = this.jdbcTemplate.queryForList("select job.display_name from job job where job.currently_running=true and job.updates_allowed=false", String.class);
        if (names.size() > 0) {
            String listVals = names.toString();
            String jobNames = listVals.substring(listVals.indexOf("[") + 1, listVals.indexOf("]"));
            throw new OperationNotAllowedException(jobNames);
        }
        return true;
    }

    private boolean isJobExist(@NotNull IdTypeResolver.IdType idType, @NotNull String jobId) {
        return switch (1.$SwitchMap$org$apache$fineract$infrastructure$core$api$IdTypeResolver$IdType[idType.ordinal()]) {
            case 1 -> this.jobDetailRepository.existsById((Object)Long.valueOf(jobId));
            case 2 -> this.jobDetailRepository.existsByShortName(jobId);
            default -> false;
        };
    }
}

