/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service;

import com.google.common.base.Splitter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.domain.FineractPlatformTenant;
import org.apache.fineract.infrastructure.core.exception.JobIsNotFoundOrNotEnabledException;
import org.apache.fineract.infrastructure.core.exception.PlatformInternalServerException;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.jobs.data.JobParameterDTO;
import org.apache.fineract.infrastructure.jobs.domain.ScheduledJobDetail;
import org.apache.fineract.infrastructure.jobs.domain.SchedulerDetail;
import org.apache.fineract.infrastructure.jobs.exception.JobNodeIdMismatchingException;
import org.apache.fineract.infrastructure.jobs.exception.JobNotFoundException;
import org.apache.fineract.infrastructure.jobs.service.JobParameterDataParser;
import org.apache.fineract.infrastructure.jobs.service.JobRegisterService;
import org.apache.fineract.infrastructure.jobs.service.JobStarter;
import org.apache.fineract.infrastructure.jobs.service.SchedularWritePlatformService;
import org.apache.fineract.infrastructure.jobs.service.SchedulerJobListener;
import org.apache.fineract.infrastructure.jobs.service.SchedulerStopListener;
import org.apache.fineract.infrastructure.jobs.service.SchedulerTriggerListener;
import org.apache.fineract.infrastructure.jobs.service.jobname.JobNameData;
import org.apache.fineract.infrastructure.jobs.service.jobname.JobNameService;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Service;

@Service
public class JobRegisterServiceImpl
implements JobRegisterService,
ApplicationListener<ContextClosedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobRegisterServiceImpl.class);
    private static final String JOB_EXECUTION_FAILED_MESSAGE = "Job execution failed for job with name: ";
    @Autowired
    private SchedularWritePlatformService schedularWritePlatformService;
    @Autowired
    private SchedulerJobListener schedulerJobListener;
    @Autowired
    private SchedulerTriggerListener globalSchedulerTriggerListener;
    private static final HashMap<String, Scheduler> SCHEDULERS = new HashMap(4);
    @Autowired
    private FineractProperties fineractProperties;
    @Autowired
    private JobLocator jobLocator;
    @Autowired
    private JobStarter jobStarter;
    @Autowired
    private JobParameterDataParser dataParser;
    @Autowired
    private JobNameService jobNameService;
    private static final String JOB_STARTER_METHOD_NAME = "run";

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public void executeJob(ScheduledJobDetail scheduledJobDetail, String triggerType, Set<JobParameterDTO> jobParameterDTOSet) {
        try {
            JobDataMap jobDataMap = new JobDataMap();
            if (triggerType == null) {
                triggerType = "application";
            }
            jobDataMap.put("TRIGGER_TYPE_REFERENCE", triggerType);
            jobDataMap.put("tenantIdentifier", ThreadLocalContextUtil.getTenant().getTenantIdentifier());
            String schedulerName = this.getSchedulerName(scheduledJobDetail);
            Scheduler scheduler = (Scheduler)SCHEDULERS.get(schedulerName);
            JobDetail jobDetail = this.createJobDetail(scheduledJobDetail, jobParameterDTOSet);
            JobKey jobKey = jobDetail.getKey();
            if (scheduler == null || !scheduler.checkExists(jobKey)) {
                SchedulerStopListener schedulerStopListener = new SchedulerStopListener((JobRegisterService)this);
                String tempSchedulerName = "temp" + String.valueOf(scheduledJobDetail.getId());
                Scheduler tempScheduler = this.createScheduler(tempSchedulerName, 1, new JobListener[]{this.schedulerJobListener, schedulerStopListener});
                jobDataMap.put("schedulerName", tempSchedulerName);
                SCHEDULERS.put(tempSchedulerName, tempScheduler);
                tempScheduler.addJob(jobDetail, true);
                tempScheduler.triggerJob(jobKey, jobDataMap);
            } else {
                scheduler.addJob(jobDetail, true);
                scheduler.triggerJob(jobKey, jobDataMap);
            }
        }
        catch (JobIsNotFoundOrNotEnabledException e) {
            String msg = "Job is not found or it is disabled with job ID: " + String.valueOf(scheduledJobDetail.getId());
            log.error("{}", (Object)msg, (Object)e);
            throw e;
        }
        catch (Exception e) {
            String msg = "Job execution failed for job with id:" + String.valueOf(scheduledJobDetail.getId());
            log.error("{}", (Object)msg, (Object)e);
            throw new PlatformInternalServerException("error.msg.scheduler.job.execution.failed", msg, new Object[]{scheduledJobDetail.getId(), e});
        }
    }

    public void rescheduleJob(ScheduledJobDetail scheduledJobDetail) {
        try {
            String jobIdentity = scheduledJobDetail.getJobKey();
            JobKey jobKey = this.constructJobKey(jobIdentity);
            String schedulername = this.getSchedulerName(scheduledJobDetail);
            Scheduler scheduler = (Scheduler)SCHEDULERS.get(schedulername);
            if (scheduler != null) {
                scheduler.deleteJob(jobKey);
            }
            this.scheduleJob(scheduledJobDetail);
            this.schedularWritePlatformService.saveOrUpdate(scheduledJobDetail);
        }
        catch (Exception throwable) {
            String stackTrace = this.getStackTraceAsString((Throwable)throwable);
            scheduledJobDetail.setErrorLog(stackTrace);
            this.schedularWritePlatformService.saveOrUpdate(scheduledJobDetail);
        }
    }

    public void pauseScheduler() {
        SchedulerDetail schedulerDetail = this.schedularWritePlatformService.retriveSchedulerDetail();
        if (!schedulerDetail.isSuspended()) {
            schedulerDetail.setSuspended(true);
            this.schedularWritePlatformService.updateSchedulerDetail(schedulerDetail);
        }
    }

    public void startScheduler() {
        SchedulerDetail schedulerDetail = this.schedularWritePlatformService.retriveSchedulerDetail();
        if (schedulerDetail.isSuspended()) {
            schedulerDetail.setSuspended(false);
            this.schedularWritePlatformService.updateSchedulerDetail(schedulerDetail);
            if (schedulerDetail.isExecuteInstructionForMisfiredJobs()) {
                List scheduledJobDetails = this.schedularWritePlatformService.retrieveAllJobs(this.fineractProperties.getNodeId());
                for (ScheduledJobDetail jobDetail : scheduledJobDetails) {
                    String schedulerName;
                    Scheduler scheduler;
                    if (!jobDetail.isTriggerMisfired()) continue;
                    if (jobDetail.isActiveSchedular()) {
                        this.executeJob(jobDetail, "cron", Collections.emptySet());
                        jobDetail.setMismatchedJob(false);
                    }
                    if ((scheduler = (Scheduler)SCHEDULERS.get(schedulerName = this.getSchedulerName(jobDetail))) != null) {
                        String key = jobDetail.getJobKey();
                        JobKey jobKey = this.constructJobKey(key);
                        try {
                            List triggers = scheduler.getTriggersOfJob(jobKey);
                            for (Trigger trigger : triggers) {
                                if (trigger.getNextFireTime() == null || !trigger.getNextFireTime().after(jobDetail.getNextRunTime())) continue;
                                jobDetail.setNextRunTime(trigger.getNextFireTime());
                            }
                        }
                        catch (SchedulerException e) {
                            log.error("Error occured.", (Throwable)e);
                        }
                    }
                    jobDetail.setTriggerMisfired(false);
                    this.schedularWritePlatformService.saveOrUpdate(jobDetail);
                }
            }
        }
    }

    public void rescheduleJob(Long jobId) {
        ScheduledJobDetail scheduledJobDetail = this.schedularWritePlatformService.findByJobId(jobId);
        String nodeIdStored = scheduledJobDetail.getNodeId().toString();
        if (!nodeIdStored.equals(this.fineractProperties.getNodeId()) && !nodeIdStored.equals("0")) {
            scheduledJobDetail.setMismatchedJob(true);
            this.schedularWritePlatformService.saveOrUpdate(scheduledJobDetail);
            throw new JobNodeIdMismatchingException(nodeIdStored, this.fineractProperties.getNodeId());
        }
        this.rescheduleJob(scheduledJobDetail);
    }

    public void executeJobWithParameters(Long jobId, String jobParametersJson) {
        Set jobParameterDTOSet = this.dataParser.parseExecution(jobParametersJson);
        ScheduledJobDetail scheduledJobDetail = this.schedularWritePlatformService.findByJobId(jobId);
        if (scheduledJobDetail == null) {
            throw new JobNotFoundException(String.valueOf(jobId));
        }
        String nodeIdStored = scheduledJobDetail.getNodeId().toString();
        if (!nodeIdStored.equals(this.fineractProperties.getNodeId()) && !nodeIdStored.equals("0")) {
            scheduledJobDetail.setMismatchedJob(true);
            this.schedularWritePlatformService.saveOrUpdate(scheduledJobDetail);
            throw new JobNodeIdMismatchingException(nodeIdStored, this.fineractProperties.getNodeId());
        }
        this.executeJob(scheduledJobDetail, null, jobParameterDTOSet);
    }

    public boolean isSchedulerRunning() {
        return !this.schedularWritePlatformService.retriveSchedulerDetail().isSuspended();
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        this.stopAllSchedulers();
    }

    public void scheduleJob(ScheduledJobDetail scheduledJobDetails) {
        try {
            JobDetail jobDetail = this.createJobDetail(scheduledJobDetails, Collections.emptySet());
            scheduledJobDetails.setJobKey(this.getJobKeyAsString(jobDetail.getKey()));
            if (!scheduledJobDetails.isActiveSchedular()) {
                scheduledJobDetails.setNextRunTime(null);
                scheduledJobDetails.setCurrentlyRunning(false);
                return;
            }
            Trigger trigger = this.createTrigger(scheduledJobDetails, jobDetail);
            Scheduler scheduler = this.getScheduler(scheduledJobDetails);
            scheduler.scheduleJob(jobDetail, trigger);
            scheduledJobDetails.setNextRunTime(trigger.getNextFireTime());
            scheduledJobDetails.setErrorLog(null);
        }
        catch (Exception throwable) {
            scheduledJobDetails.setNextRunTime(null);
            String stackTrace = this.getStackTraceAsString((Throwable)throwable);
            scheduledJobDetails.setErrorLog(stackTrace);
            log.error("Could not schedule job: {}", (Object)scheduledJobDetails.getJobName(), (Object)throwable);
        }
        scheduledJobDetails.setCurrentlyRunning(false);
    }

    public void stopAllSchedulers() {
        for (Scheduler scheduler : SCHEDULERS.values()) {
            try {
                scheduler.shutdown();
            }
            catch (SchedulerException e) {
                log.error("Error occured.", (Throwable)e);
            }
        }
    }

    private Scheduler getScheduler(ScheduledJobDetail scheduledJobDetail) throws Exception {
        String schedulername = this.getSchedulerName(scheduledJobDetail);
        Scheduler scheduler = (Scheduler)SCHEDULERS.get(schedulername);
        if (scheduler == null) {
            int noOfThreads = 7;
            if (scheduledJobDetail.getSchedulerGroup() > 0) {
                noOfThreads = 1;
            }
            scheduler = this.createScheduler(schedulername, noOfThreads, new JobListener[]{this.schedulerJobListener});
            SCHEDULERS.put(schedulername, scheduler);
        }
        return scheduler;
    }

    public void stopScheduler(String name) {
        Scheduler scheduler = (Scheduler)SCHEDULERS.remove(name);
        try {
            scheduler.shutdown();
        }
        catch (SchedulerException e) {
            log.error("Error occurred.", (Throwable)e);
        }
    }

    private String getSchedulerName(ScheduledJobDetail scheduledJobDetail) {
        StringBuilder sb = new StringBuilder(20);
        FineractPlatformTenant tenant = ThreadLocalContextUtil.getTenant();
        sb.append("Scheduler").append(tenant.getId());
        if (scheduledJobDetail.getSchedulerGroup() > 0) {
            sb.append("group").append(scheduledJobDetail.getSchedulerGroup());
        }
        return sb.toString();
    }

    private Scheduler createScheduler(String name, int noOfThreads, JobListener ... jobListeners) throws Exception {
        SchedulerFactoryBean schedulerFactoryBean = new SchedulerFactoryBean();
        schedulerFactoryBean.setSchedulerName(name);
        schedulerFactoryBean.setGlobalJobListeners(jobListeners);
        TriggerListener[] globalTriggerListeners = new TriggerListener[]{this.globalSchedulerTriggerListener};
        schedulerFactoryBean.setGlobalTriggerListeners(globalTriggerListeners);
        Properties quartzProperties = new Properties();
        quartzProperties.put("org.quartz.threadPool.threadCount", Integer.toString(noOfThreads));
        schedulerFactoryBean.setQuartzProperties(quartzProperties);
        schedulerFactoryBean.afterPropertiesSet();
        schedulerFactoryBean.start();
        return schedulerFactoryBean.getScheduler();
    }

    private JobDetail createJobDetail(ScheduledJobDetail scheduledJobDetail, Set<JobParameterDTO> jobParameterDTOSet) throws Exception {
        Job job;
        FineractPlatformTenant tenant = ThreadLocalContextUtil.getTenant();
        JobNameData jobName = this.jobNameService.getJobByHumanReadableName(scheduledJobDetail.getJobName());
        try {
            job = this.jobLocator.getJob(jobName.getEnumStyleName());
        }
        catch (NoSuchJobException e) {
            throw new JobIsNotFoundOrNotEnabledException((Exception)((Object)e), jobName.getEnumStyleName());
        }
        MethodInvokingJobDetailFactoryBean jobDetailFactoryBean = new MethodInvokingJobDetailFactoryBean();
        jobDetailFactoryBean.setName(scheduledJobDetail.getJobName() + "JobDetail" + tenant.getId());
        jobDetailFactoryBean.setTargetObject((Object)this.jobStarter);
        jobDetailFactoryBean.setTargetMethod(JOB_STARTER_METHOD_NAME);
        jobDetailFactoryBean.setGroup(scheduledJobDetail.getGroupName());
        jobDetailFactoryBean.setConcurrent(false);
        jobDetailFactoryBean.setArguments(new Object[]{job, scheduledJobDetail, jobParameterDTOSet, tenant.getTenantIdentifier()});
        jobDetailFactoryBean.afterPropertiesSet();
        return jobDetailFactoryBean.getObject();
    }

    private Trigger createTrigger(ScheduledJobDetail scheduledJobDetails, JobDetail jobDetail) throws ParseException {
        FineractPlatformTenant tenant = ThreadLocalContextUtil.getTenant();
        CronTriggerFactoryBean cronTriggerFactoryBean = new CronTriggerFactoryBean();
        cronTriggerFactoryBean.setName(scheduledJobDetails.getJobName() + "Trigger" + tenant.getId());
        cronTriggerFactoryBean.setJobDetail(jobDetail);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("tenantIdentifier", tenant.getTenantIdentifier());
        cronTriggerFactoryBean.setJobDataMap(jobDataMap);
        TimeZone timeZone = TimeZone.getTimeZone(tenant.getTimezoneId());
        cronTriggerFactoryBean.setTimeZone(timeZone);
        cronTriggerFactoryBean.setGroup(scheduledJobDetails.getGroupName());
        cronTriggerFactoryBean.setCronExpression(scheduledJobDetails.getCronExpression());
        cronTriggerFactoryBean.setPriority((int)scheduledJobDetails.getTaskPriority().shortValue());
        cronTriggerFactoryBean.afterPropertiesSet();
        return cronTriggerFactoryBean.getObject();
    }

    private String getStackTraceAsString(Throwable throwable) {
        StackTraceElement[] stackTraceElements = throwable.getStackTrace();
        StringBuilder sb = new StringBuilder(throwable.toString());
        for (StackTraceElement element : stackTraceElements) {
            sb.append("\n \t at ").append(element.getClassName()).append(".").append(element.getMethodName()).append("(").append(element.getLineNumber()).append(")");
        }
        return sb.toString();
    }

    private String getJobKeyAsString(JobKey jobKey) {
        return jobKey.getName() + " _ " + jobKey.getGroup();
    }

    private JobKey constructJobKey(String Key2) {
        List keyParams = Splitter.onPattern((String)" _ ").splitToList((CharSequence)Key2);
        return new JobKey((String)keyParams.get(0), (String)keyParams.get(1));
    }
}

