/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.codes.service;

import jakarta.persistence.PersistenceException;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.codes.domain.Code;
import org.apache.fineract.infrastructure.codes.domain.CodeRepository;
import org.apache.fineract.infrastructure.codes.exception.CodeNotFoundException;
import org.apache.fineract.infrastructure.codes.exception.SystemDefinedCodeCannotBeChangedException;
import org.apache.fineract.infrastructure.codes.serialization.CodeCommandFromApiJsonDeserializer;
import org.apache.fineract.infrastructure.codes.service.CodeWritePlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CodeWritePlatformServiceJpaRepositoryImpl
implements CodeWritePlatformService {
    private static final Logger LOG = LoggerFactory.getLogger(CodeWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final CodeRepository codeRepository;
    private final CodeCommandFromApiJsonDeserializer fromApiJsonDeserializer;

    @Autowired
    public CodeWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, CodeRepository codeRepository, CodeCommandFromApiJsonDeserializer fromApiJsonDeserializer) {
        this.context = context;
        this.codeRepository = codeRepository;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
    }

    @Transactional
    @CacheEvict(value={"codes"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat('CD')")
    public CommandProcessingResult createCode(JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForCreate(command.json());
            Code code = Code.fromJson((JsonCommand)command);
            this.codeRepository.saveAndFlush((Object)code);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)code.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleCodeDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException ee) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)ee.getCause());
            this.handleCodeDataIntegrityIssues(command, throwable, (Exception)((Object)ee));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    @CacheEvict(value={"codes"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat('CD')")
    public CommandProcessingResult updateCode(Long codeId, JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForUpdate(command.json());
            Code code = this.retrieveCodeBy(codeId);
            Map changes = code.update(command);
            if (!changes.isEmpty()) {
                this.codeRepository.saveAndFlush((Object)code);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(codeId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleCodeDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException ee) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)ee.getCause());
            this.handleCodeDataIntegrityIssues(command, throwable, (Exception)((Object)ee));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    @CacheEvict(value={"codes"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat('CD')")
    public CommandProcessingResult deleteCode(Long codeId) {
        this.context.authenticatedUser();
        Code code = this.retrieveCodeBy(codeId);
        if (code.isSystemDefined()) {
            throw new SystemDefinedCodeCannotBeChangedException();
        }
        try {
            this.codeRepository.delete((Object)code);
            this.codeRepository.flush();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.cund.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + dve.getMostSpecificCause().getMessage()));
        }
        return new CommandProcessingResultBuilder().withEntityId(codeId).build();
    }

    private Code retrieveCodeBy(Long codeId) {
        return (Code)this.codeRepository.findById((Object)codeId).orElseThrow(() -> new CodeNotFoundException(codeId.toString()));
    }

    private void handleCodeDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("code_name")) {
            String name = command.stringValueOfParameterNamed("name");
            throw new PlatformDataIntegrityException("error.msg.code.duplicate.name", "A code with name '" + name + "' already exists", "name", new Object[]{name});
        }
        LOG.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.cund.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }
}

