/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator;

import java.util.List;
import org.apache.fineract.accounting.glaccount.data.GLAccountData;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class GlAccountSheetPopulator
extends AbstractWorkbookPopulator {
    private List<GLAccountData> allGlAccounts;
    private static final int ID_COL = 0;
    private static final int ACCOUNT_NAME_COL = 1;

    public GlAccountSheetPopulator(List<GLAccountData> glAccounts) {
        this.allGlAccounts = glAccounts;
    }

    public void populate(Workbook workbook, String dateFormat) {
        int rowIndex = 1;
        Sheet glAccountSheet = workbook.createSheet("GlAccounts");
        this.setLayout(glAccountSheet);
        this.populateglAccounts(glAccountSheet, rowIndex);
        glAccountSheet.protectSheet("");
    }

    private void setLayout(Sheet worksheet) {
        worksheet.setColumnWidth(0, 4000);
        worksheet.setColumnWidth(1, 6000);
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        this.writeString(0, rowHeader, "Gl Account ID");
        this.writeString(1, rowHeader, "Gl Account Name");
    }

    private void populateglAccounts(Sheet GlAccountSheet, int rowIndex) {
        for (GLAccountData glAccount : this.allGlAccounts) {
            Row row = GlAccountSheet.createRow(rowIndex);
            this.writeLong(0, row, glAccount.getId().longValue());
            this.writeString(1, row, glAccount.getName().trim().replaceAll("[ )(]", "_"));
            ++rowIndex;
        }
    }

    public Integer getGlAccountNamesSize() {
        return this.allGlAccounts.size();
    }
}

