/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request;

import com.navercorp.pinpoint.bootstrap.plugin.request.CookieAdaptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class CookieFilter<C> {
    public List<CookieAdaptor> wrap(C[] cookies) {
        if (cookies == null) {
            return Collections.emptyList();
        }
        ArrayList<CookieAdaptor> result = new ArrayList<CookieAdaptor>(cookies.length);
        for (C cookie : cookies) {
            result.add(this.newCookieAdaptor(cookie));
        }
        return result;
    }

    public List<CookieAdaptor> filter(C[] cookies, String[] cookieNames) {
        if (cookies == null) {
            return Collections.emptyList();
        }
        ArrayList<CookieAdaptor> result = null;
        for (C cookie : cookies) {
            String name = this.getName(cookie);
            if (!this.isMatch(cookieNames, name)) continue;
            if (result == null) {
                result = new ArrayList<CookieAdaptor>(cookieNames.length);
            }
            result.add(this.newCookieAdaptor(cookie));
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public boolean isMatch(String[] cookieNames, String name) {
        for (String cookieName : cookieNames) {
            if (!cookieName.equals(name)) continue;
            return true;
        }
        return false;
    }

    protected abstract CookieAdaptor newCookieAdaptor(C var1);

    protected abstract String getName(C var1);
}

