/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.jdbc;

import com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindVariableFilter;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.SqlModule;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public final class PreparedStatementUtils {
    private static final Pattern BIND_SETTER = Pattern.compile("set[A-Z]([a-zA-Z]+)");
    private static final List<Method> bindMethod = PreparedStatementUtils.findBindVariableSetMethod0();

    private PreparedStatementUtils() {
    }

    public static List<Method> findBindVariableSetMethod() {
        return Collections.unmodifiableList(bindMethod);
    }

    public static List<Method> findBindVariableSetMethod(BindVariableFilter filter) {
        Objects.requireNonNull(filter, "filter");
        ArrayList<Method> temp = new ArrayList<Method>(bindMethod.size());
        for (Method method : bindMethod) {
            if (!filter.filter(method)) continue;
            temp.add(method);
        }
        return temp;
    }

    static List<Method> findBindVariableSetMethod0() {
        if (!SqlModule.isSqlModuleEnable()) {
            return Collections.emptyList();
        }
        Class<?> preparedStatement = SqlModule.getSqlPreparedStatement();
        Method[] methods = preparedStatement.getDeclaredMethods();
        ArrayList<Method> bindMethod = new ArrayList<Method>();
        for (Method method : methods) {
            Class<?>[] parameterTypes;
            if (!PreparedStatementUtils.isSetter(method.getName()) || method.getParameterCount() < 2 || (parameterTypes = method.getParameterTypes())[0] != Integer.TYPE || method.getReturnType() != Void.TYPE || !PreparedStatementUtils.throwSqlException(method)) continue;
            bindMethod.add(method);
        }
        return Collections.unmodifiableList(bindMethod);
    }

    private static boolean throwSqlException(Method method) {
        Class<?> exceptionType;
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        return exceptionTypes.length == 1 && (exceptionType = exceptionTypes[0]).getName().equals("java.sql.SQLException");
    }

    public static boolean isSetter(String name) {
        if (name == null) {
            return false;
        }
        return BIND_SETTER.matcher(name).matches();
    }
}

