/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.logging;

import com.navercorp.pinpoint.bootstrap.logging.DummyPluginLogger;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import com.navercorp.pinpoint.bootstrap.logging.PluginLoggerBinder;
import com.navercorp.pinpoint.common.util.logger.CommonLogger;
import com.navercorp.pinpoint.common.util.logger.StdoutCommonLoggerFactory;
import java.util.Objects;

public class PluginLogManager {
    private static PluginLoggerBinder loggerBinder;

    public static void initialize(PluginLoggerBinder loggerBinder) {
        if (PluginLogManager.loggerBinder == null) {
            PluginLogManager.loggerBinder = loggerBinder;
        } else {
            CommonLogger logger = StdoutCommonLoggerFactory.INSTANCE.getLogger(PluginLogManager.class.getName());
            logger.warn("loggerBinder is not null");
        }
    }

    public static void unregister(PluginLoggerBinder loggerBinder) {
        if (loggerBinder == PluginLogManager.loggerBinder) {
            PluginLogManager.loggerBinder = null;
        }
    }

    public static PluginLogger getLogger(String name) {
        if (loggerBinder == null) {
            return DummyPluginLogger.INSTANCE;
        }
        return loggerBinder.getLogger(name);
    }

    public static PluginLogger getLogger(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return PluginLogManager.getLogger(clazz.getName());
    }
}

