/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor.scope;

import com.navercorp.pinpoint.bootstrap.interceptor.ExceptionHandler;
import com.navercorp.pinpoint.bootstrap.interceptor.StaticAroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import java.util.Objects;

public class ExceptionHandleScopedStaticAroundInterceptor
implements StaticAroundInterceptor {
    private final PluginLogger logger = PluginLogManager.getLogger(this.getClass());
    private final boolean debugEnabled = this.logger.isDebugEnabled();
    private final StaticAroundInterceptor delegate;
    private final InterceptorScope scope;
    private final ExecutionPolicy policy;
    private final ExceptionHandler exceptionHandler;

    public ExceptionHandleScopedStaticAroundInterceptor(StaticAroundInterceptor delegate, InterceptorScope scope, ExecutionPolicy policy, ExceptionHandler exceptionHandler) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.scope = Objects.requireNonNull(scope, "scope");
        this.policy = Objects.requireNonNull(policy, "policy");
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler, "exceptionHandler");
    }

    @Override
    public void before(Object target, String className, String methodName, String parameterDescription, Object[] args) {
        InterceptorScopeInvocation transaction = this.scope.getCurrentInvocation();
        if (transaction.tryEnter(this.policy)) {
            try {
                this.delegate.before(target, className, methodName, parameterDescription, args);
            }
            catch (Throwable t) {
                this.exceptionHandler.handleException(t);
            }
        } else if (this.debugEnabled) {
            this.logger.debug("tryBefore() returns false: interceptorScopeTransaction: {}, executionPoint: {}. Skip interceptor {}", new Object[]{transaction, this.policy, this.delegate.getClass()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void after(Object target, String className, String methodName, String parameterDescription, Object[] args, Object result, Throwable throwable) {
        InterceptorScopeInvocation transaction = this.scope.getCurrentInvocation();
        if (transaction.canLeave(this.policy)) {
            try {
                this.delegate.after(target, className, methodName, parameterDescription, args, result, throwable);
            }
            catch (Throwable t) {
                this.exceptionHandler.handleException(t);
            }
            finally {
                transaction.leave(this.policy);
            }
        } else if (this.debugEnabled) {
            this.logger.debug("tryAfter() returns false: interceptorScopeTransaction: {}, executionPoint: {}. Skip interceptor {}", new Object[]{transaction, this.policy, this.delegate.getClass()});
        }
    }
}

