/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor.registry;

import com.navercorp.pinpoint.bootstrap.interceptor.Interceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.LoggingInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.registry.InterceptorRegistryAdaptor;
import com.navercorp.pinpoint.bootstrap.interceptor.registry.WeakAtomicReferenceArray;
import java.util.concurrent.atomic.AtomicInteger;

public final class DefaultInterceptorRegistryAdaptor
implements InterceptorRegistryAdaptor {
    private static final LoggingInterceptor LOGGING_INTERCEPTOR = new LoggingInterceptor("com.navercorp.pinpoint.profiler.interceptor.LOGGING_INTERCEPTOR");
    private static final int DEFAULT_MAX = 8192;
    private final int registrySize;
    private final AtomicInteger id = new AtomicInteger(0);
    private final WeakAtomicReferenceArray<Interceptor> index;

    public DefaultInterceptorRegistryAdaptor() {
        this(8192);
    }

    public DefaultInterceptorRegistryAdaptor(int maxRegistrySize) {
        if (maxRegistrySize < 0) {
            throw new IllegalArgumentException("negative maxRegistrySize:" + maxRegistrySize);
        }
        this.registrySize = maxRegistrySize;
        this.index = new WeakAtomicReferenceArray<Interceptor>(maxRegistrySize, Interceptor.class);
    }

    @Override
    public int addInterceptor(Interceptor interceptor) {
        if (interceptor == null) {
            return -1;
        }
        int newId = this.checkMaxSize(this.nextId());
        this.index.set(newId, interceptor);
        return newId;
    }

    @Override
    public int addInterceptor() {
        return this.checkMaxSize(this.nextId());
    }

    private int checkMaxSize(int id) {
        if (id >= this.registrySize) {
            throw new IndexOutOfBoundsException("Interceptor registry size exceeded. Check the \"profiler.interceptorregistry.size\" setting. size=" + this.index.length() + " id=" + id);
        }
        return id;
    }

    private int nextId() {
        return this.id.getAndIncrement();
    }

    @Override
    public Interceptor getInterceptor(int key) {
        Interceptor interceptor = this.index.get(key);
        if (interceptor == null) {
            return LOGGING_INTERCEPTOR;
        }
        return interceptor;
    }

    @Override
    public void clear() {
        if (this.index != null) {
            int length = this.index.length();
            for (int i = 0; i < length; ++i) {
                Interceptor interceptor = this.index.get(0);
                Object var3_3 = null;
            }
        }
    }

    @Override
    public boolean contains(int key) {
        return this.index.get(key) != null;
    }
}

