/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.metrics.prometheus;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.metrics.api.MetricsRegistry;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.apache.eventmesh.metrics.prometheus.OpenTelemetryPrometheusManager;
import org.apache.eventmesh.metrics.prometheus.PrometheusMetricsRegistryManager;
import org.apache.eventmesh.metrics.prometheus.config.PrometheusConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Config(field="prometheusConfiguration")
public class PrometheusMetricsRegistry
implements MetricsRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricsRegistry.class);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private OpenTelemetry openTelemetry;
    private PrometheusConfiguration prometheusConfiguration;

    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        try {
            this.prometheusConfiguration = Objects.requireNonNull(this.prometheusConfiguration, "prometheusConfiguration can't be null!");
            String eventMeshPrometheusExportHost = this.prometheusConfiguration.getEventMeshPrometheusExportHost();
            int eventMeshPrometheusPort = this.prometheusConfiguration.getEventMeshPrometheusPort();
            this.openTelemetry = OpenTelemetryPrometheusManager.initOpenTelemetry(eventMeshPrometheusExportHost, eventMeshPrometheusPort);
            PrometheusMetricsRegistryManager.createMetric(this.openTelemetry);
        }
        catch (Exception e) {
            log.error("failed to start prometheus export, Host: {}:{} due to {}", new Object[]{this.prometheusConfiguration.getEventMeshPrometheusExportHost(), this.prometheusConfiguration.getEventMeshPrometheusPort(), e.getMessage()});
        }
    }

    public void showdown() {
        if (this.openTelemetry instanceof OpenTelemetrySdk) {
            OpenTelemetrySdk ignored = (OpenTelemetrySdk)this.openTelemetry;
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
    }

    public void register(Metric metric) {
        PrometheusMetricsRegistryManager.registerMetric(metric);
    }

    public void unRegister(Metric metric) {
    }

    public PrometheusConfiguration getClientConfiguration() {
        return this.prometheusConfiguration;
    }
}

