/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import io.netty.channel.ChannelHandlerContext;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.mqtrace.ConsumeMessageContext;
import org.apache.rocketmq.broker.mqtrace.ConsumeMessageHook;
import org.apache.rocketmq.broker.mqtrace.SendMessageContext;
import org.apache.rocketmq.broker.processor.AbstractSendMessageProcessor;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBatch;
import org.apache.rocketmq.common.protocol.NamespaceUtil;
import org.apache.rocketmq.common.protocol.header.ConsumerSendMsgBackRequestHeader;
import org.apache.rocketmq.common.protocol.header.SendMessageRequestHeader;
import org.apache.rocketmq.common.protocol.header.SendMessageResponseHeader;
import org.apache.rocketmq.common.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.common.sysflag.TopicSysFlag;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.RemotingResponseCallback;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.MessageExtBrokerInner;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.config.StorePathConfigHelper;
import org.apache.rocketmq.store.stats.BrokerStatsManager;

public class SendMessageProcessor
extends AbstractSendMessageProcessor {
    private List<ConsumeMessageHook> consumeMessageHookList;

    public SendMessageProcessor(BrokerController brokerController) {
        super(brokerController);
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = null;
        try {
            response = this.asyncProcessRequest(ctx, request).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("process SendMessage error, request : " + request.toString(), (Throwable)e);
        }
        return response;
    }

    public void asyncProcessRequest(ChannelHandlerContext ctx, RemotingCommand request, RemotingResponseCallback responseCallback) throws Exception {
        this.asyncProcessRequest(ctx, request).thenAcceptAsync(arg_0 -> ((RemotingResponseCallback)responseCallback).callback(arg_0), (Executor)this.brokerController.getPutMessageFutureExecutor());
    }

    public CompletableFuture<RemotingCommand> asyncProcessRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        switch (request.getCode()) {
            case 36: {
                return this.asyncConsumerSendMsgBack(ctx, request);
            }
        }
        SendMessageRequestHeader requestHeader = this.parseRequestHeader(request);
        if (requestHeader == null) {
            return CompletableFuture.completedFuture(null);
        }
        SendMessageContext mqtraceContext = this.buildMsgContext(ctx, requestHeader);
        this.executeSendMessageHookBefore(ctx, request, mqtraceContext);
        if (requestHeader.isBatch()) {
            return this.asyncSendBatchMessage(ctx, request, mqtraceContext, requestHeader);
        }
        return this.asyncSendMessage(ctx, request, mqtraceContext, requestHeader);
    }

    @Override
    public boolean rejectRequest() {
        return this.brokerController.getMessageStore().isOSPageCacheBusy() || this.brokerController.getMessageStore().isTransientStorePoolDeficient();
    }

    private CompletableFuture<RemotingCommand> asyncConsumerSendMsgBack(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        Integer times;
        TopicConfig topicConfig;
        SubscriptionGroupConfig subscriptionGroupConfig;
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        ConsumerSendMsgBackRequestHeader requestHeader = (ConsumerSendMsgBackRequestHeader)request.decodeCommandCustomHeader(ConsumerSendMsgBackRequestHeader.class);
        String namespace = NamespaceUtil.getNamespaceFromResource((String)requestHeader.getGroup());
        if (this.hasConsumeMessageHook() && !UtilAll.isBlank((String)requestHeader.getOriginMsgId())) {
            ConsumeMessageContext context = SendMessageProcessor.buildConsumeMessageContext(namespace, requestHeader, request);
            this.executeConsumeMessageHookAfter(context);
        }
        if (null == (subscriptionGroupConfig = this.brokerController.getSubscriptionGroupManager().findSubscriptionGroupConfig(requestHeader.getGroup()))) {
            response.setCode(26);
            response.setRemark("subscription group not exist, " + requestHeader.getGroup() + " " + FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/"));
            return CompletableFuture.completedFuture(response);
        }
        if (!PermName.isWriteable((int)this.brokerController.getBrokerConfig().getBrokerPermission())) {
            response.setCode(16);
            response.setRemark("the broker[" + this.brokerController.getBrokerConfig().getBrokerIP1() + "] sending message is forbidden");
            return CompletableFuture.completedFuture(response);
        }
        if (subscriptionGroupConfig.getRetryQueueNums() <= 0) {
            response.setCode(0);
            response.setRemark(null);
            return CompletableFuture.completedFuture(response);
        }
        String newTopic = MixAll.getRetryTopic((String)requestHeader.getGroup());
        int queueIdInt = ThreadLocalRandom.current().nextInt(99999999) % subscriptionGroupConfig.getRetryQueueNums();
        int topicSysFlag = 0;
        if (requestHeader.isUnitMode()) {
            topicSysFlag = TopicSysFlag.buildSysFlag((boolean)false, (boolean)true);
        }
        if (null == (topicConfig = this.brokerController.getTopicConfigManager().createTopicInSendMessageBackMethod(newTopic, subscriptionGroupConfig.getRetryQueueNums(), 6, topicSysFlag))) {
            response.setCode(1);
            response.setRemark("topic[" + newTopic + "] not exist");
            return CompletableFuture.completedFuture(response);
        }
        if (!PermName.isWriteable((int)topicConfig.getPerm())) {
            response.setCode(16);
            response.setRemark(String.format("the topic[%s] sending message is forbidden", newTopic));
            return CompletableFuture.completedFuture(response);
        }
        MessageExt msgExt = this.brokerController.getMessageStore().lookMessageByOffset(requestHeader.getOffset().longValue());
        if (null == msgExt) {
            response.setCode(1);
            response.setRemark("look message by offset failed, " + requestHeader.getOffset());
            return CompletableFuture.completedFuture(response);
        }
        String retryTopic = msgExt.getProperty("RETRY_TOPIC");
        if (null == retryTopic) {
            MessageAccessor.putProperty((Message)msgExt, (String)"RETRY_TOPIC", (String)msgExt.getTopic());
        }
        msgExt.setWaitStoreMsgOK(false);
        int delayLevel = requestHeader.getDelayLevel();
        int maxReconsumeTimes = subscriptionGroupConfig.getRetryMaxTimes();
        if (request.getVersion() >= MQVersion.Version.V3_4_9.ordinal() && (times = requestHeader.getMaxReconsumeTimes()) != null) {
            maxReconsumeTimes = times;
        }
        if (msgExt.getReconsumeTimes() >= maxReconsumeTimes || delayLevel < 0) {
            newTopic = MixAll.getDLQTopic((String)requestHeader.getGroup());
            queueIdInt = ThreadLocalRandom.current().nextInt(99999999) % 1;
            topicConfig = this.brokerController.getTopicConfigManager().createTopicInSendMessageBackMethod(newTopic, 1, 6, 0);
            if (null == topicConfig) {
                response.setCode(1);
                response.setRemark("topic[" + newTopic + "] not exist");
                return CompletableFuture.completedFuture(response);
            }
            msgExt.setDelayTimeLevel(0);
        } else {
            if (0 == delayLevel) {
                delayLevel = 3 + msgExt.getReconsumeTimes();
            }
            msgExt.setDelayTimeLevel(delayLevel);
        }
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setTopic(newTopic);
        msgInner.setBody(msgExt.getBody());
        msgInner.setFlag(msgExt.getFlag());
        MessageAccessor.setProperties((Message)msgInner, (Map)msgExt.getProperties());
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgExt.getProperties()));
        msgInner.setTagsCode(MessageExtBrokerInner.tagsString2tagsCode(null, (String)msgExt.getTags()));
        msgInner.setQueueId(queueIdInt);
        msgInner.setSysFlag(msgExt.getSysFlag());
        msgInner.setBornTimestamp(msgExt.getBornTimestamp());
        msgInner.setBornHost(msgExt.getBornHost());
        msgInner.setStoreHost(msgExt.getStoreHost());
        msgInner.setReconsumeTimes(msgExt.getReconsumeTimes() + 1);
        String originMsgId = MessageAccessor.getOriginMessageId((Message)msgExt);
        MessageAccessor.setOriginMessageId((Message)msgInner, (String)(UtilAll.isBlank((String)originMsgId) ? msgExt.getMsgId() : originMsgId));
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgExt.getProperties()));
        CompletableFuture putMessageResult = this.brokerController.getMessageStore().asyncPutMessage(msgInner);
        return putMessageResult.thenApply(r -> {
            if (r != null) {
                switch (r.getPutMessageStatus()) {
                    case PUT_OK: {
                        String backTopic = msgExt.getTopic();
                        String correctTopic = msgExt.getProperty("RETRY_TOPIC");
                        if (correctTopic != null) {
                            backTopic = correctTopic;
                        }
                        if ("SCHEDULE_TOPIC_XXXX".equals(msgInner.getTopic())) {
                            this.brokerController.getBrokerStatsManager().incTopicPutNums(msgInner.getTopic());
                            this.brokerController.getBrokerStatsManager().incTopicPutSize(msgInner.getTopic(), r.getAppendMessageResult().getWroteBytes());
                            this.brokerController.getBrokerStatsManager().incQueuePutNums(msgInner.getTopic(), Integer.valueOf(msgInner.getQueueId()));
                            this.brokerController.getBrokerStatsManager().incQueuePutSize(msgInner.getTopic(), Integer.valueOf(msgInner.getQueueId()), r.getAppendMessageResult().getWroteBytes());
                        }
                        this.brokerController.getBrokerStatsManager().incSendBackNums(requestHeader.getGroup(), backTopic);
                        response.setCode(0);
                        response.setRemark(null);
                        return response;
                    }
                }
                response.setCode(1);
                response.setRemark(r.getPutMessageStatus().name());
                return response;
            }
            response.setCode(1);
            response.setRemark("putMessageResult is null");
            return response;
        });
    }

    private CompletableFuture<RemotingCommand> asyncSendMessage(ChannelHandlerContext ctx, RemotingCommand request, SendMessageContext mqtraceContext, SendMessageRequestHeader requestHeader) {
        RemotingCommand response = this.preSend(ctx, request, requestHeader);
        SendMessageResponseHeader responseHeader = (SendMessageResponseHeader)response.readCustomHeader();
        if (response.getCode() != -1) {
            return CompletableFuture.completedFuture(response);
        }
        byte[] body = request.getBody();
        int queueIdInt = requestHeader.getQueueId();
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
        if (queueIdInt < 0) {
            queueIdInt = this.randomQueueId(topicConfig.getWriteQueueNums());
        }
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setTopic(requestHeader.getTopic());
        msgInner.setQueueId(queueIdInt);
        if (!this.handleRetryAndDLQ(requestHeader, response, request, (MessageExt)msgInner, topicConfig)) {
            return CompletableFuture.completedFuture(response);
        }
        msgInner.setBody(body);
        msgInner.setFlag(requestHeader.getFlag().intValue());
        Map origProps = MessageDecoder.string2messageProperties((String)requestHeader.getProperties());
        MessageAccessor.setProperties((Message)msgInner, (Map)origProps);
        msgInner.setBornTimestamp(requestHeader.getBornTimestamp().longValue());
        msgInner.setBornHost(ctx.channel().remoteAddress());
        msgInner.setStoreHost(this.getStoreHost());
        msgInner.setReconsumeTimes(requestHeader.getReconsumeTimes() == null ? 0 : requestHeader.getReconsumeTimes());
        String clusterName = this.brokerController.getBrokerConfig().getBrokerClusterName();
        MessageAccessor.putProperty((Message)msgInner, (String)"CLUSTER", (String)clusterName);
        if (origProps.containsKey("WAIT")) {
            String waitStoreMsgOKValue = (String)origProps.remove("WAIT");
            msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
            origProps.put("WAIT", waitStoreMsgOKValue);
        } else {
            msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
        }
        CompletableFuture<PutMessageResult> putMessageResult = null;
        String transFlag = (String)origProps.get("TRAN_MSG");
        if (Boolean.parseBoolean(transFlag)) {
            if (this.brokerController.getBrokerConfig().isRejectTransactionMessage()) {
                response.setCode(16);
                response.setRemark("the broker[" + this.brokerController.getBrokerConfig().getBrokerIP1() + "] sending transaction message is forbidden");
                return CompletableFuture.completedFuture(response);
            }
            putMessageResult = this.brokerController.getTransactionalMessageService().asyncPrepareMessage(msgInner);
        } else {
            putMessageResult = this.brokerController.getMessageStore().asyncPutMessage(msgInner);
        }
        return this.handlePutMessageResultFuture(putMessageResult, response, request, (MessageExt)msgInner, responseHeader, mqtraceContext, ctx, queueIdInt);
    }

    private CompletableFuture<RemotingCommand> handlePutMessageResultFuture(CompletableFuture<PutMessageResult> putMessageResult, RemotingCommand response, RemotingCommand request, MessageExt msgInner, SendMessageResponseHeader responseHeader, SendMessageContext sendMessageContext, ChannelHandlerContext ctx, int queueIdInt) {
        return putMessageResult.thenApply(r -> this.handlePutMessageResult((PutMessageResult)r, response, request, msgInner, responseHeader, sendMessageContext, ctx, queueIdInt));
    }

    private boolean handleRetryAndDLQ(SendMessageRequestHeader requestHeader, RemotingCommand response, RemotingCommand request, MessageExt msg, TopicConfig topicConfig) {
        String newTopic = requestHeader.getTopic();
        if (null != newTopic && newTopic.startsWith("%RETRY%")) {
            int reconsumeTimes;
            String groupName = newTopic.substring("%RETRY%".length());
            SubscriptionGroupConfig subscriptionGroupConfig = this.brokerController.getSubscriptionGroupManager().findSubscriptionGroupConfig(groupName);
            if (null == subscriptionGroupConfig) {
                response.setCode(26);
                response.setRemark("subscription group not exist, " + groupName + " " + FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/"));
                return false;
            }
            int maxReconsumeTimes = subscriptionGroupConfig.getRetryMaxTimes();
            if (request.getVersion() >= MQVersion.Version.V3_4_9.ordinal() && requestHeader.getMaxReconsumeTimes() != null) {
                maxReconsumeTimes = requestHeader.getMaxReconsumeTimes();
            }
            int n = reconsumeTimes = requestHeader.getReconsumeTimes() == null ? 0 : requestHeader.getReconsumeTimes();
            if (reconsumeTimes >= maxReconsumeTimes) {
                newTopic = MixAll.getDLQTopic((String)groupName);
                int queueIdInt = ThreadLocalRandom.current().nextInt(99999999) % 1;
                topicConfig = this.brokerController.getTopicConfigManager().createTopicInSendMessageBackMethod(newTopic, 1, 6, 0);
                msg.setTopic(newTopic);
                msg.setQueueId(queueIdInt);
                msg.setDelayTimeLevel(0);
                if (null == topicConfig) {
                    response.setCode(1);
                    response.setRemark("topic[" + newTopic + "] not exist");
                    return false;
                }
            }
        }
        int sysFlag = requestHeader.getSysFlag();
        if (TopicFilterType.MULTI_TAG == topicConfig.getTopicFilterType()) {
            sysFlag |= 2;
        }
        msg.setSysFlag(sysFlag);
        return true;
    }

    private RemotingCommand sendMessage(ChannelHandlerContext ctx, RemotingCommand request, SendMessageContext sendMessageContext, SendMessageRequestHeader requestHeader) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(SendMessageResponseHeader.class);
        SendMessageResponseHeader responseHeader = (SendMessageResponseHeader)response.readCustomHeader();
        response.setOpaque(request.getOpaque());
        response.addExtField("MSG_REGION", this.brokerController.getBrokerConfig().getRegionId());
        response.addExtField("TRACE_ON", String.valueOf(this.brokerController.getBrokerConfig().isTraceOn()));
        log.debug("receive SendMessage request command, {}", (Object)request);
        long startTimstamp = this.brokerController.getBrokerConfig().getStartAcceptSendRequestTimeStamp();
        if (this.brokerController.getMessageStore().now() < startTimstamp) {
            response.setCode(1);
            response.setRemark(String.format("broker unable to service, until %s", UtilAll.timeMillisToHumanString2((long)startTimstamp)));
            return response;
        }
        response.setCode(-1);
        super.msgCheck(ctx, requestHeader, response);
        if (response.getCode() != -1) {
            return response;
        }
        byte[] body = request.getBody();
        int queueIdInt = requestHeader.getQueueId();
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
        if (queueIdInt < 0) {
            queueIdInt = ThreadLocalRandom.current().nextInt(99999999) % topicConfig.getWriteQueueNums();
        }
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setTopic(requestHeader.getTopic());
        msgInner.setQueueId(queueIdInt);
        if (!this.handleRetryAndDLQ(requestHeader, response, request, (MessageExt)msgInner, topicConfig)) {
            return response;
        }
        msgInner.setBody(body);
        msgInner.setFlag(requestHeader.getFlag().intValue());
        MessageAccessor.setProperties((Message)msgInner, (Map)MessageDecoder.string2messageProperties((String)requestHeader.getProperties()));
        msgInner.setBornTimestamp(requestHeader.getBornTimestamp().longValue());
        msgInner.setBornHost(ctx.channel().remoteAddress());
        msgInner.setStoreHost(this.getStoreHost());
        msgInner.setReconsumeTimes(requestHeader.getReconsumeTimes() == null ? 0 : requestHeader.getReconsumeTimes());
        String clusterName = this.brokerController.getBrokerConfig().getBrokerClusterName();
        MessageAccessor.putProperty((Message)msgInner, (String)"CLUSTER", (String)clusterName);
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
        PutMessageResult putMessageResult = null;
        Map oriProps = MessageDecoder.string2messageProperties((String)requestHeader.getProperties());
        String traFlag = (String)oriProps.get("TRAN_MSG");
        if (Boolean.parseBoolean(traFlag) && (msgInner.getReconsumeTimes() <= 0 || msgInner.getDelayTimeLevel() <= 0)) {
            if (this.brokerController.getBrokerConfig().isRejectTransactionMessage()) {
                response.setCode(16);
                response.setRemark("the broker[" + this.brokerController.getBrokerConfig().getBrokerIP1() + "] sending transaction message is forbidden");
                return response;
            }
            putMessageResult = this.brokerController.getTransactionalMessageService().prepareMessage(msgInner);
        } else {
            putMessageResult = this.brokerController.getMessageStore().putMessage(msgInner);
        }
        return this.handlePutMessageResult(putMessageResult, response, request, (MessageExt)msgInner, responseHeader, sendMessageContext, ctx, queueIdInt);
    }

    private RemotingCommand handlePutMessageResult(PutMessageResult putMessageResult, RemotingCommand response, RemotingCommand request, MessageExt msg, SendMessageResponseHeader responseHeader, SendMessageContext sendMessageContext, ChannelHandlerContext ctx, int queueIdInt) {
        if (putMessageResult == null) {
            response.setCode(1);
            response.setRemark("store putMessage return null");
            return response;
        }
        boolean sendOK = false;
        switch (putMessageResult.getPutMessageStatus()) {
            case PUT_OK: {
                sendOK = true;
                response.setCode(0);
                break;
            }
            case FLUSH_DISK_TIMEOUT: {
                response.setCode(10);
                sendOK = true;
                break;
            }
            case FLUSH_SLAVE_TIMEOUT: {
                response.setCode(12);
                sendOK = true;
                break;
            }
            case SLAVE_NOT_AVAILABLE: {
                response.setCode(11);
                sendOK = true;
                break;
            }
            case CREATE_MAPEDFILE_FAILED: {
                response.setCode(1);
                response.setRemark("create mapped file failed, server is busy or broken.");
                break;
            }
            case MESSAGE_ILLEGAL: 
            case PROPERTIES_SIZE_EXCEEDED: {
                response.setCode(13);
                response.setRemark(String.format("the message is illegal, maybe msg body or properties length not matched. msg body length limit %dB, msg properties length limit 32KB.", this.brokerController.getMessageStoreConfig().getMaxMessageSize()));
                break;
            }
            case SERVICE_NOT_AVAILABLE: {
                response.setCode(14);
                response.setRemark("service not available now. It may be caused by one of the following reasons: the broker's disk is full [" + this.diskUtil() + "], messages are put to the slave, message store has been shut down, etc.");
                break;
            }
            case OS_PAGECACHE_BUSY: {
                response.setCode(1);
                response.setRemark("[PC_SYNCHRONIZED]broker busy, start flow control for a while");
                break;
            }
            case LMQ_CONSUME_QUEUE_NUM_EXCEEDED: {
                response.setCode(1);
                response.setRemark("[LMQ_CONSUME_QUEUE_NUM_EXCEEDED]broker config enableLmq and enableMultiDispatch, lmq consumeQueue num exceed maxLmqConsumeQueueNum config num, default limit 2w.");
                break;
            }
            case UNKNOWN_ERROR: {
                response.setCode(1);
                response.setRemark("UNKNOWN_ERROR");
                break;
            }
            default: {
                response.setCode(1);
                response.setRemark("UNKNOWN_ERROR DEFAULT");
            }
        }
        String owner = (String)request.getExtFields().get("Owner");
        if (sendOK) {
            if ("SCHEDULE_TOPIC_XXXX".equals(msg.getTopic())) {
                this.brokerController.getBrokerStatsManager().incQueuePutNums(msg.getTopic(), Integer.valueOf(msg.getQueueId()), putMessageResult.getAppendMessageResult().getMsgNum(), 1);
                this.brokerController.getBrokerStatsManager().incQueuePutSize(msg.getTopic(), Integer.valueOf(msg.getQueueId()), putMessageResult.getAppendMessageResult().getWroteBytes());
            }
            this.brokerController.getBrokerStatsManager().incTopicPutNums(msg.getTopic(), putMessageResult.getAppendMessageResult().getMsgNum(), 1);
            this.brokerController.getBrokerStatsManager().incTopicPutSize(msg.getTopic(), putMessageResult.getAppendMessageResult().getWroteBytes());
            this.brokerController.getBrokerStatsManager().incBrokerPutNums(putMessageResult.getAppendMessageResult().getMsgNum());
            response.setRemark(null);
            responseHeader.setMsgId(putMessageResult.getAppendMessageResult().getMsgId());
            responseHeader.setQueueId(Integer.valueOf(queueIdInt));
            responseHeader.setQueueOffset(Long.valueOf(putMessageResult.getAppendMessageResult().getLogicsOffset()));
            if (this.hasSendMessageHook()) {
                sendMessageContext.setMsgId(responseHeader.getMsgId());
                sendMessageContext.setQueueId(responseHeader.getQueueId());
                sendMessageContext.setQueueOffset(responseHeader.getQueueOffset());
                int commercialBaseCount = this.brokerController.getBrokerConfig().getCommercialBaseCount();
                int wroteSize = putMessageResult.getAppendMessageResult().getWroteBytes();
                int incValue = (int)Math.ceil((double)wroteSize / 65536.0) * commercialBaseCount;
                sendMessageContext.setCommercialSendStats(BrokerStatsManager.StatsType.SEND_SUCCESS);
                sendMessageContext.setCommercialSendTimes(incValue);
                sendMessageContext.setCommercialSendSize(wroteSize);
                sendMessageContext.setCommercialOwner(owner);
            }
            return response;
        }
        if (this.hasSendMessageHook()) {
            int wroteSize = request.getBody().length;
            int incValue = (int)Math.ceil((double)wroteSize / 65536.0);
            sendMessageContext.setCommercialSendStats(BrokerStatsManager.StatsType.SEND_FAILURE);
            sendMessageContext.setCommercialSendTimes(incValue);
            sendMessageContext.setCommercialSendSize(wroteSize);
            sendMessageContext.setCommercialOwner(owner);
        }
        return response;
    }

    private CompletableFuture<RemotingCommand> asyncSendBatchMessage(ChannelHandlerContext ctx, RemotingCommand request, SendMessageContext mqtraceContext, SendMessageRequestHeader requestHeader) {
        RemotingCommand response = this.preSend(ctx, request, requestHeader);
        SendMessageResponseHeader responseHeader = (SendMessageResponseHeader)response.readCustomHeader();
        if (response.getCode() != -1) {
            return CompletableFuture.completedFuture(response);
        }
        int queueIdInt = requestHeader.getQueueId();
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
        if (queueIdInt < 0) {
            queueIdInt = this.randomQueueId(topicConfig.getWriteQueueNums());
        }
        if (requestHeader.getTopic().length() > 127) {
            response.setCode(13);
            response.setRemark("message topic length too long " + requestHeader.getTopic().length());
            return CompletableFuture.completedFuture(response);
        }
        MessageExtBatch messageExtBatch = new MessageExtBatch();
        messageExtBatch.setTopic(requestHeader.getTopic());
        messageExtBatch.setQueueId(queueIdInt);
        int sysFlag = requestHeader.getSysFlag();
        if (TopicFilterType.MULTI_TAG == topicConfig.getTopicFilterType()) {
            sysFlag |= 2;
        }
        messageExtBatch.setSysFlag(sysFlag);
        messageExtBatch.setFlag(requestHeader.getFlag().intValue());
        MessageAccessor.setProperties((Message)messageExtBatch, (Map)MessageDecoder.string2messageProperties((String)requestHeader.getProperties()));
        messageExtBatch.setBody(request.getBody());
        messageExtBatch.setBornTimestamp(requestHeader.getBornTimestamp().longValue());
        messageExtBatch.setBornHost(ctx.channel().remoteAddress());
        messageExtBatch.setStoreHost(this.getStoreHost());
        messageExtBatch.setReconsumeTimes(requestHeader.getReconsumeTimes() == null ? 0 : requestHeader.getReconsumeTimes());
        String clusterName = this.brokerController.getBrokerConfig().getBrokerClusterName();
        MessageAccessor.putProperty((Message)messageExtBatch, (String)"CLUSTER", (String)clusterName);
        CompletableFuture putMessageResult = this.brokerController.getMessageStore().asyncPutMessages(messageExtBatch);
        return this.handlePutMessageResultFuture(putMessageResult, response, request, (MessageExt)messageExtBatch, responseHeader, mqtraceContext, ctx, queueIdInt);
    }

    public boolean hasConsumeMessageHook() {
        return this.consumeMessageHookList != null && !this.consumeMessageHookList.isEmpty();
    }

    public void executeConsumeMessageHookAfter(ConsumeMessageContext context) {
        if (this.hasConsumeMessageHook()) {
            for (ConsumeMessageHook hook : this.consumeMessageHookList) {
                try {
                    hook.consumeMessageAfter(context);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public SocketAddress getStoreHost() {
        return this.storeHost;
    }

    private String diskUtil() {
        String[] paths;
        double physicRatio = 100.0;
        MessageStore messageStore = this.brokerController.getMessageStore();
        String storePath = messageStore instanceof DefaultMessageStore ? ((DefaultMessageStore)messageStore).getStorePathPhysic() : this.brokerController.getMessageStoreConfig().getStorePathCommitLog();
        for (String storePathPhysic : paths = storePath.trim().split(MessageStoreConfig.MULTI_PATH_SPLITTER)) {
            physicRatio = Math.min(physicRatio, UtilAll.getDiskPartitionSpaceUsedPercent((String)storePathPhysic));
        }
        String storePathLogis = StorePathConfigHelper.getStorePathConsumeQueue((String)this.brokerController.getMessageStoreConfig().getStorePathRootDir());
        double logisRatio = UtilAll.getDiskPartitionSpaceUsedPercent((String)storePathLogis);
        String storePathIndex = StorePathConfigHelper.getStorePathIndex((String)this.brokerController.getMessageStoreConfig().getStorePathRootDir());
        double indexRatio = UtilAll.getDiskPartitionSpaceUsedPercent((String)storePathIndex);
        return String.format("CL: %5.2f CQ: %5.2f INDEX: %5.2f", physicRatio, logisRatio, indexRatio);
    }

    public void registerConsumeMessageHook(List<ConsumeMessageHook> consumeMessageHookList) {
        this.consumeMessageHookList = consumeMessageHookList;
    }

    private static ConsumeMessageContext buildConsumeMessageContext(String namespace, ConsumerSendMsgBackRequestHeader requestHeader, RemotingCommand request) {
        ConsumeMessageContext context = new ConsumeMessageContext();
        context.setNamespace(namespace);
        context.setConsumerGroup(requestHeader.getGroup());
        context.setTopic(requestHeader.getOriginTopic());
        context.setCommercialRcvStats(BrokerStatsManager.StatsType.SEND_BACK);
        context.setCommercialRcvTimes(1);
        context.setCommercialOwner((String)request.getExtFields().get("Owner"));
        return context;
    }

    private int randomQueueId(int writeQueueNums) {
        return ThreadLocalRandom.current().nextInt(99999999) % writeQueueNums;
    }

    private RemotingCommand preSend(ChannelHandlerContext ctx, RemotingCommand request, SendMessageRequestHeader requestHeader) {
        RemotingCommand response = RemotingCommand.createResponseCommand(SendMessageResponseHeader.class);
        response.setOpaque(request.getOpaque());
        response.addExtField("MSG_REGION", this.brokerController.getBrokerConfig().getRegionId());
        response.addExtField("TRACE_ON", String.valueOf(this.brokerController.getBrokerConfig().isTraceOn()));
        log.debug("Receive SendMessage request command {}", (Object)request);
        long startTimestamp = this.brokerController.getBrokerConfig().getStartAcceptSendRequestTimeStamp();
        if (this.brokerController.getMessageStore().now() < startTimestamp) {
            response.setCode(1);
            response.setRemark(String.format("broker unable to service, until %s", UtilAll.timeMillisToHumanString2((long)startTimestamp)));
            return response;
        }
        response.setCode(-1);
        super.msgCheck(ctx, requestHeader, response);
        return response;
    }
}

