/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.webhook.admin;

import com.alibaba.nacos.api.config.ConfigFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.webhook.api.Manufacturer;
import org.apache.eventmesh.webhook.api.WebHookConfig;
import org.apache.eventmesh.webhook.api.WebHookConfigOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosWebHookConfigOperation
implements WebHookConfigOperation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NacosWebHookConfigOperation.class);
    private static final String CONSTANTS_WEBHOOK = "webhook";
    private final ConfigService configService;

    public NacosWebHookConfigOperation(Properties properties) throws NacosException {
        this.configService = ConfigFactory.createConfigService((Properties)properties);
        String manufacturers = this.configService.getConfig("manufacturers.json", CONSTANTS_WEBHOOK, 3000L);
        if (manufacturers == null) {
            this.configService.publishConfig("manufacturers.json", CONSTANTS_WEBHOOK, JsonUtils.toJSONString((Object)new Manufacturer()), ConfigType.JSON.getType());
        }
    }

    public Integer insertWebHookConfig(WebHookConfig webHookConfig) {
        Boolean result;
        if (!webHookConfig.getCallbackPath().startsWith("/webhook")) {
            log.error("webhookConfig callback path must start with {}", (Object)"/webhook");
            return 0;
        }
        String manufacturerName = webHookConfig.getManufacturerName();
        try {
            if (this.configService.getConfig(this.getWebHookConfigDataId(webHookConfig), this.getManuGroupId(webHookConfig), 3000L) != null) {
                log.error("insertWebHookConfig failed, config has existed");
                return 0;
            }
            result = this.configService.publishConfig(this.getWebHookConfigDataId(webHookConfig), this.getManuGroupId(webHookConfig), JsonUtils.toJSONString((Object)webHookConfig), ConfigType.JSON.getType());
        }
        catch (NacosException e) {
            log.error("insertWebHookConfig failed", (Throwable)e);
            return 0;
        }
        if (result.booleanValue()) {
            try {
                Manufacturer manufacturer = this.getManufacturersInfo();
                manufacturer.addManufacturer(manufacturerName);
                manufacturer.getManufacturerEvents(manufacturerName).add(this.getWebHookConfigDataId(webHookConfig));
                this.configService.publishConfig("manufacturers.json", CONSTANTS_WEBHOOK, JsonUtils.toJSONString((Object)manufacturer), ConfigType.JSON.getType());
            }
            catch (NacosException e) {
                log.error("update manufacturersInfo error", (Throwable)e);
                try {
                    this.configService.removeConfig(this.getWebHookConfigDataId(webHookConfig), this.getManuGroupId(webHookConfig));
                }
                catch (NacosException ex) {
                    log.error("rollback insertWebHookConfig failed", (Throwable)e);
                }
            }
        }
        return result != false ? 1 : 0;
    }

    public Integer updateWebHookConfig(WebHookConfig webHookConfig) {
        boolean result = false;
        try {
            if (this.configService.getConfig(this.getWebHookConfigDataId(webHookConfig), this.getManuGroupId(webHookConfig), 3000L) == null) {
                log.error("updateWebHookConfig failed, config is not existed");
                return 0;
            }
            result = this.configService.publishConfig(this.getWebHookConfigDataId(webHookConfig), this.getManuGroupId(webHookConfig), JsonUtils.toJSONString((Object)webHookConfig), ConfigType.JSON.getType());
        }
        catch (NacosException e) {
            log.error("updateWebHookConfig failed", (Throwable)e);
        }
        return result ? 1 : 0;
    }

    public Integer deleteWebHookConfig(WebHookConfig webHookConfig) {
        boolean result = false;
        String manufacturerName = webHookConfig.getManufacturerName();
        try {
            result = this.configService.removeConfig(this.getWebHookConfigDataId(webHookConfig), this.getManuGroupId(webHookConfig));
        }
        catch (NacosException e) {
            log.error("deleteWebHookConfig failed", (Throwable)e);
        }
        if (result) {
            try {
                Manufacturer manufacturer = this.getManufacturersInfo();
                manufacturer.getManufacturerEvents(manufacturerName).remove(this.getWebHookConfigDataId(webHookConfig));
                this.configService.publishConfig("manufacturers.json", CONSTANTS_WEBHOOK, JsonUtils.toJSONString((Object)manufacturer), ConfigType.JSON.getType());
            }
            catch (NacosException e) {
                log.error("update manufacturersInfo error", (Throwable)e);
            }
        }
        return result ? 1 : 0;
    }

    public WebHookConfig queryWebHookConfigById(WebHookConfig webHookConfig) {
        try {
            String content = this.configService.getConfig(this.getWebHookConfigDataId(webHookConfig), this.getManuGroupId(webHookConfig), 3000L);
            return (WebHookConfig)JsonUtils.parseObject((String)content, WebHookConfig.class);
        }
        catch (NacosException e) {
            log.error("queryWebHookConfigById failed", (Throwable)e);
            return null;
        }
    }

    public List<WebHookConfig> queryWebHookConfigByManufacturer(WebHookConfig webHookConfig, Integer pageNum, Integer pageSize) {
        ArrayList<WebHookConfig> webHookConfigs = new ArrayList<WebHookConfig>();
        String manufacturerName = webHookConfig.getManufacturerName();
        try {
            List manufacturerEvents = this.getManufacturersInfo().getManufacturerEvents(manufacturerName);
            int startIndex = (pageNum - 1) * pageSize;
            int endIndex = pageNum * pageSize - 1;
            if (manufacturerEvents.size() > startIndex) {
                for (int i = startIndex; i < endIndex && i < manufacturerEvents.size(); ++i) {
                    String content = this.configService.getConfig((String)manufacturerEvents.get(i) + ".json", this.getManuGroupId(webHookConfig), 3000L);
                    webHookConfigs.add((WebHookConfig)JsonUtils.parseObject((String)content, WebHookConfig.class));
                }
            }
        }
        catch (NacosException e) {
            log.error("queryWebHookConfigByManufacturer failed", (Throwable)e);
        }
        return webHookConfigs;
    }

    private String getWebHookConfigDataId(WebHookConfig webHookConfig) {
        String dataId = webHookConfig.getCallbackPath();
        if (dataId.startsWith("/")) {
            dataId = dataId.substring(1);
        }
        return dataId.replaceAll("[@#$%^&*,/\\\\]", ".") + ".json";
    }

    private String getManuGroupId(WebHookConfig webHookConfig) {
        return "webhook_" + webHookConfig.getManufacturerName();
    }

    private Manufacturer getManufacturersInfo() throws NacosException {
        String manufacturersContent = this.configService.getConfig("manufacturers.json", CONSTANTS_WEBHOOK, 3000L);
        return StringUtil.isNullOrEmpty((String)manufacturersContent) ? new Manufacturer() : (Manufacturer)JsonUtils.parseObject((String)manufacturersContent, Manufacturer.class);
    }
}

