/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.connector.core.util;

import com.alibaba.otter.canal.connector.core.consumer.CommonMessage;
import com.alibaba.otter.canal.connector.core.util.JdbcTypeUtil;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.Message;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MessageUtil {
    public static List<CommonMessage> convert(Message message) {
        if (message == null) {
            return null;
        }
        List entries = message.getEntries();
        ArrayList<CommonMessage> msgs = new ArrayList<CommonMessage>(entries.size());
        for (CanalEntry.Entry entry : entries) {
            CanalEntry.RowChange rowChange;
            if (entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONBEGIN || entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONEND) continue;
            try {
                rowChange = CanalEntry.RowChange.parseFrom((ByteString)entry.getStoreValue());
            }
            catch (Exception e) {
                throw new RuntimeException("ERROR ## parser of eromanga-event has an error , data:" + entry.toString(), e);
            }
            CanalEntry.EventType eventType = rowChange.getEventType();
            CommonMessage msg = new CommonMessage();
            msg.setIsDdl(rowChange.getIsDdl());
            msg.setDatabase(entry.getHeader().getSchemaName());
            msg.setTable(entry.getHeader().getTableName());
            msg.setType(eventType.toString());
            msg.setEs(entry.getHeader().getExecuteTime());
            msg.setIsDdl(rowChange.getIsDdl());
            msg.setTs(System.currentTimeMillis());
            msg.setSql(rowChange.getSql());
            msgs.add(msg);
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> old = new ArrayList<Map<String, Object>>();
            if (rowChange.getIsDdl()) continue;
            HashSet<String> updateSet = new HashSet<String>();
            msg.setPkNames(new ArrayList<String>());
            int i = 0;
            for (CanalEntry.RowData rowData : rowChange.getRowDatasList()) {
                if (eventType != CanalEntry.EventType.INSERT && eventType != CanalEntry.EventType.UPDATE && eventType != CanalEntry.EventType.DELETE) continue;
                LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
                List columns = eventType == CanalEntry.EventType.DELETE ? rowData.getBeforeColumnsList() : rowData.getAfterColumnsList();
                for (CanalEntry.Column column : columns) {
                    if (i == 0 && column.getIsKey()) {
                        msg.getPkNames().add(column.getName());
                    }
                    if (column.getIsNull()) {
                        row.put(column.getName(), null);
                    } else {
                        row.put(column.getName(), JdbcTypeUtil.typeConvert(msg.getTable(), column.getName(), column.getValue(), column.getSqlType(), column.getMysqlType()));
                    }
                    if (!column.getUpdated()) continue;
                    updateSet.add(column.getName());
                }
                if (!row.isEmpty()) {
                    data.add(row);
                }
                if (eventType == CanalEntry.EventType.UPDATE) {
                    LinkedHashMap<String, Object> rowOld = new LinkedHashMap<String, Object>();
                    for (CanalEntry.Column column : rowData.getBeforeColumnsList()) {
                        if (!updateSet.contains(column.getName())) continue;
                        if (column.getIsNull()) {
                            rowOld.put(column.getName(), null);
                            continue;
                        }
                        rowOld.put(column.getName(), JdbcTypeUtil.typeConvert(msg.getTable(), column.getName(), column.getValue(), column.getSqlType(), column.getMysqlType()));
                    }
                    if (!rowOld.isEmpty()) {
                        old.add(rowOld);
                    }
                }
                ++i;
            }
            if (!data.isEmpty()) {
                msg.setData(data);
            }
            if (old.isEmpty()) continue;
            msg.setOld(old);
        }
        return msgs;
    }
}

