/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.meta.etcd.service;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.options.GetOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.api.exception.MetaException;
import org.apache.eventmesh.api.meta.bo.EventMeshAppSubTopicInfo;
import org.apache.eventmesh.api.meta.bo.EventMeshServicePubTopicInfo;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.meta.etcd.service.EtcdMetaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdCustomService
extends EtcdMetaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EtcdCustomService.class);
    private static final String KEY_PREFIX = "eventMesh/";
    private static final String KEY_APP = "app";
    private static final String KEY_SERVICE = "service";

    @Nullable
    public List<EventMeshServicePubTopicInfo> findEventMeshServicePubTopicInfos() throws MetaException {
        Client client = this.getEtcdClient();
        String keyPrefix = "eventMesh/service/";
        List keyValues = null;
        try {
            ArrayList<EventMeshServicePubTopicInfo> eventMeshServicePubTopicInfoList = new ArrayList<EventMeshServicePubTopicInfo>();
            ByteSequence keyByteSequence = ByteSequence.from((byte[])keyPrefix.getBytes(Constants.DEFAULT_CHARSET));
            GetOption getOption = GetOption.newBuilder().withPrefix(keyByteSequence).build();
            keyValues = ((GetResponse)client.getKVClient().get(keyByteSequence, getOption).get()).getKvs();
            if (CollectionUtils.isNotEmpty((Collection)keyValues)) {
                for (KeyValue kv : keyValues) {
                    EventMeshServicePubTopicInfo eventMeshServicePubTopicInfo = (EventMeshServicePubTopicInfo)JsonUtils.parseObject((String)new String(kv.getValue().getBytes(), Constants.DEFAULT_CHARSET), EventMeshServicePubTopicInfo.class);
                    eventMeshServicePubTopicInfoList.add(eventMeshServicePubTopicInfo);
                }
                return eventMeshServicePubTopicInfoList;
            }
        }
        catch (InterruptedException e) {
            log.error("[EtcdRegistryService][findEventMeshServicePubTopicInfos] InterruptedException", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error("[EtcdRegistryService][findEventMeshServicePubTopicInfos] error", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
        return Collections.emptyList();
    }

    @Nullable
    public EventMeshAppSubTopicInfo findEventMeshAppSubTopicInfoByGroup(String group) throws MetaException {
        Client client = this.getEtcdClient();
        String keyPrefix = "eventMesh/app/" + group;
        List keyValues = null;
        try {
            ByteSequence keyByteSequence = ByteSequence.from((byte[])keyPrefix.getBytes(Constants.DEFAULT_CHARSET));
            GetOption getOption = GetOption.newBuilder().withPrefix(keyByteSequence).build();
            keyValues = ((GetResponse)client.getKVClient().get(keyByteSequence, getOption).get()).getKvs();
            if (CollectionUtils.isNotEmpty((Collection)keyValues)) {
                return (EventMeshAppSubTopicInfo)JsonUtils.parseObject((String)new String(((KeyValue)keyValues.get(0)).getValue().getBytes(), Constants.DEFAULT_CHARSET), EventMeshAppSubTopicInfo.class);
            }
        }
        catch (InterruptedException e) {
            log.error("[EtcdRegistryService][findEventMeshAppSubTopicInfoByGroup] InterruptedException", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error("[EtcdRegistryService][findEventMeshAppSubTopicInfoByGroup] error, group: {}", (Object)group, (Object)e);
            throw new MetaException(e.getMessage());
        }
        return null;
    }
}

