/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.util;

import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class JarFileUtils {
    private JarFileUtils() {
    }

    public static String getManifestValue(JarFile jarFile, String key, String defaultValue) {
        Manifest manifest = JarFileUtils.getManifest(jarFile);
        if (manifest == null) {
            return defaultValue;
        }
        Attributes attributes = manifest.getMainAttributes();
        return JarFileUtils.getValue(attributes, key, defaultValue);
    }

    public static String getValue(Attributes attributes, String key, String defaultValue) {
        String value = attributes.getValue(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static Manifest getManifest(JarFile pluginJarFile) {
        try {
            return pluginJarFile.getManifest();
        }
        catch (IOException ex) {
            return null;
        }
    }
}

