/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc.stream;

import com.navercorp.pinpoint.profiler.sender.grpc.ClientStreamingService;
import com.navercorp.pinpoint.profiler.sender.grpc.MessageDispatcher;
import com.navercorp.pinpoint.profiler.sender.grpc.StreamId;
import com.navercorp.pinpoint.profiler.sender.grpc.StreamState;
import com.navercorp.pinpoint.profiler.sender.grpc.StreamTask;
import com.navercorp.pinpoint.profiler.sender.grpc.stream.StreamExecutor;
import com.navercorp.pinpoint.profiler.sender.grpc.stream.StreamExecutorFactory;
import com.navercorp.pinpoint.profiler.sender.grpc.stream.StreamJob;
import com.navercorp.pinpoint.profiler.util.NamedRunnable;
import io.grpc.stub.ClientCallStreamObserver;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultStreamTask<M, ReqT, ResT>
implements StreamTask<M, ReqT> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final StreamId streamId;
    private final ClientStreamingService<ReqT, ResT> clientStreamingService;
    private final StreamExecutorFactory<ReqT> streamExecutorFactory;
    private final BlockingQueue<M> queue;
    private final MessageDispatcher<M, ReqT> dispatcher;
    private final StreamState failState;
    private volatile ClientCallStreamObserver<ReqT> stream;
    private volatile CountDownLatch latch;
    private volatile boolean stop = false;

    public DefaultStreamTask(String id, ClientStreamingService<ReqT, ResT> clientStreamingService, StreamExecutorFactory<ReqT> streamExecutorFactory, BlockingQueue<M> queue, MessageDispatcher<M, ReqT> dispatcher, StreamState failState) {
        this.streamId = StreamId.newStreamId(id);
        this.clientStreamingService = Objects.requireNonNull(clientStreamingService, "clientStreamingService");
        this.streamExecutorFactory = Objects.requireNonNull(streamExecutorFactory, "streamExecutorFactory");
        this.queue = Objects.requireNonNull(queue, "queue");
        this.dispatcher = Objects.requireNonNull(dispatcher, "dispatcher");
        this.failState = Objects.requireNonNull(failState, "failState");
    }

    @Override
    public void start() {
        this.latch = new CountDownLatch(1);
        StreamJob job = new StreamJob<ReqT>(){

            @Override
            public Future<?> start(ClientCallStreamObserver<ReqT> requestStream) {
                Runnable runnable = DefaultStreamTask.this.newRunnable(requestStream, DefaultStreamTask.this.latch);
                StreamExecutor streamExecutor = DefaultStreamTask.this.streamExecutorFactory.newStreamExecutor();
                return streamExecutor.execute(runnable);
            }

            public String toString() {
                return DefaultStreamTask.this.streamId.toString();
            }
        };
        this.stream = this.clientStreamingService.newStream(job);
    }

    public Runnable newRunnable(final ClientCallStreamObserver<ReqT> requestStream, final CountDownLatch latch) {
        return new NamedRunnable(this.streamId.toString()){

            @Override
            public void run() {
                this.dispatch(requestStream);
            }

            private void dispatch(ClientCallStreamObserver<ReqT> stream) {
                DefaultStreamTask.this.logger.info("dispatch start {}", (Object)this);
                FinishStatus status = FinishStatus.UNKNOWN;
                try {
                    Thread thread = Thread.currentThread();
                    while (!thread.isInterrupted()) {
                        Object message = DefaultStreamTask.this.queue.take();
                        if (stream.isReady()) {
                            try {
                                DefaultStreamTask.this.dispatcher.onDispatch(stream, message);
                            }
                            catch (Exception e) {
                                DefaultStreamTask.this.logger.warn("dispatch failed", (Throwable)e);
                            }
                            DefaultStreamTask.this.failState.success();
                            continue;
                        }
                        DefaultStreamTask.this.failState.fail();
                        if (!DefaultStreamTask.this.failState.isFailure()) continue;
                        DefaultStreamTask.this.logger.info("isReadyState error, Trigger stream.cancel {}", (Object)this);
                        stream.cancel("isReadyState error", (Throwable)new Exception("isReadyState error"));
                        status = FinishStatus.ISREADY_ERROR;
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    DefaultStreamTask.this.logger.debug("dispatch thread interrupted {}/{}", (Object)Thread.currentThread().getName(), (Object)this);
                    status = FinishStatus.INTERRUPTED;
                }
                catch (Throwable th) {
                    DefaultStreamTask.this.logger.error("Unexpected DispatchThread error {}/{}", (Object)Thread.currentThread().getName(), (Object)this, (Object)th);
                    stream.onError(th);
                }
                DefaultStreamTask.this.logger.info("dispatch thread end status:{} {}", (Object)status, (Object)this);
                latch.countDown();
            }
        };
    }

    @Override
    public void stop() {
        CountDownLatch latch;
        this.logger.info("stop start {}", (Object)this.streamId);
        this.stop = true;
        ClientCallStreamObserver<ReqT> copy = this.stream;
        if (copy != null) {
            copy.onCompleted();
        }
        if ((latch = this.latch) != null) {
            try {
                latch.await(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.logger.info("stop end {}", (Object)this.streamId);
    }

    public boolean isStop() {
        return this.stop;
    }

    public String toString() {
        return "DefaultStreamTask{" + this.streamId + '}';
    }

    static enum FinishStatus {
        UNKNOWN,
        INTERRUPTED,
        ISREADY_ERROR;

    }
}

