/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc;

import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SubconnectionExpiringLoadBalancer
extends LoadBalancer {
    private static final Logger logger = LogManager.getLogger(SubconnectionExpiringLoadBalancer.class);
    private final long subchannelMaxAgeMillis;
    private final LoadBalancer.Helper helper;
    private List<EquivalentAddressGroup> currentAddresses;
    private LoadBalancer.Subchannel readySubchannel;
    private LoadBalancer.Subchannel failureSubchannel;
    private LoadBalancer.Subchannel connectingSubchannel;
    private Status failureStatus;
    private boolean initialized = false;
    static final Attributes.Key<AtomicReference<PickProgress>> ATTR_PICK_PROGRESS = Attributes.Key.create((String)"pick_progress");
    static final Attributes.Key<Long> ATTR_CREATED_AT = Attributes.Key.create((String)"created_at");

    SubconnectionExpiringLoadBalancer(LoadBalancer.Helper helper, long renewPeriod, TimeUnit renewTimeUnit) {
        this.helper = helper;
        this.subchannelMaxAgeMillis = renewTimeUnit.toMillis(renewPeriod);
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        List addresses = resolvedAddresses.getAddresses();
        this.updateAddresses(addresses);
        this.currentAddresses = addresses;
        if (!this.initialized) {
            this.initialized = true;
            this.createSubchannel();
            this.helper.updateBalancingState(ConnectivityState.CONNECTING, (LoadBalancer.SubchannelPicker)new Picker(LoadBalancer.PickResult.withNoResult()));
        }
    }

    private void updateAddresses(List<EquivalentAddressGroup> addresses) {
        if (this.readySubchannel != null) {
            this.readySubchannel.updateAddresses(addresses);
        }
        if (this.failureSubchannel != null) {
            this.failureSubchannel.updateAddresses(addresses);
        }
        if (this.connectingSubchannel != null) {
            this.connectingSubchannel.updateAddresses(addresses);
        }
    }

    private void createSubchannel() {
        LoadBalancer.Subchannel subchannel = this.helper.createSubchannel(LoadBalancer.CreateSubchannelArgs.newBuilder().setAddresses(this.currentAddresses).setAttributes(Attributes.newBuilder().set(ATTR_PICK_PROGRESS, new AtomicReference<PickProgress>(PickProgress.NOT_PICKED_YET)).set(ATTR_CREATED_AT, (Object)System.currentTimeMillis()).build()).build());
        subchannel.start(stateInfo -> {
            ConnectivityState state = stateInfo.getState();
            if (state == ConnectivityState.SHUTDOWN) {
                return;
            }
            if (state == ConnectivityState.TRANSIENT_FAILURE || state == ConnectivityState.IDLE) {
                this.helper.refreshNameResolution();
            }
            this.moveTo(subchannel, stateInfo);
            this.updateBalancingState();
        });
        subchannel.requestConnection();
    }

    private void moveTo(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
        ConnectivityState position;
        if (this.readySubchannel == subchannel) {
            this.readySubchannel = null;
        }
        if (this.failureSubchannel == subchannel) {
            this.failureSubchannel = null;
        }
        if (this.connectingSubchannel == subchannel) {
            this.connectingSubchannel = null;
        }
        if ((position = stateInfo.getState()) == ConnectivityState.READY) {
            if (this.readySubchannel != null) {
                this.readySubchannel.shutdown();
                logger.info("{} is replaced with {}", (Object)this.readySubchannel, (Object)subchannel);
            } else {
                logger.info("{} is now on READY", (Object)subchannel);
            }
            this.readySubchannel = subchannel;
        } else if (position == ConnectivityState.TRANSIENT_FAILURE) {
            if (this.failureSubchannel != null) {
                subchannel.shutdown();
                logger.info("{} is shutdown by conflict in FAILURE", (Object)subchannel);
            } else {
                this.failureSubchannel = subchannel;
                this.failureStatus = stateInfo.getStatus();
                logger.info("{} is now on FAILURE", (Object)subchannel);
            }
        } else if (position == ConnectivityState.CONNECTING) {
            if (this.connectingSubchannel != null) {
                subchannel.shutdown();
                logger.info("{} is shutdown by conflict in CONNECTING", (Object)subchannel);
            } else {
                this.connectingSubchannel = subchannel;
                logger.info("{} is now on CONNECTING", (Object)subchannel);
            }
        } else if (position == ConnectivityState.IDLE) {
            subchannel.requestConnection();
            logger.info("{} requested connection", (Object)subchannel);
        }
        logger.info("SE-LB state: { READY: {}, FAILURE: {}, CONNECTING: {} }", (Object)this.readySubchannel, (Object)this.failureSubchannel, (Object)this.connectingSubchannel);
    }

    private void updateBalancingState() {
        if (this.readySubchannel != null) {
            this.helper.updateBalancingState(ConnectivityState.READY, (LoadBalancer.SubchannelPicker)new Picker(LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)this.readySubchannel), args -> this.requestSuccessor(this.readySubchannel)));
            return;
        }
        if (this.connectingSubchannel != null) {
            this.helper.updateBalancingState(ConnectivityState.CONNECTING, (LoadBalancer.SubchannelPicker)new Picker(LoadBalancer.PickResult.withNoResult()));
            return;
        }
        if (this.failureSubchannel != null) {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new Picker(LoadBalancer.PickResult.withError((Status)this.failureStatus)));
            return;
        }
        this.helper.updateBalancingState(ConnectivityState.IDLE, (LoadBalancer.SubchannelPicker)new Picker(LoadBalancer.PickResult.withNoResult()));
    }

    private void requestSuccessor(LoadBalancer.Subchannel subchannel) {
        AtomicReference<PickProgress> progress;
        if (this.subchannelMaxAgeMillis >= TimeUnit.DAYS.toMillis(365L)) {
            return;
        }
        long createdAt = this.getCreatedAt(subchannel);
        if (createdAt < System.currentTimeMillis() - this.subchannelMaxAgeMillis && (progress = this.getPickProgress(subchannel)) != null && progress.compareAndSet(PickProgress.NOT_PICKED_YET, PickProgress.PICKED)) {
            this.helper.getSynchronizationContext().execute(this::createSubchannel);
        }
    }

    public void requestConnection() {
        if (this.readySubchannel != null) {
            return;
        }
        this.createSubchannel();
    }

    public void handleNameResolutionError(Status error) {
        this.clear();
        this.updateBalancingState();
    }

    public void shutdown() {
        this.clear();
    }

    private void clear() {
        if (this.readySubchannel != null) {
            this.readySubchannel.shutdown();
            this.readySubchannel = null;
        }
        if (this.connectingSubchannel != null) {
            this.connectingSubchannel.shutdown();
            this.connectingSubchannel = null;
        }
        if (this.failureSubchannel != null) {
            this.failureSubchannel.shutdown();
            this.failureSubchannel = null;
        }
    }

    @Nullable
    private AtomicReference<PickProgress> getPickProgress(LoadBalancer.Subchannel subchannel) {
        AtomicReference pickProgress = (AtomicReference)subchannel.getAttributes().get(ATTR_PICK_PROGRESS);
        if (pickProgress == null) {
            logger.warn("{} does not have pickProgress", (Object)subchannel);
        }
        return pickProgress;
    }

    private long getCreatedAt(LoadBalancer.Subchannel subchannel) {
        Long createdAt = (Long)subchannel.getAttributes().get(ATTR_CREATED_AT);
        if (createdAt == null) {
            return 0L;
        }
        return createdAt;
    }

    private static enum PickProgress {
        NOT_PICKED_YET,
        PICKED;

    }

    private static final class Picker
    extends LoadBalancer.SubchannelPicker {
        private final LoadBalancer.PickResult result;
        private final Consumer<LoadBalancer.PickSubchannelArgs> beforePick;

        Picker(LoadBalancer.PickResult result) {
            this(result, null);
        }

        Picker(LoadBalancer.PickResult result, Consumer<LoadBalancer.PickSubchannelArgs> beforePick) {
            this.result = result;
            this.beforePick = beforePick;
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            if (this.beforePick != null) {
                this.beforePick.accept(args);
            }
            return this.result;
        }
    }
}

