/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.instrument.DynamicTransformTrigger;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matcher;
import com.navercorp.pinpoint.profiler.plugin.ClassFileTransformerDelegate;
import com.navercorp.pinpoint.profiler.plugin.MatchableClassFileTransformerDelegate;
import com.navercorp.pinpoint.profiler.plugin.TransformCallbackProvider;
import java.lang.instrument.ClassFileTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ClassFileTransformerLoader {
    private final ProfilerConfig profilerConfig;
    private final DynamicTransformTrigger dynamicTransformTrigger;
    private final List<ClassFileTransformer> classTransformers = new ArrayList<ClassFileTransformer>();

    public ClassFileTransformerLoader(ProfilerConfig profilerConfig, DynamicTransformTrigger dynamicTransformTrigger) {
        this.profilerConfig = Objects.requireNonNull(profilerConfig, "profilerConfig");
        this.dynamicTransformTrigger = Objects.requireNonNull(dynamicTransformTrigger, "dynamicTransformTrigger");
    }

    public void addClassFileTransformer(InstrumentContext instrumentContext, Matcher matcher, TransformCallbackProvider transformCallbackProvider) {
        Objects.requireNonNull(instrumentContext, "instrumentContext");
        Objects.requireNonNull(transformCallbackProvider, "transformCallbackProvider");
        MatchableClassFileTransformerDelegate guard = new MatchableClassFileTransformerDelegate(this.profilerConfig, instrumentContext, matcher, transformCallbackProvider);
        this.classTransformers.add(guard);
    }

    public void addClassFileTransformer(InstrumentContext instrumentContext, ClassLoader classLoader, String targetClassName, TransformCallbackProvider transformCallbackProvider) {
        Objects.requireNonNull(targetClassName, "targetClassName");
        Objects.requireNonNull(transformCallbackProvider, "transformCallbackProvider");
        ClassFileTransformerDelegate classFileTransformerGuardDelegate = new ClassFileTransformerDelegate(this.profilerConfig, instrumentContext, transformCallbackProvider);
        this.dynamicTransformTrigger.addClassFileTransformer(classLoader, targetClassName, (ClassFileTransformer)classFileTransformerGuardDelegate);
    }

    public List<ClassFileTransformer> getClassTransformerList() {
        return this.classTransformers;
    }
}

