/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.objectfactory;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.plugin.ObjectFactory;
import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.objectfactory.ArgumentProvider;
import com.navercorp.pinpoint.profiler.objectfactory.ArgumentsResolver;
import com.navercorp.pinpoint.profiler.objectfactory.ConstructorResolver;
import com.navercorp.pinpoint.profiler.objectfactory.OrderedValueProvider;
import com.navercorp.pinpoint.profiler.objectfactory.ProfilerPluginArgumentProvider;
import com.navercorp.pinpoint.profiler.objectfactory.StaticMethodResolver;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoBindingObjectFactory {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final InstrumentContext pluginContext;
    private final ClassLoader classLoader;
    private final List<ArgumentProvider> commonProviders;

    public AutoBindingObjectFactory(ProfilerConfig profilerConfig, TraceContext traceContext, InstrumentContext pluginContext, ClassLoader classLoader, ArgumentProvider ... argumentProviders) {
        Objects.requireNonNull(profilerConfig, "profilerConfig");
        Objects.requireNonNull(traceContext, "traceContext");
        this.pluginContext = Objects.requireNonNull(pluginContext, "pluginContext");
        this.classLoader = classLoader;
        this.commonProviders = this.newArgumentProvider(profilerConfig, traceContext, pluginContext, argumentProviders);
    }

    private List<ArgumentProvider> newArgumentProvider(ProfilerConfig profilerConfig, TraceContext traceContext, InstrumentContext pluginContext, ArgumentProvider[] argumentProviders) {
        ArrayList<ArgumentProvider> commonProviders = new ArrayList<ArgumentProvider>();
        commonProviders.addAll(Arrays.asList(argumentProviders));
        ProfilerPluginArgumentProvider profilerPluginArgumentProvider = new ProfilerPluginArgumentProvider(profilerConfig, traceContext, pluginContext);
        commonProviders.add(profilerPluginArgumentProvider);
        return commonProviders;
    }

    public Object createInstance(ObjectFactory objectFactory, ArgumentProvider ... providers) {
        Class type = this.pluginContext.injectClass(this.classLoader, objectFactory.getClassName());
        Object[] arguments = objectFactory.getArguments();
        ArgumentsResolver argumentsResolver = this.getArgumentResolver(arguments, providers);
        if (objectFactory instanceof ObjectFactory.ByConstructor) {
            return this.byConstructor(type, argumentsResolver);
        }
        if (objectFactory instanceof ObjectFactory.ByStaticFactoryMethod) {
            return this.byStaticFactoryMethod(type, (ObjectFactory.ByStaticFactoryMethod)objectFactory, argumentsResolver);
        }
        throw new IllegalArgumentException("Unknown objectFactory type: " + objectFactory);
    }

    public Object createInstance(Class<?> type, Object[] arguments, ArgumentProvider ... providers) {
        ArgumentsResolver argumentsResolver = this.getArgumentResolver(arguments, providers);
        return this.byConstructor(type, argumentsResolver);
    }

    private Object byConstructor(Class<?> type, ArgumentsResolver argumentsResolver) {
        ConstructorResolver resolver = new ConstructorResolver(type, argumentsResolver);
        if (!resolver.resolve()) {
            throw new PinpointException("Cannot find suitable constructor for " + type.getName());
        }
        Constructor<?> constructor = resolver.getResolvedConstructor();
        Object[] resolvedArguments = resolver.getResolvedArguments();
        if (this.isDebug) {
            this.logger.debug("Create instance by constructor {}, with arguments {}", constructor, (Object)Arrays.toString(resolvedArguments));
        }
        try {
            return constructor.newInstance(resolvedArguments);
        }
        catch (ReflectiveOperationException e) {
            throw new PinpointException("Fail to invoke constructor: " + constructor + ", arguments: " + Arrays.toString(resolvedArguments), (Throwable)e);
        }
    }

    private Object byStaticFactoryMethod(Class<?> type, ObjectFactory.ByStaticFactoryMethod staticFactoryMethod, ArgumentsResolver argumentsResolver) {
        StaticMethodResolver resolver = new StaticMethodResolver(type, staticFactoryMethod.getFactoryMethodName(), argumentsResolver);
        if (!resolver.resolve()) {
            throw new PinpointException("Cannot find suitable factory method " + type.getName() + "." + staticFactoryMethod.getFactoryMethodName());
        }
        Method method = resolver.getResolvedMethod();
        Object[] resolvedArguments = resolver.getResolvedArguments();
        if (this.isDebug) {
            this.logger.debug("Create instance by static factory method {}, with arguments {}", (Object)method, (Object)Arrays.toString(resolvedArguments));
        }
        try {
            return method.invoke(null, resolvedArguments);
        }
        catch (ReflectiveOperationException e) {
            throw new PinpointException("Fail to invoke factory method: " + type.getName() + "." + staticFactoryMethod.getFactoryMethodName() + ", arguments: " + Arrays.toString(resolvedArguments), (Throwable)e);
        }
    }

    private ArgumentsResolver getArgumentResolver(Object[] argument, ArgumentProvider[] providers) {
        ArrayList<ArgumentProvider> merged = new ArrayList<ArgumentProvider>(this.commonProviders);
        merged.addAll(Arrays.asList(providers));
        if (argument != null) {
            merged.add(new OrderedValueProvider(this, argument));
        }
        return new ArgumentsResolver(merged);
    }
}

