/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.navercorp.pinpoint.common.profiler.concurrent.PinpointThreadFactory;
import com.navercorp.pinpoint.common.profiler.message.DataSender;
import com.navercorp.pinpoint.common.profiler.message.EmptyDataSender;
import com.navercorp.pinpoint.profiler.context.module.AgentId;
import com.navercorp.pinpoint.profiler.context.module.AgentStartTime;
import com.navercorp.pinpoint.profiler.context.module.StatDataSender;
import com.navercorp.pinpoint.profiler.context.monitor.config.MonitorConfig;
import com.navercorp.pinpoint.profiler.context.monitor.metric.CustomMetricRegistryService;
import com.navercorp.pinpoint.profiler.context.storage.UriStatStorage;
import com.navercorp.pinpoint.profiler.monitor.AgentStatMonitor;
import com.navercorp.pinpoint.profiler.monitor.CollectJob;
import com.navercorp.pinpoint.profiler.monitor.CustomMetricCollectingJob;
import com.navercorp.pinpoint.profiler.monitor.StatMonitorJob;
import com.navercorp.pinpoint.profiler.monitor.UriStatCollectingJob;
import com.navercorp.pinpoint.profiler.monitor.collector.AgentCustomMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentStatMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.MetricType;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultAgentStatMonitor
implements AgentStatMonitor {
    private static final long MIN_COLLECTION_INTERVAL_MS = 1000L;
    private static final long MAX_COLLECTION_INTERVAL_MS = 5000L;
    private static final long DEFAULT_COLLECTION_INTERVAL_MS = 5000L;
    private static final int DEFAULT_NUM_COLLECTIONS_PER_SEND = 6;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final long collectionIntervalMs;
    private final ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new PinpointThreadFactory("Pinpoint-stat-monitor", true));
    private final StatMonitorJob statMonitorJob;

    @Inject
    public DefaultAgentStatMonitor(@StatDataSender DataSender<MetricType> dataSender, @AgentId String agentId, @AgentStartTime long agentStartTimestamp, @Named(value="AgentStatCollector") AgentStatMetricCollector<AgentStatMetricSnapshot> agentStatCollector, CustomMetricRegistryService customMetricRegistryService, UriStatStorage uriStatStorage, MonitorConfig monitorConfig) {
        Objects.requireNonNull(dataSender, "dataSender");
        Objects.requireNonNull(agentId, "agentId");
        Objects.requireNonNull(agentStatCollector, "agentStatCollector");
        long collectionIntervalMs = monitorConfig.getProfileJvmStatCollectIntervalMs();
        int numCollectionsPerBatch = monitorConfig.getProfileJvmStatBatchSendCount();
        if (collectionIntervalMs < 1000L) {
            collectionIntervalMs = 5000L;
        }
        if (collectionIntervalMs > 5000L) {
            collectionIntervalMs = 5000L;
        }
        if (numCollectionsPerBatch < 1) {
            numCollectionsPerBatch = 6;
        }
        this.collectionIntervalMs = collectionIntervalMs;
        ArrayList<Runnable> runnableList = new ArrayList<Runnable>();
        CollectJob statCollectingJob = new CollectJob(dataSender, agentId, agentStartTimestamp, agentStatCollector, numCollectionsPerBatch);
        runnableList.add(statCollectingJob);
        if (monitorConfig.isCustomMetricEnable() && customMetricRegistryService != null) {
            CustomMetricCollectingJob customMetricCollectionJob = new CustomMetricCollectingJob(dataSender, new AgentCustomMetricCollector(customMetricRegistryService), numCollectionsPerBatch);
            runnableList.add(customMetricCollectionJob);
        }
        if (monitorConfig.isUriStatEnable() && uriStatStorage != null) {
            UriStatCollectingJob uriStatCollectingJob = new UriStatCollectingJob(dataSender, uriStatStorage);
            runnableList.add(uriStatCollectingJob);
        }
        this.statMonitorJob = new StatMonitorJob(runnableList);
        this.preLoadClass(agentId, agentStartTimestamp, agentStatCollector);
    }

    private void preLoadClass(String agentId, long agentStartTimestamp, AgentStatMetricCollector<AgentStatMetricSnapshot> agentStatCollector) {
        this.logger.debug("pre-load class start");
        CollectJob collectJob = new CollectJob((DataSender<MetricType>)EmptyDataSender.instance(), agentId, agentStartTimestamp, agentStatCollector, 1);
        collectJob.run();
        collectJob.run();
        this.logger.debug("pre-load class end");
    }

    @Override
    public void start() {
        this.executor.scheduleAtFixedRate(this.statMonitorJob, this.collectionIntervalMs, this.collectionIntervalMs, TimeUnit.MILLISECONDS);
        this.logger.info("AgentStat monitor started");
    }

    @Override
    public void stop() {
        this.statMonitorJob.close();
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.logger.info("AgentStat monitor stopped");
    }
}

